/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.internal.zzlv;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzak;
import com.google.android.gms.tagmanager.zzbf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

class zzv
implements DataLayer.zzc {
    private static final String zzayn = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' STRING NOT NULL, '%s' BLOB NOT NULL, '%s' INTEGER NOT NULL);", "datalayer", "ID", "key", "value", "expires");
    private final Executor zzayo;
    private final Context mContext;
    private zza zzayp;
    private zzlv zzmW;
    private int zzayq;

    public zzv(Context context) {
        this(context, zzlx.zzkc(), "google_tagmanager.db", 2000, Executors.newSingleThreadExecutor());
    }

    zzv(Context context, zzlv zzlv2, String string, int n, Executor executor) {
        this.mContext = context;
        this.zzmW = zzlv2;
        this.zzayq = n;
        this.zzayo = executor;
        this.zzayp = new zza(this.mContext, string);
    }

    @Override
    public void zza(List<DataLayer.zza> list, final long l) {
        final List<zzb> list2 = this.zzs(list);
        this.zzayo.execute(new Runnable(){

            @Override
            public void run() {
                zzv.this.zzb(list2, l);
            }
        });
    }

    @Override
    public void zza(final DataLayer.zzc.zza zza2) {
        this.zzayo.execute(new Runnable(){

            @Override
            public void run() {
                zza2.zzq(zzv.this.zzsY());
            }
        });
    }

    @Override
    public void zzcW(final String string) {
        this.zzayo.execute(new Runnable(){

            @Override
            public void run() {
                zzv.this.zzcX(string);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataLayer.zza> zzsY() {
        try {
            this.zzG(this.zzmW.currentTimeMillis());
            List<DataLayer.zza> list = this.zzr(this.zzsZ());
            return list;
        }
        finally {
            this.zztb();
        }
    }

    private List<DataLayer.zza> zzr(List<zzb> list) {
        ArrayList<DataLayer.zza> arrayList = new ArrayList<DataLayer.zza>();
        for (zzb zzb2 : list) {
            arrayList.add(new DataLayer.zza(zzb2.zzqd, this.zzk(zzb2.zzayw)));
        }
        return arrayList;
    }

    private List<zzb> zzs(List<DataLayer.zza> list) {
        ArrayList<zzb> arrayList = new ArrayList<zzb>();
        for (DataLayer.zza zza2 : list) {
            arrayList.add(new zzb(zza2.zzqd, this.zzp(zza2.zzzt)));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object zzk(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (IOException iOException) {
            Object var5_8 = null;
            return var5_8;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object var5_9 = null;
            return var5_9;
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] zzp(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void zzb(List<zzb> list, long l) {
        try {
            long l2 = this.zzmW.currentTimeMillis();
            this.zzG(l2);
            this.zzhd(list.size());
            this.zzc(list, l2 + l);
        }
        finally {
            this.zztb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<zzb> zzsZ() {
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for loadSerialized.");
        ArrayList<zzb> arrayList = new ArrayList<zzb>();
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        String[] stringArray = new String[]{"key", "value"};
        try (Cursor cursor = sQLiteDatabase.query("datalayer", stringArray, null, null, null, null, "ID", null);){
            while (cursor.moveToNext()) {
                arrayList.add(new zzb(cursor.getString(0), cursor.getBlob(1)));
            }
        }
        return arrayList;
    }

    private void zzc(List<zzb> list, long l) {
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for writeEntryToDatabase.");
        if (sQLiteDatabase == null) {
            return;
        }
        for (zzb zzb2 : list) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("expires", Long.valueOf(l));
            contentValues.put("key", zzb2.zzqd);
            contentValues.put("value", zzb2.zzayw);
            sQLiteDatabase.insert("datalayer", null, contentValues);
        }
    }

    private void zzhd(int n) {
        int n2 = this.zzta() - this.zzayq + n;
        if (n2 > 0) {
            List<String> list = this.zzhe(n2);
            zzbf.zzaa("DataLayer store full, deleting " + list.size() + " entries to make room.");
            this.zzg(list.toArray(new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzcX(String string) {
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for clearKeysWithPrefix.");
        if (sQLiteDatabase == null) {
            return;
        }
        try {
            int n = sQLiteDatabase.delete("datalayer", "key = ? OR key LIKE ?", new String[]{string, string + ".%"});
            zzbf.zzab("Cleared " + n + " items");
        }
        catch (SQLiteException sQLiteException) {
            zzbf.zzac("Error deleting entries with key prefix: " + string + " (" + (Object)((Object)sQLiteException) + ").");
        }
        finally {
            this.zztb();
        }
    }

    private void zzG(long l) {
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for deleteOlderThan.");
        if (sQLiteDatabase == null) {
            return;
        }
        try {
            int n = sQLiteDatabase.delete("datalayer", "expires <= ?", new String[]{Long.toString(l)});
            zzbf.zzab("Deleted " + n + " expired items");
        }
        catch (SQLiteException sQLiteException) {
            zzbf.zzac("Error deleting old entries.");
        }
    }

    private void zzg(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for deleteEntries.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string = String.format("%s in (%s)", "ID", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("datalayer", string, stringArray);
        }
        catch (SQLiteException sQLiteException) {
            zzbf.zzac("Error deleting entries " + Arrays.toString(stringArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> zzhe(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n <= 0) {
            zzbf.zzac("Invalid maxEntries specified. Skipping.");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for peekEntryIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("datalayer", new String[]{"ID"}, null, null, null, null, String.format("%s ASC", "ID"), Integer.toString(n));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zzta() {
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for getNumStoredEntries.");
        if (sQLiteDatabase == null) {
            return n;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from datalayer", null);
            if (cursor.moveToFirst()) {
                n = (int)cursor.getLong(0);
            }
        }
        return n;
    }

    private SQLiteDatabase zzar(String string) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.zzayp.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            zzbf.zzac(string);
            return null;
        }
        return sQLiteDatabase;
    }

    private void zztb() {
        try {
            this.zzayp.close();
        }
        catch (SQLiteException sQLiteException) {
            // empty catch block
        }
    }

    private static class zzb {
        final String zzqd;
        final byte[] zzayw;

        zzb(String string, byte[] byArray) {
            this.zzqd = string;
            this.zzayw = byArray;
        }

        public String toString() {
            return "KeyAndSerialized: key = " + this.zzqd + " serialized hash = " + Arrays.hashCode(this.zzayw);
        }
    }

    class zza
    extends SQLiteOpenHelper {
        zza(Context context, String string) {
            super(context, string, null, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(String string, SQLiteDatabase sQLiteDatabase) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            SQLiteDatabase sQLiteDatabase = null;
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zzv.this.mContext.getDatabasePath("google_tagmanager.db").delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            return sQLiteDatabase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = db.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.zza("datalayer", db)) {
                db.execSQL(zzayn);
            } else {
                this.zza(db);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zza(SQLiteDatabase sQLiteDatabase) {
            HashSet<String> hashSet = new HashSet<String>();
            try (Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM datalayer WHERE 0", null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            if (!(hashSet.remove("key") && hashSet.remove("value") && hashSet.remove("ID") && hashSet.remove("expires"))) {
                throw new SQLiteException("Database column missing");
            }
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
        }

        public void onCreate(SQLiteDatabase db) {
            zzak.zzam(db.getPath());
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }
}

