/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.tagmanager.zzab;
import com.google.android.gms.tagmanager.zzap;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzbk;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;

class zzcw
implements zzab {
    private final String zzaAM;
    private final HttpClient zzaAN;
    private final Context zzaAv;
    private zza zzaAO;

    zzcw(HttpClient httpClient, Context context, zza zza2) {
        this.zzaAv = context.getApplicationContext();
        this.zzaAM = this.zza("GoogleTagManager", "4.00", Build.VERSION.RELEASE, zzcw.zzc(Locale.getDefault()), Build.MODEL, Build.ID);
        this.zzaAN = httpClient;
        this.zzaAO = zza2;
    }

    @Override
    public boolean zzfk() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzaAv.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbf.zzab("...no network connectivity");
            return false;
        }
        return true;
    }

    @Override
    public void zzt(List<zzap> list) {
        int n = Math.min(list.size(), 40);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            zzap zzap2 = list.get(i);
            URL uRL = this.zzd(zzap2);
            if (uRL == null) {
                zzbf.zzac("No destination: discarding hit.");
                this.zzaAO.zzb(zzap2);
                continue;
            }
            HttpEntityEnclosingRequest httpEntityEnclosingRequest = this.zza(uRL);
            if (httpEntityEnclosingRequest == null) {
                this.zzaAO.zzb(zzap2);
                continue;
            }
            HttpHost httpHost = new HttpHost(uRL.getHost(), uRL.getPort(), uRL.getProtocol());
            httpEntityEnclosingRequest.addHeader("Host", httpHost.toHostString());
            this.zza(httpEntityEnclosingRequest);
            try {
                if (bl) {
                    zzbk.zzan(this.zzaAv);
                    bl = false;
                }
                HttpResponse httpResponse = this.zzaAN.execute(httpHost, (HttpRequest)httpEntityEnclosingRequest);
                int n2 = httpResponse.getStatusLine().getStatusCode();
                HttpEntity httpEntity = httpResponse.getEntity();
                if (httpEntity != null) {
                    httpEntity.consumeContent();
                }
                if (n2 != 200) {
                    zzbf.zzac("Bad response: " + httpResponse.getStatusLine().getStatusCode());
                    this.zzaAO.zzc(zzap2);
                    continue;
                }
                this.zzaAO.zza(zzap2);
                continue;
            }
            catch (ClientProtocolException clientProtocolException) {
                zzbf.zzac("ClientProtocolException sending hit; discarding hit...");
                this.zzaAO.zzb(zzap2);
                continue;
            }
            catch (IOException iOException) {
                zzbf.zzac("Exception sending hit: " + iOException.getClass().getSimpleName());
                zzbf.zzac(iOException.getMessage());
                this.zzaAO.zzc(zzap2);
            }
        }
    }

    private HttpEntityEnclosingRequest zza(URL uRL) {
        BasicHttpEntityEnclosingRequest basicHttpEntityEnclosingRequest = null;
        try {
            basicHttpEntityEnclosingRequest = new BasicHttpEntityEnclosingRequest("GET", uRL.toURI().toString());
            basicHttpEntityEnclosingRequest.addHeader("User-Agent", this.zzaAM);
        }
        catch (URISyntaxException uRISyntaxException) {
            zzbf.zzac("Exception sending hit: " + uRISyntaxException.getClass().getSimpleName());
            zzbf.zzac(uRISyntaxException.getMessage());
        }
        return basicHttpEntityEnclosingRequest;
    }

    private void zza(HttpEntityEnclosingRequest httpEntityEnclosingRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Header header : httpEntityEnclosingRequest.getAllHeaders()) {
            stringBuffer.append(header.toString()).append("\n");
        }
        stringBuffer.append(httpEntityEnclosingRequest.getRequestLine().toString()).append("\n");
        if (httpEntityEnclosingRequest.getEntity() != null) {
            try {
                int n;
                InputStream inputStream = httpEntityEnclosingRequest.getEntity().getContent();
                if (inputStream != null && (n = inputStream.available()) > 0) {
                    byte[] byArray = new byte[n];
                    inputStream.read(byArray);
                    stringBuffer.append("POST:\n");
                    stringBuffer.append(new String(byArray)).append("\n");
                }
            }
            catch (IOException iOException) {
                zzbf.zzab("Error Writing hit to log...");
            }
        }
        zzbf.zzab(stringBuffer.toString());
    }

    String zza(String string, String string2, String string3, String string4, String string5, String string6) {
        return String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string, string2, string3, string4, string5, string6);
    }

    static String zzc(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (locale.getLanguage() == null || locale.getLanguage().length() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(locale.getLanguage().toLowerCase());
        if (locale.getCountry() != null && locale.getCountry().length() != 0) {
            stringBuilder.append("-").append(locale.getCountry().toLowerCase());
        }
        return stringBuilder.toString();
    }

    URL zzd(zzap zzap2) {
        String string = zzap2.zztk();
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            zzbf.zzZ("Error trying to parse the GTM url.");
            return null;
        }
    }

    public static interface zza {
        public void zza(zzap var1);

        public void zzb(zzap var1);

        public void zzc(zzap var1);
    }
}

