/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.zzc;
import com.google.android.gms.internal.zzvd;
import com.google.android.gms.internal.zzvl;
import com.google.android.gms.internal.zzwx;
import com.google.android.gms.internal.zzwy;
import com.google.android.gms.tagmanager.zzay;
import com.google.android.gms.tagmanager.zzbe;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzca;
import com.google.android.gms.tagmanager.zzo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class zzcm
implements zzo.zzf {
    private final Context mContext;
    private final String zzaxw;
    private final ExecutorService zzazT;
    private zzbe<zzvd.zza> zzazN;

    zzcm(Context context, String string) {
        this.mContext = context;
        this.zzaxw = string;
        this.zzazT = Executors.newSingleThreadExecutor();
    }

    @Override
    public void zza(zzbe<zzvd.zza> zzbe2) {
        this.zzazN = zzbe2;
    }

    @Override
    public void zzsS() {
        this.zzazT.execute(new Runnable(){

            @Override
            public void run() {
                zzcm.this.zztF();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zztF() {
        if (this.zzazN == null) {
            throw new IllegalStateException("Callback must be set before execute");
        }
        this.zzazN.zzsR();
        zzbf.zzab("Attempting to load resource from disk");
        if ((zzca.zztx().zzty() == zzca.zza.zzazC || zzca.zztx().zzty() == zzca.zza.zzazD) && this.zzaxw.equals(zzca.zztx().getContainerId())) {
            this.zzazN.zza(zzbe.zza.zzazg);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.zztG());
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbf.zzY("Failed to find the resource in the disk");
            this.zzazN.zza(zzbe.zza.zzazg);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzvl.zzc(fileInputStream, byteArrayOutputStream);
            zzvd.zza zza2 = zzvd.zza.zzm(byteArrayOutputStream.toByteArray());
            this.zzd(zza2);
            this.zzazN.zzo(zza2);
        }
        catch (IOException iOException) {
            this.zzazN.zza(zzbe.zza.zzazh);
            zzbf.zzac("Failed to read the resource from disk");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzazN.zza(zzbe.zza.zzazh);
            zzbf.zzac("Failed to read the resource from disk. The resource is inconsistent");
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                zzbf.zzac("Error closing stream for reading resource from disk");
            }
        }
        zzbf.zzab("The Disk resource was successfully read.");
    }

    @Override
    public void zzb(final zzvd.zza zza2) {
        this.zzazT.execute(new Runnable(){

            @Override
            public void run() {
                zzcm.this.zzc(zza2);
            }
        });
    }

    @Override
    public zzvl.zzc zzhc(int n) {
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n);
        }
        catch (Resources.NotFoundException notFoundException) {
            zzbf.zzac("Failed to load the container. No default container resource found with the resource ID " + n);
            return null;
        }
        zzbf.zzab("Attempting to load a container from the resource ID " + n + " (" + this.mContext.getResources().getResourceName(n) + ")");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzvl.zzc(inputStream, byteArrayOutputStream);
            zzvl.zzc zzc2 = this.zza(byteArrayOutputStream);
            if (zzc2 != null) {
                zzbf.zzab("The container was successfully loaded from the resource (using JSON file format)");
                return zzc2;
            }
            return this.zzl(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            zzbf.zzac("Error reading the default container with resource ID " + n + " (" + this.mContext.getResources().getResourceName(n) + ")");
            return null;
        }
    }

    private zzvl.zzc zza(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string = byteArrayOutputStream.toString("UTF-8");
            return zzay.zzdd(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            zzbf.zzY("Failed to convert binary resource to string for JSON parsing; the file format is not UTF-8 format.");
            return null;
        }
        catch (JSONException jSONException) {
            zzbf.zzac("Failed to extract the container from the resource file. Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private zzvl.zzc zzl(byte[] byArray) {
        try {
            zzvl.zzc zzc2 = zzvl.zzb(zzc.zzf.zza(byArray));
            if (zzc2 != null) {
                zzbf.zzab("The container was successfully loaded from the resource (using binary file)");
            }
            return zzc2;
        }
        catch (zzwx zzwx2) {
            zzbf.zzZ("The resource file is corrupted. The container cannot be extracted from the binary file");
            return null;
        }
        catch (zzvl.zzg zzg2) {
            zzbf.zzac("The resource file is invalid. The container from the binary file is invalid");
            return null;
        }
    }

    public synchronized void release() {
        this.zzazT.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzc(zzvd.zza zza2) {
        FileOutputStream fileOutputStream = null;
        File file = this.zztG();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbf.zzZ("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(zzwy.zzf((zzwy)zza2));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            zzbf.zzac("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                zzbf.zzac("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File zztG() {
        String string = "resource_" + this.zzaxw;
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string);
    }

    private void zzd(zzvd.zza zza2) throws IllegalArgumentException {
        if (zza2.zzgs == null && zza2.zzaBL == null) {
            throw new IllegalArgumentException("Resource and SupplementedResource are NULL.");
        }
    }
}

