/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.internal.zzc;
import com.google.android.gms.internal.zzvl;
import com.google.android.gms.internal.zzvr;
import com.google.android.gms.internal.zzvs;
import com.google.android.gms.tagmanager.zzbe;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzca;
import com.google.android.gms.tagmanager.zzr;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class zzck
implements Runnable {
    private final Context mContext;
    private final zzvs zzazL;
    private final String zzaxw;
    private final String zzazM;
    private zzbe<zzc.zzj> zzazN;
    private volatile zzr zzazO;
    private volatile String zzaxT;
    private volatile String zzazP;

    public zzck(Context context, String string, zzr zzr2) {
        this(context, string, new zzvs(), zzr2);
    }

    zzck(Context context, String string, zzvs zzvs2, zzr zzr2) {
        this.mContext = context;
        this.zzazL = zzvs2;
        this.zzaxw = string;
        this.zzazO = zzr2;
        this.zzaxT = this.zzazM = "/r?id=" + string;
        this.zzazP = null;
    }

    @Override
    public void run() {
        if (this.zzazN == null) {
            throw new IllegalStateException("callback must be set before execute");
        }
        this.zzazN.zzsR();
        this.zztB();
    }

    private boolean zztA() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbf.zzab("...no network connectivity");
            return false;
        }
        return true;
    }

    void zza(zzbe<zzc.zzj> zzbe2) {
        this.zzazN = zzbe2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void zztB() {
        block12: {
            if (!this.zztA()) {
                this.zzazN.zza(zzbe.zza.zzazg);
                return;
            }
            zzbf.zzab("Start loading resource from network ...");
            String string = this.zztC();
            InputStream inputStream = null;
            try (zzvr zzvr2 = this.zzazL.zzuO();){
                try {
                    inputStream = zzvr2.zzdG(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    zzbf.zzac("No data is retrieved from the given url: " + string + ". Make sure container_id: " + this.zzaxw + " is correct.");
                    this.zzazN.zza(zzbe.zza.zzazi);
                    zzvr2.close();
                    return;
                }
                catch (IOException iOException) {
                    zzbf.zzd("Error when loading resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzazN.zza(zzbe.zza.zzazh);
                    zzvr2.close();
                    return;
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    zzvl.zzc(inputStream, byteArrayOutputStream);
                    zzc.zzj zzj2 = zzc.zzj.zzb(byteArrayOutputStream.toByteArray());
                    zzbf.zzab("Successfully loaded supplemented resource: " + (Object)((Object)zzj2));
                    if (zzj2.zzgs == null && zzj2.zzgr.length == 0) {
                        zzbf.zzab("No change for container: " + this.zzaxw);
                    }
                    this.zzazN.zzo(zzj2);
                    break block12;
                }
                catch (IOException iOException) {
                    zzbf.zzd("Error when parsing downloaded resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzazN.zza(zzbe.zza.zzazi);
                    zzvr2.close();
                    return;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        zzbf.zzab("Load resource from network finished.");
    }

    String zztC() {
        String string = this.zzazO.zzsT() + this.zzaxT + "&v=a65833898";
        if (this.zzazP != null && !this.zzazP.trim().equals("")) {
            string = string + "&pv=" + this.zzazP;
        }
        if (zzca.zztx().zzty().equals((Object)zzca.zza.zzazD)) {
            string = string + "&gtm_debug=x";
        }
        return string;
    }

    void zzcT(String string) {
        if (string == null) {
            this.zzaxT = this.zzazM;
        } else {
            zzbf.zzY("Setting CTFE URL path: " + string);
            this.zzaxT = string;
        }
    }

    void zzdg(String string) {
        zzbf.zzY("Setting previous container version: " + string);
        this.zzazP = string;
    }
}

