/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.internal.zzlv;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.tagmanager.zzab;
import com.google.android.gms.tagmanager.zzak;
import com.google.android.gms.tagmanager.zzap;
import com.google.android.gms.tagmanager.zzat;
import com.google.android.gms.tagmanager.zzau;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzct;
import com.google.android.gms.tagmanager.zzcw;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

class zzbx
implements zzat {
    private static final String zzES = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL,'%s' INTEGER NOT NULL);", "gtm_hits", "hit_id", "hit_time", "hit_url", "hit_first_send_time");
    private final zzb zzazq;
    private volatile zzab zzazr;
    private final zzau zzazs;
    private final Context mContext;
    private final String zzEW;
    private long zzEY;
    private zzlv zzmW;
    private final int zzEZ;

    zzbx(zzau zzau2, Context context) {
        this(zzau2, context, "gtm_urls.db", 2000);
    }

    zzbx(zzau zzau2, Context context, String string, int n) {
        this.mContext = context.getApplicationContext();
        this.zzEW = string;
        this.zzazs = zzau2;
        this.zzmW = zzlx.zzkc();
        this.zzazq = new zzb(this.mContext, this.zzEW);
        this.zzazr = new zzcw((HttpClient)new DefaultHttpClient(), this.mContext, new zza());
        this.zzEY = 0L;
        this.zzEZ = n;
    }

    @Override
    public void zzf(long l, String string) {
        this.zzgz();
        this.zzgy();
        this.zzg(l, string);
    }

    private void zzgy() {
        int n = this.zzgA() - this.zzEZ + 1;
        if (n > 0) {
            List<String> list = this.zzM(n);
            zzbf.zzab("Store full, deleting " + list.size() + " hits to make room.");
            this.zzb(list.toArray(new String[0]));
        }
    }

    private void zzg(long l, String string) {
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for putHit");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_time", Long.valueOf(l));
        contentValues.put("hit_url", string);
        contentValues.put("hit_first_send_time", Integer.valueOf(0));
        try {
            sQLiteDatabase.insert("gtm_hits", null, contentValues);
            this.zzazs.zzD(false);
        }
        catch (SQLiteException sQLiteException) {
            zzbf.zzac("Error storing hit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> zzM(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n <= 0) {
            zzbf.zzac("Invalid maxHits specified. Skipping");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for peekHitIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<zzap> zzN(int n) {
        ArrayList<zzap> arrayList = new ArrayList<zzap>();
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for peekHits");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_time", "hit_first_send_time"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            arrayList = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    zzap zzap2 = new zzap(cursor.getLong(0), cursor.getLong(1), cursor.getLong(2));
                    arrayList.add(zzap2);
                } while (cursor.moveToNext());
            }
        }
        int n2 = 0;
        try {
            CursorWindow cursorWindow;
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_url"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            if (cursor.moveToFirst()) {
                do {
                    if ((cursorWindow = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        ((zzap)arrayList.get(n2)).zzaq(cursor.getString(1));
                    } else {
                        zzbf.zzac(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((zzap)arrayList.get(n2)).zzgs()));
                    }
                    ++n2;
                } while (cursor.moveToNext());
            }
            cursorWindow = arrayList;
            return cursorWindow;
        }
        catch (SQLiteException sQLiteException) {
            zzbf.zzac("Error in peekHits fetching hit url: " + sQLiteException.getMessage());
            ArrayList<zzap> arrayList2 = new ArrayList<zzap>();
            boolean bl = false;
            for (zzap zzap3 : arrayList) {
                if (TextUtils.isEmpty((CharSequence)zzap3.zztk())) {
                    if (bl) break;
                    bl = true;
                }
                arrayList2.add(zzap3);
            }
            ArrayList<zzap> arrayList3 = arrayList2;
            return arrayList3;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    int zzgz() {
        long l = this.zzmW.currentTimeMillis();
        if (l <= this.zzEY + 86400000L) {
            return 0;
        }
        this.zzEY = l;
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for deleteStaleHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        long l2 = this.zzmW.currentTimeMillis() - 2592000000L;
        int n = sQLiteDatabase.delete("gtm_hits", "HIT_TIME < ?", new String[]{Long.toString(l2)});
        this.zzazs.zzD(this.zzgA() == 0);
        return n;
    }

    void zzb(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for deleteHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("gtm_hits", string, stringArray);
            this.zzazs.zzD(this.zzgA() == 0);
        }
        catch (SQLiteException sQLiteException) {
            zzbf.zzac("Error deleting hits");
        }
    }

    private void zzH(long l) {
        this.zzb(new String[]{String.valueOf(l)});
    }

    private void zzd(long l, long l2) {
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_first_send_time", Long.valueOf(l2));
        try {
            sQLiteDatabase.update("gtm_hits", contentValues, "hit_id=?", new String[]{String.valueOf(l)});
        }
        catch (SQLiteException sQLiteException) {
            zzbf.zzac("Error setting HIT_FIRST_DISPATCH_TIME for hitId: " + l);
            this.zzH(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int zzgA() {
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from gtm_hits", null);
            if (cursor.moveToFirst()) {
                n = (int)cursor.getLong(0);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int zztv() {
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_first_send_time"}, "hit_first_send_time=0", null, null, null, null);
            n = cursor.getCount();
        }
        return n;
    }

    @Override
    public void dispatch() {
        zzbf.zzab("GTM Dispatch running...");
        if (!this.zzazr.zzfk()) {
            return;
        }
        List<zzap> list = this.zzN(40);
        if (list.isEmpty()) {
            zzbf.zzab("...nothing to dispatch");
            this.zzazs.zzD(true);
            return;
        }
        this.zzazr.zzt(list);
        if (this.zztv() > 0) {
            zzct.zztR().dispatch();
        }
    }

    private SQLiteDatabase zzar(String string) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.zzazq.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            zzbf.zzac(string);
            return null;
        }
        return sQLiteDatabase;
    }

    class zzb
    extends SQLiteOpenHelper {
        private boolean zzFa;
        private long zzFb;

        zzb(Context context, String string) {
            super(context, string, null, 1);
            this.zzFb = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(String string, SQLiteDatabase sQLiteDatabase) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.zzFa && this.zzFb + 3600000L > zzbx.this.zzmW.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase sQLiteDatabase = null;
            this.zzFa = true;
            this.zzFb = zzbx.this.zzmW.currentTimeMillis();
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zzbx.this.mContext.getDatabasePath(zzbx.this.zzEW).delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            this.zzFa = false;
            return sQLiteDatabase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = db.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.zza("gtm_hits", db)) {
                db.execSQL(zzES);
            } else {
                this.zza(db);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zza(SQLiteDatabase sQLiteDatabase) {
            HashSet<String> hashSet = new HashSet<String>();
            try (Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM gtm_hits WHERE 0", null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            if (!(hashSet.remove("hit_id") && hashSet.remove("hit_url") && hashSet.remove("hit_time") && hashSet.remove("hit_first_send_time"))) {
                throw new SQLiteException("Database column missing");
            }
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
        }

        public void onCreate(SQLiteDatabase db) {
            zzak.zzam(db.getPath());
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }

    class zza
    implements zzcw.zza {
        zza() {
        }

        @Override
        public void zza(zzap zzap2) {
            zzbx.this.zzH(zzap2.zzgs());
        }

        @Override
        public void zzb(zzap zzap2) {
            zzbx.this.zzH(zzap2.zzgs());
            zzbf.zzab("Permanent failure dispatching hitId: " + zzap2.zzgs());
        }

        @Override
        public void zzc(zzap zzap2) {
            long l = zzap2.zztj();
            if (l == 0L) {
                zzbx.this.zzd(zzap2.zzgs(), zzbx.this.zzmW.currentTimeMillis());
            } else if (l + 14400000L < zzbx.this.zzmW.currentTimeMillis()) {
                zzbx.this.zzH(zzap2.zzgs());
                zzbf.zzab("Giving up on failed hitId: " + zzap2.zzgs());
            }
        }
    }
}

