/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.tagmanager.ContainerHolder;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzca;
import com.google.android.gms.tagmanager.zzcs;
import com.google.android.gms.tagmanager.zzct;
import com.google.android.gms.tagmanager.zzd;
import com.google.android.gms.tagmanager.zzn;
import com.google.android.gms.tagmanager.zzo;
import com.google.android.gms.tagmanager.zzr;
import com.google.android.gms.tagmanager.zzv;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TagManager {
    private final zza zzaAP;
    private final Context mContext;
    private final DataLayer zzaxx;
    private final zzcs zzaAQ;
    private final ConcurrentMap<zzn, Boolean> zzaAR;
    private final zzr zzazO;
    private static TagManager zzaAS;

    TagManager(Context context, zza containerHolderLoaderProvider, DataLayer dataLayer, zzcs serviceManager) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.mContext = context.getApplicationContext();
        this.zzaAQ = serviceManager;
        this.zzaAP = containerHolderLoaderProvider;
        this.zzaAR = new ConcurrentHashMap<zzn, Boolean>();
        this.zzaxx = dataLayer;
        this.zzaxx.zza(new DataLayer.zzb(){

            @Override
            public void zzI(Map<String, Object> map) {
                Object object = map.get("event");
                if (object != null) {
                    TagManager.this.zzdk(object.toString());
                }
            }
        });
        this.zzaxx.zza(new zzd(this.mContext));
        this.zzazO = new zzr();
        this.zztT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TagManager getInstance(Context context) {
        Class<TagManager> clazz = TagManager.class;
        synchronized (TagManager.class) {
            if (zzaAS == null) {
                if (context == null) {
                    zzbf.zzZ("TagManager.getInstance requires non-null context.");
                    throw new NullPointerException();
                }
                zza zza2 = new zza(){

                    @Override
                    public zzo zza(Context context, TagManager tagManager, Looper looper, String string, int n, zzr zzr2) {
                        return new zzo(context, tagManager, looper, string, n, zzr2);
                    }
                };
                zzv zzv2 = new zzv(context);
                zzaAS = new TagManager(context, zza2, new DataLayer(zzv2), zzct.zztR());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaAS;
        }
    }

    public DataLayer getDataLayer() {
        return this.zzaxx;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String containerId, int defaultContainerResourceId) {
        zzo zzo2 = this.zzaAP.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzazO);
        zzo2.zzsN();
        return zzo2;
    }

    public PendingResult<ContainerHolder> zzc(String string, int n, String string2) {
        zzo zzo2 = this.zzaAP.zza(this.mContext, this, null, string, n, this.zzazO);
        zzo2.load(string2);
        return zzo2;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String containerId, int defaultContainerResourceId, Handler handler) {
        zzo zzo2 = this.zzaAP.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzazO);
        zzo2.zzsN();
        return zzo2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String containerId, int defaultContainerResourceId) {
        zzo zzo2 = this.zzaAP.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzazO);
        zzo2.zzsO();
        return zzo2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String containerId, int defaultContainerResourceId, Handler handler) {
        zzo zzo2 = this.zzaAP.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzazO);
        zzo2.zzsO();
        return zzo2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String containerId, int defaultContainerResourceId) {
        zzo zzo2 = this.zzaAP.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzazO);
        zzo2.zzsP();
        return zzo2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String containerId, int defaultContainerResourceId, Handler handler) {
        zzo zzo2 = this.zzaAP.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzazO);
        zzo2.zzsP();
        return zzo2;
    }

    public void dispatch() {
        this.zzaAQ.dispatch();
    }

    public void setVerboseLoggingEnabled(boolean enableVerboseLogging) {
        zzbf.setLogLevel(enableVerboseLogging ? 2 : 5);
    }

    synchronized boolean zzl(Uri uri) {
        zzca zzca2 = zzca.zztx();
        if (zzca2.zzl(uri)) {
            String string = zzca2.getContainerId();
            switch (zzca2.zzty()) {
                case zzazB: {
                    for (zzn zzn2 : this.zzaAR.keySet()) {
                        if (!zzn2.getContainerId().equals(string)) continue;
                        zzn2.zzcQ(null);
                        zzn2.refresh();
                    }
                    break;
                }
                case zzazC: 
                case zzazD: {
                    for (zzn zzn3 : this.zzaAR.keySet()) {
                        if (zzn3.getContainerId().equals(string)) {
                            zzn3.zzcQ(zzca2.zztz());
                            zzn3.refresh();
                            continue;
                        }
                        if (zzn3.zzsK() == null) continue;
                        zzn3.zzcQ(null);
                        zzn3.refresh();
                    }
                    break;
                }
            }
            return true;
        }
        return false;
    }

    void zza(zzn zzn2) {
        this.zzaAR.put(zzn2, true);
    }

    boolean zzb(zzn zzn2) {
        return this.zzaAR.remove(zzn2) != null;
    }

    private void zzdk(String string) {
        for (zzn zzn2 : this.zzaAR.keySet()) {
            zzn2.zzcO(string);
        }
    }

    private void zztT() {
        if (Build.VERSION.SDK_INT >= 14) {
            this.mContext.registerComponentCallbacks((ComponentCallbacks)new ComponentCallbacks2(){

                public void onTrimMemory(int i) {
                    if (i == 20) {
                        TagManager.this.dispatch();
                    }
                }

                public void onConfigurationChanged(Configuration configuration) {
                }

                public void onLowMemory() {
                }
            });
        }
    }

    public static interface zza {
        public zzo zza(Context var1, TagManager var2, Looper var3, String var4, int var5, zzr var6);
    }
}

