/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.internal.zzc;
import com.google.android.gms.internal.zzvl;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzag;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzbn;
import com.google.android.gms.tagmanager.zzca;
import com.google.android.gms.tagmanager.zzco;
import com.google.android.gms.tagmanager.zzde;
import com.google.android.gms.tagmanager.zzs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Container {
    private final Context mContext;
    private final String zzaxw;
    private final DataLayer zzaxx;
    private zzco zzaxy;
    private Map<String, FunctionCallMacroCallback> zzaxz = new HashMap<String, FunctionCallMacroCallback>();
    private Map<String, FunctionCallTagCallback> zzaxA = new HashMap<String, FunctionCallTagCallback>();
    private volatile long zzaxB;
    private volatile String zzaxC = "";

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, zzvl.zzc resource) {
        this.mContext = context;
        this.zzaxx = dataLayer;
        this.zzaxw = containerId;
        this.zzaxB = lastRefreshTime;
        this.zza(resource);
    }

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, zzc.zzj resource) {
        this.mContext = context;
        this.zzaxx = dataLayer;
        this.zzaxw = containerId;
        this.zzaxB = lastRefreshTime;
        this.zza(resource.zzgs);
        if (resource.zzgr != null) {
            this.zza(resource.zzgr);
        }
    }

    public String getContainerId() {
        return this.zzaxw;
    }

    public boolean getBoolean(String key) {
        zzco zzco2 = this.zzsJ();
        if (zzco2 == null) {
            zzbf.zzZ("getBoolean called for closed container.");
            return zzde.zzuc();
        }
        try {
            return zzde.zzk(zzco2.zzdi(key).getObject());
        }
        catch (Exception exception) {
            zzbf.zzZ("Calling getBoolean() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzde.zzuc();
        }
    }

    public double getDouble(String key) {
        zzco zzco2 = this.zzsJ();
        if (zzco2 == null) {
            zzbf.zzZ("getDouble called for closed container.");
            return zzde.zzub();
        }
        try {
            return zzde.zzj(zzco2.zzdi(key).getObject());
        }
        catch (Exception exception) {
            zzbf.zzZ("Calling getDouble() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzde.zzub();
        }
    }

    public long getLong(String key) {
        zzco zzco2 = this.zzsJ();
        if (zzco2 == null) {
            zzbf.zzZ("getLong called for closed container.");
            return zzde.zzua();
        }
        try {
            return zzde.zzi(zzco2.zzdi(key).getObject());
        }
        catch (Exception exception) {
            zzbf.zzZ("Calling getLong() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzde.zzua();
        }
    }

    public String getString(String key) {
        zzco zzco2 = this.zzsJ();
        if (zzco2 == null) {
            zzbf.zzZ("getString called for closed container.");
            return zzde.zzue();
        }
        try {
            return zzde.zzg(zzco2.zzdi(key).getObject());
        }
        catch (Exception exception) {
            zzbf.zzZ("Calling getString() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzde.zzue();
        }
    }

    public long getLastRefreshTime() {
        return this.zzaxB;
    }

    public boolean isDefault() {
        return this.getLastRefreshTime() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallMacroCallback(String customMacroName, FunctionCallMacroCallback customMacroCallback) {
        if (customMacroCallback == null) {
            throw new NullPointerException("Macro handler must be non-null");
        }
        Map<String, FunctionCallMacroCallback> map = this.zzaxz;
        synchronized (map) {
            this.zzaxz.put(customMacroName, customMacroCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallMacroCallback(String customMacroName) {
        Map<String, FunctionCallMacroCallback> map = this.zzaxz;
        synchronized (map) {
            this.zzaxz.remove(customMacroName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallMacroCallback zzcM(String string) {
        Map<String, FunctionCallMacroCallback> map = this.zzaxz;
        synchronized (map) {
            return this.zzaxz.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallTagCallback(String customTagName, FunctionCallTagCallback customTagCallback) {
        if (customTagCallback == null) {
            throw new NullPointerException("Tag callback must be non-null");
        }
        Map<String, FunctionCallTagCallback> map = this.zzaxA;
        synchronized (map) {
            this.zzaxA.put(customTagName, customTagCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallTagCallback(String customTagName) {
        Map<String, FunctionCallTagCallback> map = this.zzaxA;
        synchronized (map) {
            this.zzaxA.remove(customTagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallTagCallback zzcN(String string) {
        Map<String, FunctionCallTagCallback> map = this.zzaxA;
        synchronized (map) {
            return this.zzaxA.get(string);
        }
    }

    void zzcO(String string) {
        this.zzsJ().zzcO(string);
    }

    String zzsI() {
        return this.zzaxC;
    }

    private void zza(zzc.zzf zzf2) {
        if (zzf2 == null) {
            throw new NullPointerException();
        }
        zzvl.zzc zzc2 = null;
        try {
            zzc2 = zzvl.zzb(zzf2);
        }
        catch (zzvl.zzg zzg2) {
            zzbf.zzZ("Not loading resource: " + (Object)((Object)zzf2) + " because it is invalid: " + zzg2.toString());
            return;
        }
        this.zza(zzc2);
    }

    private void zza(zzc.zzi[] zziArray) {
        ArrayList<zzc.zzi> arrayList = new ArrayList<zzc.zzi>();
        for (zzc.zzi zzi2 : zziArray) {
            arrayList.add(zzi2);
        }
        this.zzsJ().zzu(arrayList);
    }

    private void zza(zzvl.zzc zzc2) {
        this.zzaxC = zzc2.getVersion();
        zzag zzag2 = this.zzcP(this.zzaxC);
        zzco zzco2 = new zzco(this.mContext, zzc2, this.zzaxx, new zza(), new zzb(), zzag2);
        this.zza(zzco2);
    }

    zzag zzcP(String string) {
        if (zzca.zztx().zzty().equals((Object)zzca.zza.zzazD)) {
            // empty if block
        }
        return new zzbn();
    }

    private synchronized void zza(zzco zzco2) {
        this.zzaxy = zzco2;
    }

    private synchronized zzco zzsJ() {
        return this.zzaxy;
    }

    void release() {
        this.zzaxy = null;
    }

    private class zzb
    implements zzs.zza {
        private zzb() {
        }

        @Override
        public Object zzc(String string, Map<String, Object> map) {
            FunctionCallTagCallback functionCallTagCallback = Container.this.zzcN(string);
            if (functionCallTagCallback != null) {
                functionCallTagCallback.execute(string, map);
            }
            return zzde.zzue();
        }
    }

    private class zza
    implements zzs.zza {
        private zza() {
        }

        @Override
        public Object zzc(String string, Map<String, Object> map) {
            FunctionCallMacroCallback functionCallMacroCallback = Container.this.zzcM(string);
            return functionCallMacroCallback == null ? null : functionCallMacroCallback.getValue(string, map);
        }
    }

    public static interface FunctionCallTagCallback {
        public void execute(String var1, Map<String, Object> var2);
    }

    public static interface FunctionCallMacroCallback {
        public Object getValue(String var1, Map<String, Object> var2);
    }
}

