/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlz;
import com.google.android.gms.internal.zzvj;
import com.google.android.gms.internal.zzvo;
import com.google.android.gms.internal.zzvr;
import com.google.android.gms.internal.zzvs;
import com.google.android.gms.internal.zzvt;
import com.google.android.gms.tagmanager.zzbf;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class zzvu
implements Runnable {
    private final Context mContext;
    private final zzvt zzaCN;
    private final zzvs zzazL;
    private final zzvj zzaCG;
    private final zzvo zzaCO;

    public zzvu(Context context, zzvj zzvj2, zzvt zzvt2) {
        this(context, zzvj2, zzvt2, new zzvs(), new zzvo());
    }

    public zzvu(Context context, zzvj zzvj2, zzvt zzvt2, String string) {
        this(context, zzvj2, zzvt2, new zzvs(), new zzvo());
        this.zzaCO.zzdx(string);
    }

    zzvu(Context context, zzvj zzvj2, zzvt zzvt2, zzvs zzvs2, zzvo zzvo2) {
        zzx.zzl((Object)context);
        zzx.zzl((Object)zzvt2);
        this.mContext = context;
        this.zzaCG = zzvj2;
        this.zzaCN = zzvt2;
        this.zzazL = zzvs2;
        this.zzaCO = zzvo2;
    }

    @Override
    public void run() {
        this.zzdo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void zzdo() {
        block11: {
            if (!this.zzuQ()) {
                this.zzaCN.zza(zzvt.zza.zzaCI);
                return;
            }
            zzbf.zzab("NetworkLoader: Starting to load resource from Network.");
            InputStream inputStream = null;
            try (zzvr zzvr2 = this.zzazL.zzuO();){
                String string = this.zzaCO.zzv(this.zzaCG.zzun());
                try {
                    inputStream = zzvr2.zzdG(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    zzbf.zzZ("NetworkLoader: No data is retrieved from the given url: " + string);
                    this.zzaCN.zza(zzvt.zza.zzaCK);
                    zzvr2.close();
                    return;
                }
                catch (IOException iOException) {
                    zzbf.zzb("NetworkLoader: Error when loading resource from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzaCN.zza(zzvt.zza.zzaCJ);
                    zzvr2.close();
                    return;
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    zzlz.zza((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                    this.zzaCN.zzo(byteArrayOutputStream.toByteArray());
                    break block11;
                }
                catch (IOException iOException) {
                    zzbf.zzb("NetworkLoader: Error when parsing downloaded resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzaCN.zza(zzvt.zza.zzaCK);
                    zzvr2.close();
                    return;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        zzbf.zzab("NetworkLoader: Resource loaded.");
    }

    boolean zzuQ() {
        if (!this.zzdI("android.permission.INTERNET")) {
            zzbf.zzZ("Missing android.permission.INTERNET. Please add the following declaration to your AndroidManifest.xml: <uses-permission android:name=\"android.permission.INTERNET\" />");
            return false;
        }
        if (!this.zzdI("android.permission.ACCESS_NETWORK_STATE")) {
            zzbf.zzZ("Missing android.permission.ACCESS_NETWORK_STATE. Please add the following declaration to your AndroidManifest.xml: <uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\" />");
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbf.zzac("NetworkLoader: No network connectivity - Offline");
            return false;
        }
        return true;
    }

    boolean zzdI(String string) {
        return this.mContext.getPackageManager().checkPermission(string, this.mContext.getPackageName()) == 0;
    }
}

