/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzlz;
import com.google.android.gms.internal.zzvh;
import com.google.android.gms.internal.zzvl;
import com.google.android.gms.internal.zzvm;
import com.google.android.gms.tagmanager.zzbf;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class zzvn {
    public static final Integer zzaCx = 0;
    public static final Integer zzaCy = 1;
    private final Context mContext;
    private final ExecutorService zzazT;

    public zzvn(Context context) {
        this(context, Executors.newSingleThreadExecutor());
    }

    zzvn(Context context, ExecutorService executorService) {
        this.mContext = context;
        this.zzazT = executorService;
    }

    public void zza(final String string, final Integer n, final zzvh zzvh2, final zzvm zzvm2) {
        this.zzazT.execute(new Runnable(){

            @Override
            public void run() {
                zzvn.this.zzb(string, n, zzvh2, zzvm2);
            }
        });
    }

    void zzb(String string, Integer n, zzvh zzvh2, zzvm zzvm2) {
        Object object;
        InputStream inputStream;
        zzbf.zzab("DiskLoader: Starting to load resource from Disk.");
        try {
            inputStream = new FileInputStream(this.zzdE(string));
            object = zzvh2.zzn(this.zzf(inputStream));
            if (object != null) {
                zzbf.zzab("Saved resource loaded: " + this.zzdF(string));
                zzvm2.zza(Status.zzNo, object, zzaCy, this.zzdD(string));
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbf.zzZ("Saved resource not found: " + this.zzdF(string));
        }
        catch (zzvl.zzg zzg2) {
            zzbf.zzZ("Saved resource is corrupted: " + this.zzdF(string));
        }
        if (n == null) {
            zzvm2.zza(Status.zzNq, null, null, 0L);
            return;
        }
        try {
            inputStream = this.mContext.getResources().openRawResource(n.intValue());
            if (inputStream != null && (object = zzvh2.zzn(this.zzf(inputStream))) != null) {
                zzbf.zzab("Default resource loaded: " + this.mContext.getResources().getResourceEntryName(n.intValue()));
                zzvm2.zza(Status.zzNo, object, zzaCx, 0L);
                return;
            }
        }
        catch (Resources.NotFoundException notFoundException) {
            zzbf.zzZ("Default resource not found. ID: " + n);
        }
        catch (zzvl.zzg zzg3) {
            zzbf.zzZ("Default resource resource is corrupted: " + n);
        }
        zzvm2.zza(Status.zzNq, null, null, 0L);
    }

    public void zzf(final String string, final byte[] byArray) {
        this.zzazT.execute(new Runnable(){

            @Override
            public void run() {
                zzvn.this.zzg(string, byArray);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzg(String string, byte[] byArray) {
        String string2;
        FileOutputStream fileOutputStream;
        File file = this.zzdE(string);
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = "Error opening resource file for writing";
            zzbf.zzZ(string3);
            return;
        }
        try {
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            string2 = "Error writing resource to disk. Removing resource from disk";
            zzbf.zzZ(string2);
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
                zzbf.zzab("Resource " + string + " saved on Disk.");
            }
            catch (IOException iOException) {
                string2 = "Error closing stream for writing resource to disk";
                zzbf.zzZ(string2);
            }
        }
    }

    public long zzdD(String string) {
        File file = this.zzdE(string);
        return file.exists() ? file.lastModified() : 0L;
    }

    File zzdE(String string) {
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, this.zzdF(string));
    }

    private String zzdF(String string) {
        return "resource_" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] zzf(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            zzlz.zza((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            zzbf.zzac("Failed to read the resource from disk");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                zzbf.zzac("Error closing stream for reading resource from disk");
                return null;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }
}

