/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzre;
import com.google.android.gms.internal.zzrh;
import java.util.Map;

public final class zzri
implements Application.ActivityLifecycleCallbacks {
    private final zzre zzasy;
    private final Map<Activity, zzrh> zzasz;

    public zzri(zzre zzre2) {
        zzx.zzl((Object)zzre2);
        this.zzasy = zzre2;
        this.zzasz = new ArrayMap();
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        Bundle bundle = savedInstanceState.getBundle("com.google.android.gms.measurement.screen_view");
        if (bundle == null) {
            return;
        }
        int n = bundle.getInt("id");
        if (n <= 0) {
            Log.w((String)"com.google.android.gms.measurement.internal.ActivityLifecycleTracker", (String)"Invalid screenId in saved activity state");
            return;
        }
        zzrh zzrh2 = this.zza(activity, n);
        zzrh2.setScreenName(bundle.getString("name"));
        zzrh2.zzgr(bundle.getInt("referrer_id"));
        zzrh2.zzcv(bundle.getString("referrer_name"));
        zzrh2.zzaa(bundle.getBoolean("interstitial"));
        zzrh2.zzrh();
    }

    public void onActivityStarted(Activity activity) {
        zzrh zzrh2 = this.zza(activity, 0);
        this.zzasy.zzb(zzrh2, activity);
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        if (outState == null) {
            return;
        }
        zzrh zzrh2 = this.zzasz.get(activity);
        if (zzrh2 == null) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("id", zzrh2.zzaF());
        bundle.putString("name", zzrh2.zzre());
        bundle.putInt("referrer_id", zzrh2.zzrf());
        bundle.putString("referrer_name", zzrh2.zzrg());
        bundle.putBoolean("interstitial", zzrh2.zzri());
        outState.putBundle("com.google.android.gms.measurement.screen_view", bundle);
    }

    public void onActivityDestroyed(Activity activity) {
        this.zzasz.remove(activity);
    }

    zzrh zza(Activity activity, int n) {
        zzx.zzl((Object)activity);
        zzrh zzrh2 = this.zzasz.get(activity);
        if (zzrh2 == null) {
            zzrh2 = n == 0 ? new zzrh(true) : new zzrh(true, n);
            zzrh2.setScreenName(activity.getClass().getCanonicalName());
            this.zzasz.put(activity, zzrh2);
        }
        return zzrh2;
    }
}

