/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.zzan;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzqx;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.internal.zzrc;
import com.google.android.gms.internal.zzrf;
import com.google.android.gms.internal.zzrg;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzra {
    private static volatile zzra zzarZ;
    private final Context mContext;
    private final List<zzrb> zzasa;
    private final zzqw zzasb;
    private final ScheduledExecutorService zzasc;
    private volatile zzrf zzasd;

    zzra(Context context) {
        Context context2 = context.getApplicationContext();
        zzx.zzl((Object)context2);
        this.mContext = context2;
        this.zzasc = Executors.newSingleThreadScheduledExecutor(new zza());
        this.zzasa = new CopyOnWriteArrayList<zzrb>();
        this.zzasb = new zzqw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzra zzaf(Context context) {
        zzx.zzl((Object)context);
        if (zzarZ != null) return zzarZ;
        Class<zzra> clazz = zzra.class;
        synchronized (zzra.class) {
            if (zzarZ != null) return zzarZ;
            zzarZ = new zzra(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzarZ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzrf zzqU() {
        if (this.zzasd == null) {
            zzra zzra2 = this;
            synchronized (zzra2) {
                if (this.zzasd == null) {
                    zzrf zzrf2 = new zzrf();
                    PackageManager packageManager = this.mContext.getPackageManager();
                    String string = this.mContext.getPackageName();
                    zzrf2.setAppId(string);
                    zzrf2.setAppInstallerId(packageManager.getInstallerPackageName(string));
                    String string2 = string;
                    String string3 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string2 = charSequence.toString();
                            }
                            string3 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.e((String)"GA", (String)("Error retrieving package info: appName set to " + string2));
                    }
                    zzrf2.setAppName(string2);
                    zzrf2.setAppVersion(string3);
                    this.zzasd = zzrf2;
                }
            }
        }
        return this.zzasd;
    }

    public zzrg zzqV() {
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        zzrg zzrg2 = new zzrg();
        zzrg2.setLanguage(zzan.zza(Locale.getDefault()));
        zzrg2.zzgp(displayMetrics.widthPixels);
        zzrg2.zzgq(displayMetrics.heightPixels);
        return zzrg2;
    }

    public Context getContext() {
        return this.mContext;
    }

    public <V> Future<V> zza(Callable<V> callable) {
        zzx.zzl(callable);
        if (Thread.currentThread() instanceof zzb) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zzasc.submit(callable);
    }

    private void zza(zzqx zzqx2) {
        zzx.zzbe((String)"deliver should be called from worker thread");
        zzx.zzb((boolean)zzqx2.zzqS(), (Object)"Measurement must be submitted");
        List<zzrc> list = zzqx2.zzqR();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzrc zzrc2 : list) {
            Uri uri = zzrc2.zzqP();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzrc2.zza(zzqx2);
        }
    }

    private static class zza
    implements ThreadFactory {
        private static final AtomicInteger zzasg = new AtomicInteger();

        private zza() {
        }

        @Override
        public Thread newThread(Runnable target) {
            String string = "measurement-" + zzasg.incrementAndGet();
            return new zzb(target, string);
        }
    }

    private static class zzb
    extends Thread {
        zzb(Runnable runnable, String string) {
            super(runnable, string);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }
}

