/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.zzac;
import com.google.android.gms.analytics.zzae;
import com.google.android.gms.analytics.zzak;
import com.google.android.gms.analytics.zzan;
import com.google.android.gms.analytics.zzf;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.analytics.zzw;
import com.google.android.gms.analytics.zzy;
import com.google.android.gms.internal.zzik;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class zzx
extends Thread
implements zzf {
    private final LinkedBlockingQueue<Runnable> zzCJ = new LinkedBlockingQueue();
    private volatile boolean zzCK;
    private volatile boolean mClosed;
    private volatile String zzCL;
    private volatile zzak zzCM;
    private final GoogleAnalytics zzBN;
    private final Lock zzCN;
    private final List<zzik> zzCO = new ArrayList<zzik>();

    zzx(GoogleAnalytics googleAnalytics, zzak zzak2) {
        super("GAThread");
        com.google.android.gms.common.internal.zzx.zzl((Object)googleAnalytics);
        this.zzBN = googleAnalytics;
        this.zzCM = zzak2;
        this.zzCO.add(new zzik("appendVersion", "&_v".substring(1), "ma4.0.6"));
        this.zzCN = new ReentrantLock();
        this.start();
    }

    protected synchronized void init() {
        if (this.zzCM != null) {
            return;
        }
        this.zzCM = new zzw(this.zzBN.getContext(), this);
        this.zzCM.zzfM();
    }

    @Override
    public void zzx(Map<String, String> map) {
        this.zzc(new zzd(map));
    }

    @Override
    public void dispatch() {
        this.zzc(new zzb());
    }

    @Override
    public void zzfa() {
        this.zzc(new zza());
    }

    @Override
    public void zzfh() {
        this.zzc(new zzc());
    }

    private void zzc(Runnable runnable) {
        this.zzCJ.add(runnable);
    }

    private String zzf(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        printStream.flush();
        return new String(byteArrayOutputStream.toByteArray());
    }

    static int zzan(String string) {
        int n = 1;
        int n2 = 0;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            n = 0;
            for (int i = string.length() - 1; i >= 0; --i) {
                char c = string.charAt(i);
                n2 = (n = (n << 6 & 0xFFFFFFF) + c + (c << 14)) & 0xFE00000;
                n = n2 != 0 ? n ^ n2 >> 21 : n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String zzH(Context context) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaInstallData");
            byte[] byArray = new byte[8192];
            int n = fileInputStream.read(byArray, 0, 8192);
            if (fileInputStream.available() > 0) {
                zzae.zzZ("Too much campaign data, ignoring it.");
                fileInputStream.close();
                fileInputStream = null;
                context.deleteFile("gaInstallData");
                String string = null;
                return string;
            }
            fileInputStream.close();
            fileInputStream = null;
            context.deleteFile("gaInstallData");
            if (n <= 0) {
                zzae.zzac("Campaign file is empty.");
                String string = null;
                return string;
            }
            String string = new String(byArray, 0, n);
            zzae.zzaa("Campaign found: " + string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzae.zzaa("No campaign data found.");
            String string = null;
            return string;
        }
        catch (IOException iOException) {
            zzae.zzZ("Error reading campaign data.");
            context.deleteFile("gaInstallData");
            String string = null;
            return string;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    zzae.zzZ("Failed to close campaign data in stream: " + iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            zzae.zzac("sleep interrupted in GAThread initialize");
        }
        try {
            this.init();
            this.zzCL = zzx.zzH(this.zzBN.getContext());
            zzae.zzab("Initialized GA Thread");
        }
        catch (Throwable throwable) {
            zzae.zzZ("Error initializing the GAThread: " + this.zzf(throwable));
            zzae.zzZ("Google Analytics will not start up.");
            this.zzCK = true;
        }
        while (!this.mClosed) {
            try {
                try {
                    Runnable runnable = this.zzCJ.take();
                    this.zzCN.lock();
                    try {
                        if (this.zzCK) continue;
                        runnable.run();
                    }
                    finally {
                        this.zzCN.unlock();
                    }
                }
                catch (InterruptedException interruptedException) {
                    zzae.zzaa(interruptedException.toString());
                }
            }
            catch (Throwable throwable) {
                zzae.zzZ("Error on GAThread: " + this.zzf(throwable));
                zzae.zzZ("Google Analytics is shutting down.");
                this.zzCK = true;
            }
        }
    }

    @Override
    public LinkedBlockingQueue<Runnable> zzfi() {
        return this.zzCJ;
    }

    @Override
    public Thread getThread() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzfj() {
        this.init();
        ArrayList arrayList = new ArrayList();
        this.zzCJ.drainTo(arrayList);
        this.zzCN.lock();
        try {
            this.zzCK = true;
            for (Runnable runnable : arrayList) {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    zzae.zzZ("Error dispatching all events on exit, giving up: " + this.zzf(throwable));
                    break;
                }
            }
        }
        finally {
            this.zzCN.unlock();
        }
    }

    private class zzc
    implements Runnable {
        private zzc() {
        }

        @Override
        public void run() {
            zzx.this.zzCM.zzfh();
        }
    }

    private class zza
    implements Runnable {
        private zza() {
        }

        @Override
        public void run() {
            zzx.this.zzCM.zzfa();
        }
    }

    private class zzb
    implements Runnable {
        private zzb() {
        }

        @Override
        public void run() {
            zzx.this.zzCM.dispatch();
        }
    }

    private class zzd
    implements Runnable {
        private final Map<String, String> zzCQ;

        zzd(Map<String, String> map) {
            this.zzCQ = new HashMap<String, String>(map);
            String string = map.get("&ht");
            if (string != null) {
                try {
                    Long.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    string = null;
                }
            }
            if (string == null) {
                long l = System.currentTimeMillis();
                this.zzCQ.put("&ht", Long.toString(l));
            }
        }

        @Override
        public void run() {
            Object object;
            this.zzz(this.zzCQ);
            if (TextUtils.isEmpty((CharSequence)this.zzCQ.get("&cid"))) {
                object = zzx.this.zzBN.zzgp();
                this.zzCQ.put("&cid", ((zzk)object).getValue("&cid"));
            }
            if (zzx.this.zzBN.getAppOptOut() || this.zzB(this.zzCQ)) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)zzx.this.zzCL)) {
                zzy.zzfV().zzF(true);
                object = new HitBuilders.HitBuilder().setCampaignParamsFromUrl(zzx.this.zzCL);
                zzx.this.zzCL = null;
                Map<String, String> map = ((HitBuilders.HitBuilder)object).build();
                zzy.zzfV().zzF(false);
                this.zzCQ.putAll(map);
            }
            this.zzA(this.zzCQ);
            object = zzac.zzC(this.zzCQ);
            zzx.this.zzCM.zzb((Map<String, String>)object, Long.valueOf(this.zzCQ.get("&ht")), this.zzy(this.zzCQ), zzx.this.zzCO);
        }

        private String zzy(Map<String, String> map) {
            if (map.containsKey("useSecure")) {
                return zzan.zze(map.get("useSecure"), true) ? "https:" : "http:";
            }
            return "https:";
        }

        private void zzz(Map<String, String> map) {
            Context context = zzx.this.zzBN.getContext();
            com.google.android.gms.analytics.zza zza2 = zzx.this.zzBN.zzgq();
            zzan.zza(map, "&adid", zza2);
            zzan.zza(map, "&ate", zza2);
        }

        private void zzA(Map<String, String> map) {
            zzg zzg2 = zzx.this.zzBN.zzgo();
            zzan.zza(map, "&an", zzg2);
            zzan.zza(map, "&av", zzg2);
            zzan.zza(map, "&aid", zzg2);
            zzan.zza(map, "&aiid", zzg2);
            map.put("&v", "1");
        }

        private boolean zzB(Map<String, String> map) {
            if (map.get("&sf") == null) {
                return false;
            }
            double d = zzan.zza(map.get("&sf"), 100.0);
            if (d >= 100.0) {
                return false;
            }
            String string = map.get("&cid");
            if ((double)(zzx.zzan(string) % 10000) >= d * 100.0) {
                String string2 = map.get("&t") == null ? "unknown" : map.get("&t");
                zzae.zzab(String.format("%s hit sampled out", string2));
                return true;
            }
            return false;
        }
    }
}

