/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.content.Intent;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzae;
import com.google.android.gms.analytics.zzak;
import com.google.android.gms.analytics.zzc;
import com.google.android.gms.analytics.zzf;
import com.google.android.gms.analytics.zzv;
import com.google.android.gms.internal.zzik;
import com.google.android.gms.internal.zzlv;
import com.google.android.gms.internal.zzlx;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

class zzw
implements zzak,
zzc.zzb,
zzc.zzc {
    private volatile long zzCh;
    private volatile zza zzCi;
    private volatile com.google.android.gms.analytics.zzb zzCj;
    private com.google.android.gms.analytics.zzd zzBR;
    private com.google.android.gms.analytics.zzd zzCk;
    private final GoogleAnalytics zzCl;
    private final zzf zzBS;
    private final Context mContext;
    private final Queue<zzd> zzCm = new ConcurrentLinkedQueue<zzd>();
    private volatile int zzCn;
    private volatile Timer zzCo;
    private volatile Timer zzCp;
    private volatile Timer zzCq;
    private boolean zzBV;
    private boolean zzCr;
    private boolean zzCs;
    private boolean zzCt;
    private zzlv zzmW;
    private long zzCu;

    zzw(Context context, zzf zzf2, com.google.android.gms.analytics.zzd zzd2, GoogleAnalytics googleAnalytics) {
        this.zzCk = zzd2;
        this.mContext = context;
        this.zzBS = zzf2;
        this.zzCl = googleAnalytics;
        this.zzCn = 0;
        this.zzCi = zza.zzCD;
        this.zzCu = zzw.zzG(context) ? 10000L : 300000L;
        this.zzmW = zzlx.zzkc();
    }

    zzw(Context context, zzf zzf2) {
        this(context, zzf2, null, GoogleAnalytics.getInstance(context));
    }

    @Override
    public void zzb(Map<String, String> map, long l, String string, List<zzik> list) {
        zzae.zzab("putHit called");
        this.zzCm.add(new zzd(map, l, string, list));
        this.zzfN();
    }

    @Override
    public void dispatch() {
        switch (this.zzCi) {
            case zzCz: {
                this.zzfO();
                break;
            }
            case zzCy: {
                break;
            }
            default: {
                this.zzBV = true;
            }
        }
    }

    @Override
    public void zzfa() {
        zzae.zzab("clearHits called");
        this.zzCm.clear();
        switch (this.zzCi) {
            case zzCz: {
                this.zzBR.zzl(0L);
                this.zzCr = false;
                break;
            }
            case zzCy: {
                this.zzCj.zzfa();
                this.zzCr = false;
                break;
            }
            default: {
                this.zzCr = true;
            }
        }
    }

    @Override
    public synchronized void zzfh() {
        if (this.zzCt) {
            return;
        }
        zzae.zzab("setForceLocalDispatch called.");
        this.zzCt = true;
        switch (this.zzCi) {
            case zzCz: {
                break;
            }
            case zzCy: {
                this.zzdJ();
                break;
            }
            case zzCx: {
                this.zzCs = true;
                break;
            }
            case zzCB: {
                break;
            }
            case zzCC: {
                break;
            }
            case zzCD: {
                break;
            }
        }
    }

    private Timer zza(Timer timer) {
        if (timer != null) {
            timer.cancel();
        }
        return null;
    }

    private void zzfL() {
        this.zzCo = this.zza(this.zzCo);
        this.zzCp = this.zza(this.zzCp);
        this.zzCq = this.zza(this.zzCq);
    }

    @Override
    public void zzfM() {
        if (this.zzCj != null) {
            return;
        }
        this.zzCj = new com.google.android.gms.analytics.zzc(this.mContext, this, this);
        this.zzfQ();
    }

    private synchronized void zzfN() {
        if (!Thread.currentThread().equals(this.zzBS.getThread())) {
            this.zzBS.zzfi().add(new Runnable(){

                @Override
                public void run() {
                    zzw.this.zzfN();
                }
            });
            return;
        }
        if (this.zzCr) {
            this.zzfa();
        }
        switch (this.zzCi) {
            case zzCA: {
                zzae.zzab("Blocked. Dropping hits.");
                this.zzCm.clear();
                break;
            }
            case zzCz: {
                while (!this.zzCm.isEmpty()) {
                    zzd zzd2 = this.zzCm.poll();
                    zzae.zzab("Sending hit to store  " + zzd2);
                    this.zzBR.zza(zzd2.zzfS(), zzd2.zzfT(), zzd2.getPath(), zzd2.zzfU());
                }
                if (!this.zzBV) break;
                this.zzfO();
                break;
            }
            case zzCy: {
                while (!this.zzCm.isEmpty()) {
                    zzd zzd3 = this.zzCm.peek();
                    zzae.zzab("Sending hit to service   " + zzd3);
                    if (!this.zzCl.isDryRunEnabled()) {
                        this.zzCj.zza(zzd3.zzfS(), zzd3.zzfT(), zzd3.getPath(), zzd3.zzfU());
                    } else {
                        zzae.zzab("Dry run enabled. Hit not actually sent to service.");
                    }
                    this.zzCm.poll();
                }
                this.zzCh = this.zzmW.elapsedRealtime();
                break;
            }
            case zzCD: {
                zzae.zzab("Need to reconnect");
                if (this.zzCm.isEmpty()) break;
                this.zzfQ();
                break;
            }
        }
    }

    private void zzfO() {
        this.zzBR.dispatch();
        this.zzBV = false;
    }

    private synchronized void zzfP() {
        if (this.zzCi == zza.zzCz) {
            return;
        }
        if (zzw.zzG(this.mContext)) {
            this.zzCi = zza.zzCA;
            this.zzCj.disconnect();
            zzae.zzac("Attempted to fall back to local store from service.");
            return;
        }
        this.zzfL();
        zzae.zzab("falling back to local store");
        if (this.zzCk != null) {
            this.zzBR = this.zzCk;
        } else {
            zzv zzv2 = zzv.zzfE();
            zzv2.zza(this.mContext, this.zzBS);
            this.zzBR = zzv2.zzE(null);
        }
        this.zzCi = zza.zzCz;
        this.zzfN();
    }

    private static boolean zzG(Context context) {
        return context != null && "com.google.android.gms".equals(context.getPackageName());
    }

    private synchronized void zzfQ() {
        if (!this.zzCt && this.zzCj != null && this.zzCi != zza.zzCz) {
            try {
                ++this.zzCn;
                this.zza(this.zzCp);
                this.zzCi = zza.zzCx;
                this.zzCp = new Timer("Failed Connect");
                this.zzCp.schedule((TimerTask)new zzc(), 3000L);
                zzae.zzab("connecting to Analytics service");
                this.zzCj.connect();
            }
            catch (SecurityException securityException) {
                zzae.zzac("security exception on connectToService");
                this.zzfP();
            }
        } else {
            zzae.zzac("client not initialized.");
            this.zzfP();
        }
    }

    private synchronized void zzdJ() {
        if (this.zzCj != null && this.zzCi == zza.zzCy) {
            this.zzCi = zza.zzCC;
            this.zzCj.disconnect();
        }
    }

    @Override
    public synchronized void onConnected() {
        this.zzCp = this.zza(this.zzCp);
        this.zzCn = 0;
        zzae.zzab("Connected to service");
        this.zzCi = zza.zzCy;
        if (this.zzCs) {
            this.zzdJ();
            this.zzCs = false;
            return;
        }
        this.zzfN();
        this.zzCq = this.zza(this.zzCq);
        this.zzCq = new Timer("disconnect check");
        this.zzCq.schedule((TimerTask)new zzb(), this.zzCu);
    }

    @Override
    public synchronized void onDisconnected() {
        if (this.zzCi == zza.zzCA) {
            zzae.zzab("Service blocked.");
            this.zzfL();
        } else if (this.zzCi == zza.zzCC) {
            zzae.zzab("Disconnected from service");
            this.zzfL();
            this.zzCi = zza.zzCD;
        } else {
            zzae.zzab("Unexpected disconnect.");
            this.zzCi = zza.zzCB;
            if (this.zzCn < 2) {
                this.zzfR();
            } else {
                this.zzfP();
            }
        }
    }

    @Override
    public synchronized void zza(int n, Intent intent) {
        this.zzCi = zza.zzCB;
        if (this.zzCn < 2) {
            zzae.zzac("Service unavailable (code=" + n + "), will retry.");
            this.zzfR();
        } else {
            zzae.zzac("Service unavailable (code=" + n + "), using local store.");
            this.zzfP();
        }
    }

    private void zzfR() {
        this.zzCo = this.zza(this.zzCo);
        this.zzCo = new Timer("Service Reconnect");
        this.zzCo.schedule((TimerTask)new zze(), 5000L);
    }

    private static class zzd {
        private final Map<String, String> zzCF;
        private final long zzCG;
        private final String zzCH;
        private final List<zzik> zzCI;

        public zzd(Map<String, String> map, long l, String string, List<zzik> list) {
            this.zzCF = map;
            this.zzCG = l;
            this.zzCH = string;
            this.zzCI = list;
        }

        public Map<String, String> zzfS() {
            return this.zzCF;
        }

        public long zzfT() {
            return this.zzCG;
        }

        public String getPath() {
            return this.zzCH;
        }

        public List<zzik> zzfU() {
            return this.zzCI;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("PATH: ");
            stringBuilder.append(this.zzCH);
            if (this.zzCF != null) {
                stringBuilder.append("  PARAMS: ");
                for (Map.Entry<String, String> entry : this.zzCF.entrySet()) {
                    stringBuilder.append(entry.getKey());
                    stringBuilder.append("=");
                    stringBuilder.append(entry.getValue());
                    stringBuilder.append(",  ");
                }
            }
            return stringBuilder.toString();
        }
    }

    private class zzb
    extends TimerTask {
        private zzb() {
        }

        @Override
        public void run() {
            if (zzw.this.zzCi == zza.zzCy && zzw.this.zzCm.isEmpty() && zzw.this.zzCh + zzw.this.zzCu < zzw.this.zzmW.elapsedRealtime()) {
                zzae.zzab("Disconnecting due to inactivity");
                zzw.this.zzdJ();
            } else {
                zzw.this.zzCq.schedule((TimerTask)new zzb(), zzw.this.zzCu);
            }
        }
    }

    private class zze
    extends TimerTask {
        private zze() {
        }

        @Override
        public void run() {
            zzw.this.zzfQ();
        }
    }

    private class zzc
    extends TimerTask {
        private zzc() {
        }

        @Override
        public void run() {
            if (zzw.this.zzCi == zza.zzCx) {
                zzw.this.zzfP();
            }
        }
    }

    private static enum zza {
        zzCx,
        zzCy,
        zzCz,
        zzCA,
        zzCB,
        zzCC,
        zzCD;

    }
}

