/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import com.google.android.gms.analytics.AnalyticsReceiver;
import com.google.android.gms.analytics.AnalyticsService;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzae;
import com.google.android.gms.analytics.zzag;
import com.google.android.gms.analytics.zzaj;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.analytics.zze;
import com.google.android.gms.analytics.zzf;
import com.google.android.gms.analytics.zzj;
import com.google.android.gms.analytics.zzu;
import com.google.android.gms.analytics.zzy;

class zzv
extends zzaj {
    private static final Object zzBQ = new Object();
    private Context mContext;
    private zzd zzBR;
    private volatile zzf zzBS;
    private int zzBT = 1800;
    private long zzBU = Long.MIN_VALUE;
    private boolean zzBV = true;
    private boolean zzBW;
    private String zzBX;
    private boolean zzBY = false;
    private boolean zzBZ = true;
    private boolean zzCa = true;
    private zze zzCb = new zze(){

        @Override
        public void zzD(boolean bl) {
            zzv.this.zzb(bl, zzv.this.zzBZ);
        }
    };
    private Handler mHandler;
    private boolean zzCc;
    private zzu zzCd;
    private boolean zzCe = false;
    private boolean zzBs = false;
    private static zzv zzCf;

    public static zzv zzfE() {
        if (zzCf == null) {
            zzCf = new zzv();
        }
        return zzCf;
    }

    private zzv() {
    }

    private void zzfF() {
        this.zzCd = new zzu(this);
        this.zzCd.zzD(this.mContext);
    }

    private PendingIntent zzfG() {
        Intent intent = new Intent(this.mContext.getApplicationContext(), AnalyticsReceiver.class);
        intent.setAction("com.google.android.gms.analytics.ANALYTICS_DISPATCH");
        return PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
    }

    private AlarmManager zzfH() {
        PendingIntent pendingIntent = this.zzfG();
        AlarmManager alarmManager = (AlarmManager)this.mContext.getApplicationContext().getSystemService("alarm");
        alarmManager.cancel(pendingIntent);
        return alarmManager;
    }

    private void zzh(int n, int n2) {
        if (!this.zzBY) {
            if (n < 1800) {
                n = 1800;
            }
            if (n2 < 1800) {
                n2 = 1800;
            }
        }
        AlarmManager alarmManager = this.zzfH();
        alarmManager.setInexactRepeating(2, (long)(n * 1000), (long)(n2 * 1000), this.zzfG());
    }

    private void zzfI() {
        try {
            this.zzfH();
            ActivityInfo activityInfo = this.mContext.getPackageManager().getReceiverInfo(new ComponentName(this.mContext, AnalyticsReceiver.class), 2);
            if (activityInfo != null && activityInfo.enabled && this.zzBT > 0) {
                this.zzh(this.zzBT, this.zzBT);
                zzae.zzab("Using a receiver for local dispatch.");
                this.zzCc = true;
                return;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        zzae.zzab("Receiver for local dispatch not registered. For more reliable analytics, please see http://goo.gl/8Rd3yj for instructions.");
        this.mHandler = new Handler(this.mContext.getMainLooper(), new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                if (1 == msg.what && zzBQ.equals(msg.obj)) {
                    long l = SystemClock.elapsedRealtime();
                    if (l >= zzv.this.zzBU + (long)(zzv.this.zzBT * 1000)) {
                        zzy.zzfV().zzF(true);
                        zzv.this.dispatchLocalHits();
                        zzy.zzfV().zzF(false);
                        zzv.this.zzBU = l;
                    }
                    if (zzv.this.zzBT > 0 && !zzv.this.zzCe) {
                        zzv.this.mHandler.sendMessageDelayed(zzv.this.mHandler.obtainMessage(1, zzBQ), (long)(Math.min(60, zzv.this.zzBT) * 1000));
                    }
                }
                return true;
            }
        });
        if (this.zzBT > 0) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, zzBQ), (long)(Math.min(60, this.zzBT) * 1000));
        }
    }

    synchronized void zza(Context context, zzf zzf2) {
        if (this.mContext != null) {
            return;
        }
        this.mContext = context.getApplicationContext();
        if (this.zzBS == null) {
            this.zzBS = zzf2;
            if (this.zzBV) {
                this.dispatchLocalHits();
                this.zzBV = false;
            }
            if (this.zzBW) {
                this.zzfh();
                this.zzBW = false;
            }
        }
    }

    @Override
    synchronized zzd zzE(Context context) {
        if (context != null && this.mContext == null) {
            this.mContext = context;
        }
        if (this.zzBR == null) {
            if (this.mContext == null) {
                throw new IllegalStateException("Cant get a store unless we have a context");
            }
            this.zzBR = new zzag(this.zzCb, this.mContext, new zzj());
            this.zzBR.setDryRun(this.zzBs);
            if (this.zzBX != null) {
                this.zzBR.zzff().zzak(this.zzBX);
                this.zzBX = null;
            }
        }
        if (this.mHandler == null && !this.zzCc) {
            this.zzfI();
        }
        if (this.zzCd == null && this.zzCa) {
            this.zzfF();
        }
        return this.zzBR;
    }

    @Override
    synchronized void dispatchLocalHits() {
        this.zzF(null);
    }

    synchronized void zzF(Context context) {
        zzf zzf2 = null;
        if (this.zzBS != null) {
            zzf2 = this.zzBS;
        } else if (context != null) {
            zzf2 = GoogleAnalytics.getInstance(context).zzgm();
        } else if (GoogleAnalytics.zzgj() != null) {
            zzf2 = GoogleAnalytics.zzgj().zzgm();
        }
        if (zzf2 == null) {
            zzae.zzab("Dispatch call queued. Dispatch will run once initialization is complete.");
            this.zzBV = true;
            return;
        }
        zzy.zzfV().zza(zzy.zza.zzDN);
        zzf2.dispatch();
    }

    @Override
    synchronized void setLocalDispatchPeriod(int dispatchPeriodInSeconds) {
        if (this.mHandler == null && !this.zzCc) {
            zzae.zzab("Dispatch period set with null handler and no receiver. Dispatch will run once initialization is complete.");
            this.zzBT = dispatchPeriodInSeconds;
            AnalyticsService.zzC(dispatchPeriodInSeconds);
            return;
        }
        zzy.zzfV().zza(zzy.zza.zzDO);
        if (!this.zzCe && this.zzBZ && this.zzBT > 0) {
            if (this.mHandler != null) {
                this.mHandler.removeMessages(1, zzBQ);
            }
            if (this.zzCc) {
                this.zzfH();
            }
        }
        this.zzBT = dispatchPeriodInSeconds;
        AnalyticsService.zzC(dispatchPeriodInSeconds);
        if (dispatchPeriodInSeconds > 0 && !this.zzCe && this.zzBZ) {
            if (this.mHandler != null) {
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, zzBQ), (long)(Math.min(60, this.zzBT) * 1000));
            }
            if (this.zzCc) {
                this.zzh(dispatchPeriodInSeconds, dispatchPeriodInSeconds);
            }
        }
    }

    void zzfh() {
        if (this.zzBS == null) {
            zzae.zzab("setForceLocalDispatch() queued. It will be called once initialization is complete.");
            this.zzBW = true;
            return;
        }
        zzy.zzfV().zza(zzy.zza.zzEa);
        this.zzBS.zzfh();
    }

    synchronized void zzb(boolean bl, boolean bl2) {
        if (this.zzCe == bl && this.zzBZ == bl2) {
            return;
        }
        if ((bl || !bl2) && this.zzBT > 0) {
            if (this.mHandler != null) {
                this.mHandler.removeMessages(1, zzBQ);
            }
            if (this.zzCc) {
                this.zzfH();
            }
        }
        if (!bl && bl2 && this.zzBT > 0) {
            if (this.mHandler != null) {
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, zzBQ), (long)(Math.min(60, this.zzBT) * 1000));
            }
            if (this.zzCc) {
                this.zzh(this.zzBT, this.zzBT);
            }
        }
        zzae.zzab("PowerSaveMode " + (bl || !bl2 ? "initiated." : "terminated."));
        this.zzCe = bl;
        this.zzBZ = bl2;
    }

    @Override
    synchronized void zzE(boolean bl) {
        this.zzb(this.zzCe, bl);
    }

    @Override
    synchronized void zzfJ() {
        if (!this.zzCe && this.zzBZ && this.zzBT > 0) {
            if (this.mHandler != null) {
                this.mHandler.removeMessages(1, zzBQ);
                this.zzBU = Long.MIN_VALUE;
                this.mHandler.sendMessage(this.mHandler.obtainMessage(1, zzBQ));
            }
            if (this.zzCc) {
                this.zzh(0, this.zzBT);
            }
        }
    }
}

