/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.text.TextUtils;
import com.google.android.gms.analytics.zzae;
import com.google.android.gms.analytics.zzm;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

abstract class zzn<T extends zzm> {
    Context mContext;
    zza<T> zzBI;

    public zzn(Context context, zza<T> zza2) {
        this.mContext = context;
        this.zzBI = zza2;
    }

    public T zzD(int n) {
        try {
            return this.zza(this.mContext.getResources().getXml(n));
        }
        catch (Resources.NotFoundException notFoundException) {
            zzae.zzac("inflate() called with unknown resourceId: " + (Object)((Object)notFoundException));
            return null;
        }
    }

    private T zza(XmlResourceParser xmlResourceParser) {
        try {
            xmlResourceParser.next();
            int n = xmlResourceParser.getEventType();
            while (n != 1) {
                if (xmlResourceParser.getEventType() == 2) {
                    String string;
                    String string2;
                    String string3 = xmlResourceParser.getName().toLowerCase();
                    if (string3.equals("screenname")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string)) {
                            this.zzBI.zzi(string2, string);
                        }
                    } else if (string3.equals("string")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && string != null) {
                            this.zzBI.zzj(string2, string);
                        }
                    } else if (string3.equals("bool")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string)) {
                            try {
                                boolean bl = Boolean.parseBoolean(string);
                                this.zzBI.zzd(string2, bl);
                            }
                            catch (NumberFormatException numberFormatException) {
                                zzae.zzZ("Error parsing bool configuration value: " + string);
                            }
                        }
                    } else if (string3.equals("integer")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string)) {
                            try {
                                int n2 = Integer.parseInt(string);
                                this.zzBI.zzc(string2, n2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                zzae.zzZ("Error parsing int configuration value: " + string);
                            }
                        }
                    }
                }
                n = xmlResourceParser.next();
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            zzae.zzZ("Error parsing tracker configuration file: " + (Object)((Object)xmlPullParserException));
        }
        catch (IOException iOException) {
            zzae.zzZ("Error parsing tracker configuration file: " + iOException);
        }
        return this.zzBI.zzfB();
    }

    public static interface zza<U extends zzm> {
        public void zzi(String var1, String var2);

        public void zzj(String var1, String var2);

        public void zzd(String var1, boolean var2);

        public void zzc(String var1, int var2);

        public U zzfB();
    }
}

