/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.zzae;
import com.google.android.gms.analytics.zzq;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzra;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class zzk
implements zzq {
    private final zzra zzAM;
    private volatile String zzBC;
    private Future<String> zzBD;

    protected zzk(zzra zzra2) {
        zzx.zzl((Object)zzra2);
        this.zzAM = zzra2;
        this.zzBD = zzra2.zza(new Callable<String>(){

            public String zzfA() throws Exception {
                return zzk.this.zzfx();
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzfA();
            }
        });
    }

    public boolean zzaj(String string) {
        return "&cid".equals(string);
    }

    @Override
    public String getValue(String field) {
        if ("&cid".equals(field)) {
            return this.zzfv();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String zzfv() {
        zzk zzk2 = this;
        synchronized (zzk2) {
            if (this.zzBD != null) {
                try {
                    this.zzBC = this.zzBD.get();
                }
                catch (InterruptedException interruptedException) {
                    zzae.zzZ("Exception while waiting for clientId: " + interruptedException);
                    this.zzBC = "0";
                }
                catch (ExecutionException executionException) {
                    zzae.zzZ("Exception while waiting for clientId: " + executionException);
                    this.zzBC = "0";
                }
                zzae.zzab("Loaded clientId");
                this.zzBD = null;
            }
            return this.zzBC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String zzfw() {
        zzk zzk2 = this;
        synchronized (zzk2) {
            this.zzBC = null;
            this.zzBD = this.zzAM.zza(new Callable<String>(){

                public String zzfA() throws Exception {
                    return zzk.this.zzfy();
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.zzfA();
                }
            });
        }
        return this.zzfv();
    }

    String zzfx() {
        String string = zzk.zzC(this.zzAM.getContext());
        if (string == null) {
            string = this.zzfy();
        }
        return string;
    }

    private String zzfy() {
        String string = this.zzfz();
        try {
            if (!zzk.zzf(this.zzAM.getContext(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            zzae.zzZ("Error saving clientId file: " + exception);
            return "0";
        }
        return string;
    }

    protected String zzfz() {
        return UUID.randomUUID().toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String zzC(Context context) {
        zzx.zzbe((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, byArray.length);
            if (fileInputStream.available() > 0) {
                zzae.zzZ("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                String string = null;
                return string;
            }
            if (n < 14) {
                zzae.zzZ("clientId file seems empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                String string = null;
                return string;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            zzae.zzab("Loaded client id from disk.");
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = null;
            return string;
        }
        catch (IOException iOException) {
            zzae.zzZ("Error reading clientId file, deleting it.");
            context.deleteFile("gaClientId");
            String string = null;
            return string;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    zzae.zzZ("Failed to close clientId reading stream: " + iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean zzf(Context context, String string) {
        zzx.zzbn((String)string);
        zzx.zzbe((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            zzae.zzab("Storing clientId.");
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzae.zzZ("Error creating clientId file.");
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            zzae.zzZ("Error writing to clientId file.");
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    zzae.zzZ("Failed to close clientId writing stream: " + iOException);
                }
            }
        }
    }
}

