/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.analytics.zzab;
import com.google.android.gms.analytics.zzac;
import com.google.android.gms.analytics.zzae;
import com.google.android.gms.analytics.zzaf;
import com.google.android.gms.analytics.zzan;
import com.google.android.gms.analytics.zzi;
import com.google.android.gms.analytics.zzl;
import com.google.android.gms.analytics.zzo;
import com.google.android.gms.analytics.zzr;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;

public class zzh
implements zzr {
    private final String zzyW;
    private final HttpClient zzBe;
    private final Context mContext;
    private URL zzBf;
    private int zzBg;
    private int zzBh;
    private int zzBi;
    private String zzBj;
    private String zzBk;
    private zzi zzBl;
    private zzl zzBm;
    private Set<Integer> zzBn = new HashSet<Integer>();
    private boolean zzBo = false;
    private long zzBp;
    private long zzBq;
    private zzo zzBr;
    private volatile boolean zzBs = false;

    zzh(HttpClient httpClient, Context context, zzo zzo2) {
        this.mContext = context.getApplicationContext();
        this.zzBr = zzo2;
        this.zzyW = this.zza("GoogleAnalytics", "4.0.6", Build.VERSION.RELEASE, zzan.zza(Locale.getDefault()), Build.MODEL, Build.ID);
        this.zzBe = httpClient;
    }

    @Override
    public boolean zzfk() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzae.zzab("...no network connectivity");
            return false;
        }
        return true;
    }

    @Override
    public void zzak(String string) {
        try {
            this.zzBf = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.zzBf = null;
        }
    }

    String zza(String string, String string2, String string3, String string4, String string5, String string6) {
        return String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string, string2, string3, string4, string5, string6);
    }

    int zza(List<zzab> list, int n) {
        if (list.isEmpty()) {
            return 0;
        }
        if (n > list.size()) {
            n = list.size();
        }
        int n2 = n;
        long l = 0L;
        for (int i = n - 1; i > 0; --i) {
            zzab zzab2 = list.get(i - 1);
            zzab zzab3 = list.get(i);
            long l2 = zzab2.zzgt();
            long l3 = zzab3.zzgt();
            if (l2 == 0L || l3 == 0L || l3 - l2 <= l) continue;
            l = l3 - l2;
            n2 = i;
        }
        return n2;
    }

    int zzb(List<zzab> list, int n) {
        if (list.isEmpty()) {
            return 0;
        }
        int n2 = n;
        for (int i = n - 1; i > 0; --i) {
            String string = list.get(i).zzgr();
            if (TextUtils.isEmpty((CharSequence)string)) continue;
            if (string.contains("sc=start")) {
                n2 = i;
                break;
            }
            if (!string.contains("sc=end")) continue;
            n2 = i + 1;
            break;
        }
        return n2;
    }

    private boolean zza(String string, HttpHost httpHost, int n, zzaf zzaf2, zzl zzl2) {
        boolean bl;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = bl = n > 1;
        if (string.getBytes().length > this.zzBi || string.getBytes().length > this.zzBh) {
            zzae.zzac("Request too long (> " + Math.min(this.zzBh, this.zzBi) + " bytes)--not sent");
        } else if (this.zzBs) {
            zzae.zzaa("Dry run enabled. Hit not actually sent.");
        } else {
            Object object;
            ByteArrayOutputStream byteArrayOutputStream;
            HttpEntityEnclosingRequest httpEntityEnclosingRequest = this.zzc(string, bl);
            if (httpEntityEnclosingRequest == null) {
                return true;
            }
            if (httpEntityEnclosingRequest.getRequestLine().getMethod().equals("GET")) {
                n2 = string.getBytes().length;
                n3 = string.getBytes().length;
            } else {
                try {
                    switch (zzl2) {
                        case zzBG: {
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                            gZIPOutputStream.write(string.getBytes());
                            gZIPOutputStream.close();
                            object = byteArrayOutputStream.toByteArray();
                            n3 += ((byte[])object).length;
                            httpEntityEnclosingRequest.setEntity((HttpEntity)new ByteArrayEntity(object));
                            httpEntityEnclosingRequest.addHeader("Content-Encoding", "gzip");
                            break;
                        }
                        default: {
                            n3 = string.getBytes().length;
                            httpEntityEnclosingRequest.setEntity((HttpEntity)new StringEntity(string));
                        }
                    }
                    n2 = string.getBytes().length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    zzae.zzZ("Encoding error, hit will be discarded");
                    return true;
                }
                catch (IOException iOException) {
                    zzae.zzZ("Unexpected IOException: " + iOException.getMessage());
                    zzae.zzZ("Request will be discarded");
                    return true;
                }
            }
            httpEntityEnclosingRequest.addHeader("Host", httpHost.toHostString());
            if (zzae.zzgw()) {
                this.zza(httpEntityEnclosingRequest);
            }
            try {
                byteArrayOutputStream = this.zzBe.execute(httpHost, (HttpRequest)httpEntityEnclosingRequest);
                zzaf2.zze("_td", n2);
                zzaf2.zze("_cd", n3);
                int n4 = byteArrayOutputStream.getStatusLine().getStatusCode();
                object = byteArrayOutputStream.getEntity();
                if (object != null) {
                    object.consumeContent();
                }
                if (n4 != 200) {
                    if (bl && this.zzBn.contains(n4)) {
                        zzae.zzaa("Falling back to single hit per request mode.");
                        this.zzBo = true;
                        this.zzBp = System.currentTimeMillis();
                        return false;
                    }
                    zzae.zzac("Bad response: " + byteArrayOutputStream.getStatusLine().getStatusCode());
                }
            }
            catch (ClientProtocolException clientProtocolException) {
                zzae.zzac("ClientProtocolException sending hit; discarding hit...");
            }
            catch (IOException iOException) {
                zzae.zzac("Exception sending hit: " + iOException.getClass().getSimpleName());
                zzae.zzac(iOException.getMessage());
                return false;
            }
        }
        return true;
    }

    private String zza(zzab zzab2, List<String> list, zzi zzi2) {
        String string;
        if (zzi2 == zzi.zzBv) {
            string = zzab2.zzgr() == null || zzab2.zzgr().length() == 0 ? "" : zzab2.zzgr();
            long l = System.currentTimeMillis();
            string = TextUtils.isEmpty((CharSequence)string) ? "" : zzac.zza(zzab2, l);
        } else {
            string = "";
            for (String string2 : list) {
                if (string2.length() == 0) continue;
                if (string.length() != 0) {
                    string = string + "\n";
                }
                string = string + string2;
            }
        }
        return string;
    }

    @Override
    public int zza(List<zzab> list, zzaf zzaf2, boolean bl) {
        String string;
        zzab zzab22;
        zzl zzl2;
        zzi zzi2;
        this.zzBg = this.zzBr.zzfl();
        this.zzBh = this.zzBr.zzfm();
        this.zzBi = this.zzBr.zzfn();
        int n = this.zzBr.zzfo();
        this.zzBj = this.zzBr.zzfq();
        this.zzBk = this.zzBr.zzfr();
        this.zzBl = this.zzBr.zzfs();
        this.zzBm = this.zzBr.zzft();
        this.zzBn.clear();
        this.zzBn.addAll(this.zzBr.zzfu());
        this.zzBq = this.zzBr.zzfp();
        if (!this.zzBo && this.zzBn.isEmpty()) {
            this.zzBo = true;
            this.zzBp = System.currentTimeMillis();
        }
        if (this.zzBo && System.currentTimeMillis() - this.zzBp > 1000L * this.zzBq) {
            this.zzBo = false;
        }
        if (this.zzBo) {
            zzi2 = zzi.zzBv;
            zzl2 = zzl.zzBF;
        } else {
            zzi2 = this.zzBl;
            zzl2 = this.zzBm;
        }
        int n2 = 0;
        int n3 = Math.min(list.size(), n);
        zzaf2.zze("_hr", list.size());
        long l = System.currentTimeMillis();
        List<String> list2 = new ArrayList<String>();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        int n4 = n3;
        int n5 = 0;
        if (zzi2 != zzi.zzBv) {
            n4 = 1;
            for (zzab zzab22 : list) {
                String string2 = string = TextUtils.isEmpty((CharSequence)zzab22.zzgr()) ? "" : zzac.zza(zzab22, l);
                if (string.getBytes().length > this.zzBh) {
                    string = "";
                }
                list2.add(string);
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    l2 += (long)(string.getBytes().length + (n5 == 0 ? 0 : 1));
                }
                arrayList.add(l2);
                if (l2 <= (long)this.zzBi) {
                    ++n5;
                }
                if (n5 != n3) continue;
                break;
            }
        }
        while (n5 > 1 && (Long)arrayList.get(n5 - 1) > (long)this.zzBi) {
            --n5;
        }
        if (l2 > (long)this.zzBi) {
            int n6 = 0;
            switch (zzi2) {
                case zzBz: {
                    int n7 = list2.size() / 2;
                    if (n5 > n7) {
                        n6 = n7;
                        break;
                    }
                    n6 = n5;
                    break;
                }
                case zzBx: {
                    n6 = this.zza(list, n5);
                    break;
                }
                case zzBw: {
                    n6 = this.zzb(list, n5);
                    break;
                }
                case zzBA: {
                    if (l2 < (long)(this.zzBi * 2)) {
                        int n8;
                        for (n8 = arrayList.size() - 1; n8 > 0 && (Long)arrayList.get(n8) > l2 / 2L; --n8) {
                        }
                        n6 = n8;
                        break;
                    }
                    n6 = n5;
                    break;
                }
                case zzBy: {
                    n6 = n5;
                    break;
                }
                default: {
                    zzae.zzac("Unexpected batching strategy encountered; sending a single hit.");
                    n6 = 1;
                    string = (String)list2.get(0);
                    list2.clear();
                    list2.add(string);
                }
            }
            if (n6 < list2.size()) {
                list2 = list2.subList(0, n6);
            }
        }
        int n9 = 0;
        zzab22 = null;
        for (int i = 0; i < n4; ++i) {
            zzab zzab3 = list.get(i);
            URL uRL = this.zza(zzab3);
            int n10 = Math.max(1, list2.size());
            if (uRL == null) {
                zzae.zzac("No destination: discarding hit.");
                n9 += n10;
                n2 += n10;
                continue;
            }
            zzab22 = new HttpHost(uRL.getHost(), uRL.getPort(), uRL.getProtocol());
            String string3 = this.zza(zzab3, list2, zzi2);
            if (!this.zza(string3, (HttpHost)zzab22, n10, zzaf2, zzl2)) {
                zzaf2.zze("_de", 1);
                zzaf2.zze("_hd", n9);
                zzaf2.zze("_hs", n2);
                this.zza(zzaf2, (HttpHost)zzab22, zzi2, zzl2);
                return n2;
            }
            for (String string4 : list2) {
                if (!TextUtils.isEmpty((CharSequence)string4)) continue;
                ++n9;
            }
            zzaf2.zze("_rs", 1);
            n2 += n10;
        }
        zzaf2.zze("_hd", n9);
        zzaf2.zze("_hs", n2);
        if (bl) {
            this.zza(zzaf2, (HttpHost)zzab22, zzi2, zzl2);
        }
        return n2;
    }

    private void zza(zzaf zzaf2, HttpHost httpHost, zzi zzi2, zzl zzl2) {
        zzaf2.zzk("_bs", zzi2.toString());
        zzaf2.zzk("_cs", zzl2.toString());
        String string = zzaf2.zzgx();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        HttpHost httpHost2 = httpHost;
        if (httpHost2 == null) {
            try {
                URL uRL = new URL("https://ssl.google-analytics.com");
                httpHost2 = new HttpHost(uRL.getHost(), uRL.getPort(), uRL.getProtocol());
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
        }
        this.zza(string, httpHost2, 1, zzaf2, zzl.zzBF);
    }

    private HttpEntityEnclosingRequest zzc(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            System.out.println("Empty hit, discarding.");
            return null;
        }
        String string2 = this.zzBj + "?" + string;
        BasicHttpEntityEnclosingRequest basicHttpEntityEnclosingRequest = string2.length() < this.zzBg && !bl ? new BasicHttpEntityEnclosingRequest("GET", string2) : (bl ? new BasicHttpEntityEnclosingRequest("POST", this.zzBk) : new BasicHttpEntityEnclosingRequest("POST", this.zzBj));
        basicHttpEntityEnclosingRequest.addHeader("User-Agent", this.zzyW);
        return basicHttpEntityEnclosingRequest;
    }

    private void zza(HttpEntityEnclosingRequest httpEntityEnclosingRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Header header : httpEntityEnclosingRequest.getAllHeaders()) {
            stringBuffer.append(header.toString()).append("\n");
        }
        stringBuffer.append(httpEntityEnclosingRequest.getRequestLine().toString()).append("\n");
        if (httpEntityEnclosingRequest.getEntity() != null) {
            try {
                int n;
                InputStream inputStream = httpEntityEnclosingRequest.getEntity().getContent();
                if (inputStream != null && (n = inputStream.available()) > 0) {
                    byte[] byArray = new byte[n];
                    inputStream.read(byArray);
                    stringBuffer.append("POST:\n");
                    stringBuffer.append(new String(byArray)).append("\n");
                }
            }
            catch (IOException iOException) {
                zzae.zzac("Error Writing hit to log...");
            }
        }
        zzae.zzaa(stringBuffer.toString());
    }

    private URL zza(zzab zzab2) {
        if (this.zzBf != null) {
            return this.zzBf;
        }
        String string = zzab2.zzgu();
        try {
            return new URL("http:".equals(string) ? "http://www.google-analytics.com/collect" : "https://ssl.google-analytics.com/collect");
        }
        catch (MalformedURLException malformedURLException) {
            zzae.zzZ("Error trying to parse the hardcoded host url. This really shouldn't happen.");
            return null;
        }
    }

    @Override
    public void setDryRun(boolean dryRun) {
        this.zzBs = dryRun;
    }
}

