/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzab;
import com.google.android.gms.analytics.zzac;
import com.google.android.gms.analytics.zzae;
import com.google.android.gms.analytics.zzaf;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.analytics.zze;
import com.google.android.gms.analytics.zzh;
import com.google.android.gms.analytics.zzo;
import com.google.android.gms.analytics.zzr;
import com.google.android.gms.analytics.zzt;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzik;
import com.google.android.gms.internal.zzlv;
import com.google.android.gms.internal.zzlx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

class zzag
implements zzd {
    private static final String zzES = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private static final String zzET = String.format("SELECT COUNT(*), MIN(%s), MAX(%s) FROM %s WHERE 1;", "hit_time", "hit_time", "hits2");
    private final zza zzEU;
    private volatile zzr zzEV;
    private final zze zzCb;
    private final Context mContext;
    private final String zzEW;
    private zzaf zzEX;
    private long zzEY;
    private final int zzEZ;
    private zzlv zzmW;
    private zzo zzBr;
    private volatile boolean zzBs = true;

    zzag(zze zze2, Context context, zzo zzo2) {
        this(zze2, context, "google_analytics_v4.db", 2000, zzo2);
    }

    zzag(zze zze2, Context context, String string, int n, zzo zzo2) {
        this.mContext = context.getApplicationContext();
        this.zzBr = zzo2;
        this.zzEW = string;
        this.zzCb = zze2;
        this.zzmW = zzlx.zzkc();
        this.zzEU = new zza(this.mContext, this.zzEW);
        this.zzEV = new zzh((HttpClient)new DefaultHttpClient(), this.mContext, this.zzBr);
        this.zzEY = 0L;
        this.zzEZ = n;
    }

    @Override
    public void setDryRun(boolean dryRun) {
        this.zzBs = dryRun;
        if (this.zzEV != null) {
            this.zzEV.setDryRun(dryRun);
        }
    }

    @Override
    public synchronized void zzl(long l) {
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for clearHits");
        if (sQLiteDatabase != null) {
            if (l == 0L) {
                sQLiteDatabase.delete("hits2", null, null);
            } else {
                String[] stringArray = new String[]{Long.valueOf(l).toString()};
                sQLiteDatabase.delete("hits2", "hit_app_id = ?", stringArray);
            }
            this.zzCb.zzD(this.zzgA() == 0);
        }
    }

    @Override
    public void zza(Map<String, String> map, long l, String string, Collection<zzik> collection) {
        this.zzgz();
        this.zzgy();
        this.zza(map, collection);
        this.zza(map, l, string);
    }

    private void zza(Map<String, String> map, Collection<zzik> collection) {
        String string = "&_v".substring(1);
        if (collection != null) {
            for (zzik zzik2 : collection) {
                if (!"appendVersion".equals(zzik2.getId())) continue;
                map.put(string, zzik2.getValue());
                break;
            }
        }
    }

    private void zzgy() {
        int n = this.zzgA() - this.zzEZ + 1;
        if (n > 0) {
            List<String> list = this.zzM(n);
            zzae.zzab("Store full, deleting " + list.size() + " hits to make room.");
            this.zzb(list.toArray(new String[0]));
        }
    }

    private synchronized void zza(Map<String, String> map, long l, String string) {
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for putHit");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_string", zzag.zzD(map));
        contentValues.put("hit_time", Long.valueOf(l));
        long l2 = 0L;
        if (map.containsKey("AppUID")) {
            try {
                l2 = Long.parseLong(map.get("AppUID"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        contentValues.put("hit_app_id", Long.valueOf(l2));
        if (string == null) {
            string = "http://www.google-analytics.com/collect";
        }
        if (string.length() == 0) {
            zzae.zzac("Empty path: not sending hit");
            return;
        }
        contentValues.put("hit_url", string);
        try {
            sQLiteDatabase.insert("hits2", null, contentValues);
            this.zzCb.zzD(false);
        }
        catch (SQLiteException sQLiteException) {
            zzae.zzac("Error storing hit");
        }
    }

    static String zzD(Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            arrayList.add(zzac.encode(entry.getKey()) + "=" + zzac.encode(entry.getValue()));
        }
        return TextUtils.join((CharSequence)"&", arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<String> zzM(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n <= 0) {
            zzae.zzac("Invalid maxHits specified. Skipping");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for peekHitIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<zzab> zzN(int n) {
        ArrayList<zzab> arrayList = new ArrayList<zzab>();
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for peekHits");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_time"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            arrayList = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    zzab zzab2 = new zzab(null, cursor.getLong(0), cursor.getLong(1), "");
                    arrayList.add(zzab2);
                } while (cursor.moveToNext());
            }
        }
        int n2 = 0;
        try {
            CursorWindow cursorWindow;
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_string", "hit_url"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            if (cursor.moveToFirst()) {
                do {
                    if ((cursorWindow = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        ((zzab)arrayList.get(n2)).zzap(cursor.getString(1));
                        ((zzab)arrayList.get(n2)).zzaq(cursor.getString(2));
                    } else {
                        zzae.zzac(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((zzab)arrayList.get(n2)).zzgs()));
                    }
                    ++n2;
                } while (cursor.moveToNext());
            }
            cursorWindow = arrayList;
            return cursorWindow;
        }
        catch (SQLiteException sQLiteException) {
            zzae.zzac("Error in peekHits fetching hitString: " + sQLiteException.getMessage());
            ArrayList<zzab> arrayList2 = new ArrayList<zzab>();
            boolean bl = false;
            for (zzab zzab3 : arrayList) {
                if (TextUtils.isEmpty((CharSequence)zzab3.zzgr())) {
                    if (bl) break;
                    bl = true;
                }
                arrayList2.add(zzab3);
            }
            ArrayList<zzab> arrayList3 = arrayList2;
            return arrayList3;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    synchronized int zzgz() {
        long l = this.zzmW.currentTimeMillis();
        if (l <= this.zzEY + 86400000L) {
            return 0;
        }
        this.zzEY = l;
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for deleteStaleHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        long l2 = this.zzmW.currentTimeMillis() - 2592000000L;
        int n = sQLiteDatabase.delete("hits2", "HIT_TIME < ?", new String[]{Long.toString(l2)});
        this.zzCb.zzD(this.zzgA() == 0);
        return n;
    }

    @Deprecated
    void zzb(Collection<zzab> collection) {
        if (collection == null || collection.isEmpty()) {
            zzae.zzac("Empty/Null collection passed to deleteHits.");
            return;
        }
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (zzab zzab2 : collection) {
            stringArray[n++] = String.valueOf(zzab2.zzgs());
        }
        this.zzb(stringArray);
    }

    synchronized void zzb(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            zzae.zzac("Empty hitIds passed to deleteHits.");
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for deleteHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("hits2", string, stringArray);
            this.zzCb.zzD(this.zzgA() == 0);
        }
        catch (SQLiteException sQLiteException) {
            zzae.zzac("Error deleting hits " + TextUtils.join((CharSequence)",", (Object[])stringArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int zzgA() {
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from hits2", null);
            if (cursor.moveToFirst()) {
                n = (int)cursor.getLong(0);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Pair<Long, Long> zzfg() {
        zzx.zzbe((String)"getMinMaxHitTimes may not be called from the main thread");
        Pair pair = Pair.create((Object)0L, (Object)0L);
        SQLiteDatabase sQLiteDatabase = this.zzar("Error opening database for getMinMaxHitTimes.");
        if (sQLiteDatabase == null) {
            return pair;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(zzET, null);
            if (cursor.moveToFirst()) {
                pair = Pair.create((Object)cursor.getLong(1), (Object)cursor.getLong(2));
            }
        }
        return pair;
    }

    @Override
    public void dispatch() {
        int n;
        zzae.zzab("Dispatch running...");
        if (!this.zzEV.zzfk()) {
            return;
        }
        List<zzab> list = this.zzN(20);
        if (list.isEmpty()) {
            zzae.zzab("...nothing to dispatch");
            this.zzCb.zzD(true);
            return;
        }
        if (this.zzEX == null) {
            this.zzEX = new zzaf("_t=dispatch&_v=ma4.0.6", false);
        }
        boolean bl = (n = this.zzgA()) <= list.size();
        int n2 = this.zzEV.zza(list, this.zzEX, bl);
        zzae.zzab("sent " + n2 + " of " + list.size() + " hits");
        this.zzb(list.subList(0, Math.min(n2, list.size())));
        if (n2 == list.size() && this.zzgA() > 0) {
            GoogleAnalytics.getInstance(this.mContext).dispatchLocalHits();
        } else {
            this.zzEX = null;
        }
    }

    @Override
    public zzr zzff() {
        return this.zzEV;
    }

    private synchronized SQLiteDatabase zzar(String string) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.zzEU.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            zzae.zzac(string);
            return null;
        }
        return sQLiteDatabase;
    }

    class zza
    extends SQLiteOpenHelper {
        private boolean zzFa;
        private long zzFb;

        zza(Context context, String string) {
            super(context, string, null, 1);
            this.zzFb = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(String string, SQLiteDatabase sQLiteDatabase) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.zzFa && this.zzFb + 3600000L > zzag.this.zzmW.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase sQLiteDatabase = null;
            this.zzFa = true;
            this.zzFb = zzag.this.zzmW.currentTimeMillis();
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zzag.this.mContext.getDatabasePath(zzag.this.zzEW).delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            this.zzFa = false;
            return sQLiteDatabase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = db.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.zza("hits2", db)) {
                db.execSQL(zzES);
            } else {
                this.zza(db);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zza(SQLiteDatabase sQLiteDatabase) {
            boolean bl;
            HashSet<String> hashSet = new HashSet<String>();
            try (Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM hits2 WHERE 0", null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            if (!(hashSet.remove("hit_id") && hashSet.remove("hit_url") && hashSet.remove("hit_string") && hashSet.remove("hit_time"))) {
                throw new SQLiteException("Database column missing");
            }
            boolean bl2 = bl = !hashSet.remove("hit_app_id");
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
            if (bl) {
                sQLiteDatabase.execSQL("ALTER TABLE hits2 ADD COLUMN hit_app_id");
            }
        }

        public void onCreate(SQLiteDatabase db) {
            zzt.zzam(db.getPath());
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }
}

