/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.analytics.zzae;
import com.google.android.gms.analytics.zzan;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.analytics.zzq;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzra;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

class zza
implements zzq {
    private final zzra zzAM;
    private final zzk zzAN;
    private AdvertisingIdClient.Info zzAO;
    private long zzAP;
    private String zzAQ;
    private boolean zzAR = false;
    private Object zzAS = new Object();

    @Override
    public String getValue(String field) {
        long l = System.currentTimeMillis();
        if (Math.abs(l - this.zzAP) > 1000L) {
            AdvertisingIdClient.Info info = this.zzeZ();
            this.zzAO = this.zza(this.zzAO, info) ? info : new AdvertisingIdClient.Info("", false);
            this.zzAP = l;
        }
        if (this.zzAO != null) {
            if ("&adid".equals(field)) {
                return this.zzAO.getId();
            }
            if ("&ate".equals(field)) {
                return this.zzAO.isLimitAdTrackingEnabled() ? "0" : "1";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string;
        String string2 = string = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string3 = this.zzAN.getValue("&cid");
        Object object = this.zzAS;
        synchronized (object) {
            String string4;
            if (!this.zzAR) {
                this.zzAQ = zza.zzB(this.zzAM.getContext());
                this.zzAR = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzAQ)) {
                String string5 = string4 = info == null ? null : info.getId();
                if (string4 == null) {
                    return this.zzai(string + string3);
                }
                this.zzAQ = zza.zzah(string4 + string3);
            }
            string4 = zza.zzah(string + string3);
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            if (string4.equals(this.zzAQ)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzAQ)) {
                zzae.zzab("Resetting the client id because Advertising Id changed.");
                string3 = this.zzAN.zzfw();
                zzae.zzab("New client Id: " + string3);
            }
            return this.zzai(string + string3);
        }
    }

    zza(zzra zzra2, zzk zzk2) {
        zzx.zzl((Object)zzra2);
        zzx.zzl((Object)zzk2);
        this.zzAM = zzra2;
        this.zzAN = zzk2;
    }

    AdvertisingIdClient.Info zzeZ() {
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo(this.zzAM.getContext());
        }
        catch (IllegalStateException illegalStateException) {
            zzae.zzac("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            zzae.zzac("GooglePlayServicesRepairableException getting Ad Id Info");
        }
        catch (IOException iOException) {
            zzae.zzac("IOException getting Ad Id Info");
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            zzae.zzac("GooglePlayServicesNotAvailableException getting Ad Id Info");
        }
        catch (Throwable throwable) {
            zzae.zzac("Unknown exception. Could not get the ad Id.");
        }
        return info;
    }

    static String zzah(String string) {
        MessageDigest messageDigest = zzan.zzav("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    private boolean zzai(String string) {
        try {
            String string2 = zza.zzah(string);
            zzae.zzab("Storing hashed adid.");
            Context context = this.zzAM.getContext();
            FileOutputStream fileOutputStream = context.openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            this.zzAQ = string2;
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzae.zzZ("Error creating hash file.");
            return false;
        }
        catch (IOException iOException) {
            zzae.zzZ("Error writing to hash file.");
            return false;
        }
    }

    static String zzB(Context context) {
        String string = null;
        try {
            FileInputStream fileInputStream = context.openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                zzae.zzac("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientIdData");
            } else if (n <= 0) {
                zzae.zzaa("Hash file is empty.");
                fileInputStream.close();
            } else {
                string = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            zzae.zzac("Error reading Hash file, deleting it.");
            context.deleteFile("gaClientIdData");
        }
        return string;
    }
}

