/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.TrackerHandler;
import com.google.android.gms.analytics.zzad;
import com.google.android.gms.analytics.zzae;
import com.google.android.gms.analytics.zzah;
import com.google.android.gms.analytics.zzai;
import com.google.android.gms.analytics.zzam;
import com.google.android.gms.analytics.zzan;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.analytics.zzy;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlv;
import com.google.android.gms.internal.zzlx;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker {
    private final GoogleAnalytics zzBN;
    private final TrackerHandler zzFe;
    private final Map<String, String> zzsZ = new HashMap<String, String>();
    private final Map<String, String> zzFf = new HashMap<String, String>();
    private final zzah zzFg;
    private final zza zzFh;
    private ExceptionReporter zzFi;
    private zzam zzFj;

    Tracker(GoogleAnalytics googleAnalytics, String trackingId, TrackerHandler handler, zzah rateLimiter) {
        zzx.zzl((Object)googleAnalytics);
        this.zzBN = googleAnalytics;
        this.zzFe = handler == null ? googleAnalytics : handler;
        if (trackingId != null) {
            this.zzsZ.put("&tid", trackingId);
        }
        this.zzsZ.put("useSecure", "1");
        this.zzsZ.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzFg = rateLimiter == null ? new zzad("tracking") : rateLimiter;
        this.zzFh = new zza();
        this.enableAdvertisingIdCollection(false);
    }

    void zza(zzam zzam2) {
        String string;
        zzae.zzab("Loading Tracker config values.");
        this.zzFj = zzam2;
        if (this.zzFj.zzgK()) {
            string = this.zzFj.zzgL();
            this.set("&tid", string);
            zzae.zzab("[Tracker] trackingId loaded: " + string);
        }
        if (this.zzFj.zzgM()) {
            string = Double.toString(this.zzFj.zzgN());
            this.set("&sf", string);
            zzae.zzab("[Tracker] sample frequency loaded: " + string);
        }
        if (this.zzFj.zzgO()) {
            this.setSessionTimeout(this.zzFj.getSessionTimeout());
            zzae.zzab("[Tracker] session timeout loaded: " + this.zzgE());
        }
        if (this.zzFj.zzgP()) {
            this.enableAutoActivityTracking(this.zzFj.zzgQ());
            zzae.zzab("[Tracker] auto activity tracking loaded: " + this.zzgF());
        }
        if (this.zzFj.zzgR()) {
            if (this.zzFj.zzgS()) {
                this.set("&aip", "1");
                zzae.zzab("[Tracker] anonymize ip loaded: true");
            }
            zzae.zzab("[Tracker] anonymize ip loaded: false");
        }
        this.enableExceptionReporting(this.zzFj.zzgT());
    }

    private boolean zzgD() {
        return this.zzFi != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean enable) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzgD() == enable) {
                return;
            }
            if (enable) {
                Context context = this.zzBN.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzFi = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzFi);
                zzae.zzab("Uncaught exceptions will be reported to Google Analytics.");
            } else {
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.zzFi.zzfD();
                Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
                zzae.zzab("Uncaught exceptions will not be reported to Google Analytics.");
            }
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.zzFh.setSessionTimeout(sessionTimeout * 1000L);
    }

    long zzgE() {
        return this.zzFh.zzgE();
    }

    public void enableAutoActivityTracking(boolean enabled) {
        this.zzFh.enableAutoActivityTracking(enabled);
    }

    boolean zzgF() {
        return this.zzFh.zzgF();
    }

    public void send(Map<String, String> params) {
        zzy.zzfV().zza(zzy.zza.zzDg);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.zzsZ);
        if (params != null) {
            hashMap.putAll(params);
        }
        Object object = this.zzFf.keySet().iterator();
        while (object.hasNext()) {
            String string = object.next();
            if (hashMap.containsKey(string)) continue;
            hashMap.put(string, this.zzFf.get(string));
        }
        this.zzFf.clear();
        if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&tid")))) {
            zzae.zzac(String.format("Missing tracking id (%s) parameter.", "&tid"));
        }
        if (TextUtils.isEmpty((CharSequence)(object = (String)hashMap.get("&t")))) {
            zzae.zzac(String.format("Missing hit type (%s) parameter.", "&t"));
            object = "";
        }
        if (this.zzFh.zzgG()) {
            hashMap.put("&sc", "start");
        }
        if ("screenview".equals(object = ((String)object).toLowerCase()) || "pageview".equals(object) || "appview".equals(object) || TextUtils.isEmpty((CharSequence)object)) {
            int n = Integer.parseInt(this.zzsZ.get("&a"));
            n = ++n >= Integer.MAX_VALUE ? 1 : n;
            this.zzsZ.put("&a", Integer.toString(n));
        }
        if (!(((String)object).equals("transaction") || ((String)object).equals("item") || this.zzFg.zzgv())) {
            zzae.zzac("Too many hits sent too quickly, rate limiting invoked.");
        } else {
            this.zzFe.zzx(hashMap);
        }
    }

    public String get(String key) {
        zzy.zzfV().zza(zzy.zza.zzDe);
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.zzsZ.containsKey(key)) {
            return this.zzsZ.get(key);
        }
        if (key.equals("&ul")) {
            return zzan.zza(Locale.getDefault());
        }
        zzk zzk2 = this.zzBN.zzgp();
        if (zzk2.zzaj(key)) {
            return zzk2.getValue(key);
        }
        zzai zzai2 = this.zzBN.zzgn();
        if (zzai2.zzaj(key)) {
            return zzai2.getValue(key);
        }
        zzg zzg2 = this.zzBN.zzgo();
        if (zzg2.zzaj(key)) {
            return zzg2.getValue(key);
        }
        return null;
    }

    public void set(String key, String value) {
        zzx.zzb((Object)key, (Object)"Key should be non-null");
        zzy.zzfV().zza(zzy.zza.zzDf);
        this.zzsZ.put(key, value);
    }

    public void setSampleRate(double sampleRate) {
        this.set("&sf", Double.toString(sampleRate));
    }

    public void setUseSecure(boolean useSecure) {
        this.set("useSecure", zzan.zzG(useSecure));
    }

    public void setScreenName(String screenName) {
        this.set("&cd", screenName);
    }

    public void setLocation(String location) {
        this.set("&dl", location);
    }

    public void setReferrer(String referrer) {
        this.set("&dr", referrer);
    }

    public void setPage(String page) {
        this.set("&dp", page);
    }

    public void setHostname(String hostname) {
        this.set("&dh", hostname);
    }

    public void setTitle(String title) {
        this.set("&dt", title);
    }

    public void setLanguage(String language) {
        this.set("&ul", language);
    }

    public void setEncoding(String encoding) {
        this.set("&de", encoding);
    }

    public void setScreenColors(String screenColors) {
        this.set("&sd", screenColors);
    }

    public void setScreenResolution(int width, int height) {
        if (width < 0 && height < 0) {
            zzae.zzac("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", width + "x" + height);
    }

    public void setViewportSize(String viewportSize) {
        this.set("&vp", viewportSize);
    }

    public void setClientId(String clientId) {
        this.set("&cid", clientId);
    }

    public void setAppName(String appName) {
        this.set("&an", appName);
    }

    public void setAppId(String appId) {
        this.set("&aid", appId);
    }

    public void setAppInstallerId(String appInstallerId) {
        this.set("&aiid", appInstallerId);
    }

    public void setAppVersion(String appVersion) {
        this.set("&av", appVersion);
    }

    public void setAnonymizeIp(boolean anonymize) {
        this.set("&aip", zzan.zzG(anonymize));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        Uri uri2 = Uri.parse((String)("http://hostname/?" + string));
        String string2 = uri2.getQueryParameter("utm_id");
        if (string2 != null) {
            this.zzFf.put("&ci", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzFf.put("&cn", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzFf.put("&cc", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzFf.put("&cm", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzFf.put("&cs", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzFf.put("&ck", string2);
        }
        if ((string2 = uri2.getQueryParameter("dclid")) != null) {
            this.zzFf.put("&dclid", string2);
        }
        if ((string2 = uri2.getQueryParameter("gclid")) != null) {
            this.zzFf.put("&gclid", string2);
        }
    }

    public void enableAdvertisingIdCollection(boolean enabled) {
        if (!enabled) {
            this.zzsZ.put("&ate", null);
            this.zzsZ.put("&adid", null);
        } else {
            if (this.zzsZ.containsKey("&ate")) {
                this.zzsZ.remove("&ate");
            }
            if (this.zzsZ.containsKey("&adid")) {
                this.zzsZ.remove("&adid");
            }
        }
    }

    static String zzp(Activity activity) {
        zzx.zzl((Object)activity);
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return string;
    }

    private class zza
    implements GoogleAnalytics.zza {
        private boolean zzFk;
        private int zzFl;
        private long zzFm = -1L;
        private boolean zzFn;
        private long zzFo;
        private zzlv zzmW = zzlx.zzkc();

        public void setSessionTimeout(long sessionTimeout) {
            this.zzFm = sessionTimeout;
            this.zzgH();
        }

        public long zzgE() {
            return this.zzFm;
        }

        public void enableAutoActivityTracking(boolean enabled) {
            this.zzFk = enabled;
            this.zzgH();
        }

        public boolean zzgF() {
            return this.zzFk;
        }

        public boolean zzgG() {
            boolean bl = this.zzFn;
            this.zzFn = false;
            return bl;
        }

        private void zzgH() {
            if (this.zzFm >= 0L || this.zzFk) {
                Tracker.this.zzBN.zza(Tracker.this.zzFh);
            } else {
                Tracker.this.zzBN.zzb(Tracker.this.zzFh);
            }
        }

        @Override
        public void zzn(Activity activity) {
            zzy.zzfV().zza(zzy.zza.zzEd);
            if (this.zzFl == 0 && this.zzgI()) {
                this.zzFn = true;
            }
            ++this.zzFl;
            if (this.zzFk) {
                String string;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    Tracker.this.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                zzy.zzfV().zzF(true);
                Tracker.this.set("&cd", Tracker.this.zzFj != null ? Tracker.this.zzFj.zzq(activity) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr"))) && !TextUtils.isEmpty((CharSequence)(string = Tracker.zzp(activity)))) {
                    hashMap.put("&dr", string);
                }
                Tracker.this.send(hashMap);
                zzy.zzfV().zzF(false);
            }
        }

        @Override
        public void zzo(Activity activity) {
            zzy.zzfV().zza(zzy.zza.zzEe);
            --this.zzFl;
            this.zzFl = Math.max(0, this.zzFl);
            if (this.zzFl == 0) {
                this.zzFo = this.zzmW.elapsedRealtime();
            }
        }

        boolean zzgI() {
            return this.zzmW.elapsedRealtime() >= this.zzFo + Math.max(1000L, this.zzFm);
        }
    }
}

