/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.zzae;
import com.google.android.gms.analytics.zzan;
import com.google.android.gms.analytics.zzs;
import com.google.android.gms.analytics.zzy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HitBuilders {

    public static class ScreenViewBuilder
    extends HitBuilder<ScreenViewBuilder> {
        public ScreenViewBuilder() {
            zzy.zzfV().zza(zzy.zza.zzEf);
            this.set("&t", "screenview");
        }
    }

    @Deprecated
    public static class AppViewBuilder
    extends HitBuilder<AppViewBuilder> {
        public AppViewBuilder() {
            zzy.zzfV().zza(zzy.zza.zzEf);
            this.set("&t", "screenview");
        }
    }

    @Deprecated
    public static class ItemBuilder
    extends HitBuilder<ItemBuilder> {
        public ItemBuilder() {
            zzy.zzfV().zza(zzy.zza.zzDU);
            this.set("&t", "item");
        }

        public ItemBuilder setTransactionId(String transactionid) {
            this.set("&ti", transactionid);
            return this;
        }

        public ItemBuilder setName(String name) {
            this.set("&in", name);
            return this;
        }

        public ItemBuilder setSku(String sku) {
            this.set("&ic", sku);
            return this;
        }

        public ItemBuilder setCategory(String category) {
            this.set("&iv", category);
            return this;
        }

        public ItemBuilder setPrice(double price) {
            this.set("&ip", Double.toString(price));
            return this;
        }

        public ItemBuilder setQuantity(long quantity) {
            this.set("&iq", Long.toString(quantity));
            return this;
        }

        public ItemBuilder setCurrencyCode(String currencyCode) {
            this.set("&cu", currencyCode);
            return this;
        }
    }

    @Deprecated
    public static class TransactionBuilder
    extends HitBuilder<TransactionBuilder> {
        public TransactionBuilder() {
            zzy.zzfV().zza(zzy.zza.zzDB);
            this.set("&t", "transaction");
        }

        public TransactionBuilder setTransactionId(String transactionid) {
            this.set("&ti", transactionid);
            return this;
        }

        public TransactionBuilder setAffiliation(String affiliation) {
            this.set("&ta", affiliation);
            return this;
        }

        public TransactionBuilder setRevenue(double revenue) {
            this.set("&tr", Double.toString(revenue));
            return this;
        }

        public TransactionBuilder setTax(double tax) {
            this.set("&tt", Double.toString(tax));
            return this;
        }

        public TransactionBuilder setShipping(double shipping) {
            this.set("&ts", Double.toString(shipping));
            return this;
        }

        public TransactionBuilder setCurrencyCode(String currencyCode) {
            this.set("&cu", currencyCode);
            return this;
        }
    }

    public static class ExceptionBuilder
    extends HitBuilder<ExceptionBuilder> {
        public ExceptionBuilder() {
            zzy.zzfV().zza(zzy.zza.zzDC);
            this.set("&t", "exception");
        }

        public ExceptionBuilder setDescription(String description) {
            this.set("&exd", description);
            return this;
        }

        public ExceptionBuilder setFatal(boolean fatal) {
            this.set("&exf", zzan.zzG(fatal));
            return this;
        }
    }

    public static class TimingBuilder
    extends HitBuilder<TimingBuilder> {
        public TimingBuilder() {
            zzy.zzfV().zza(zzy.zza.zzDE);
            this.set("&t", "timing");
        }

        public TimingBuilder(String category, String variable, long value) {
            this();
            this.setVariable(variable);
            this.setValue(value);
            this.setCategory(category);
        }

        public TimingBuilder setVariable(String variable) {
            this.set("&utv", variable);
            return this;
        }

        public TimingBuilder setValue(long value) {
            this.set("&utt", Long.toString(value));
            return this;
        }

        public TimingBuilder setCategory(String category) {
            this.set("&utc", category);
            return this;
        }

        public TimingBuilder setLabel(String label) {
            this.set("&utl", label);
            return this;
        }
    }

    public static class SocialBuilder
    extends HitBuilder<SocialBuilder> {
        public SocialBuilder() {
            zzy.zzfV().zza(zzy.zza.zzDF);
            this.set("&t", "social");
        }

        public SocialBuilder setNetwork(String network) {
            this.set("&sn", network);
            return this;
        }

        public SocialBuilder setAction(String action) {
            this.set("&sa", action);
            return this;
        }

        public SocialBuilder setTarget(String target) {
            this.set("&st", target);
            return this;
        }
    }

    public static class EventBuilder
    extends HitBuilder<EventBuilder> {
        public EventBuilder() {
            zzy.zzfV().zza(zzy.zza.zzDT);
            this.set("&t", "event");
        }

        public EventBuilder(String category, String action) {
            this();
            this.setCategory(category);
            this.setAction(action);
        }

        public EventBuilder setCategory(String category) {
            this.set("&ec", category);
            return this;
        }

        public EventBuilder setAction(String action) {
            this.set("&ea", action);
            return this;
        }

        public EventBuilder setLabel(String label) {
            this.set("&el", label);
            return this;
        }

        public EventBuilder setValue(long value) {
            this.set("&ev", Long.toString(value));
            return this;
        }
    }

    protected static class HitBuilder<T extends HitBuilder> {
        private Map<String, String> zzED = new HashMap<String, String>();
        ProductAction zzEE;
        Map<String, List<Product>> zzEF = new HashMap<String, List<Product>>();
        List<Promotion> zzEG = new ArrayList<Promotion>();
        List<Product> zzEH = new ArrayList<Product>();

        protected HitBuilder() {
        }

        public T setNewSession() {
            this.set("&sc", "start");
            return (T)this;
        }

        public T setNonInteraction(boolean nonInteraction) {
            this.set("&ni", zzan.zzG(nonInteraction));
            return (T)this;
        }

        public T setCampaignParamsFromUrl(String utmParams) {
            zzy.zzfV().zza(zzy.zza.zzCY);
            String string = zzan.zzau(utmParams);
            if (TextUtils.isEmpty((CharSequence)string)) {
                return (T)this;
            }
            Map<String, String> map = zzan.zzat(string);
            this.set("&cc", map.get("utm_content"));
            this.set("&cm", map.get("utm_medium"));
            this.set("&cn", map.get("utm_campaign"));
            this.set("&cs", map.get("utm_source"));
            this.set("&ck", map.get("utm_term"));
            this.set("&ci", map.get("utm_id"));
            this.set("&gclid", map.get("gclid"));
            this.set("&dclid", map.get("dclid"));
            this.set("&gmob_t", map.get("gmob_t"));
            return (T)this;
        }

        public T setCustomDimension(int index, String dimension) {
            this.set(zzs.zzE(index), dimension);
            return (T)this;
        }

        public T setCustomMetric(int index, float metric) {
            this.set(zzs.zzF(index), Float.toString(metric));
            return (T)this;
        }

        public final T set(String paramName, String paramValue) {
            zzy.zzfV().zza(zzy.zza.zzCV);
            if (paramName != null) {
                this.zzED.put(paramName, paramValue);
            } else {
                zzae.zzac(" HitBuilder.set() called with a null paramName.");
            }
            return (T)this;
        }

        public final T setAll(Map<String, String> params) {
            zzy.zzfV().zza(zzy.zza.zzCW);
            if (params == null) {
                return (T)this;
            }
            this.zzED.putAll(new HashMap<String, String>(params));
            return (T)this;
        }

        public Map<String, String> build() {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.zzED);
            if (this.zzEE != null) {
                hashMap.putAll(this.zzEE.build());
            }
            int n = 1;
            for (Promotion object : this.zzEG) {
                hashMap.putAll(object.zzaw(zzs.zzH(n)));
                ++n;
            }
            n = 1;
            for (Product product : this.zzEH) {
                hashMap.putAll(product.zzaw(zzs.zzG(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry entry : this.zzEF.entrySet()) {
                List list = (List)entry.getValue();
                String string = zzs.zzJ(n);
                int n2 = 1;
                for (Product product : list) {
                    hashMap.putAll(product.zzaw(string + zzs.zzI(n2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)((CharSequence)entry.getKey()))) {
                    hashMap.put(string + "nm", (String)entry.getKey());
                }
                ++n;
            }
            return hashMap;
        }

        public T setProductAction(ProductAction action) {
            this.zzEE = action;
            return (T)this;
        }

        public T addImpression(Product product, String impressionList) {
            if (product == null) {
                zzae.zzac("product should be non-null");
                return (T)this;
            }
            if (impressionList == null) {
                impressionList = "";
            }
            if (!this.zzEF.containsKey(impressionList)) {
                this.zzEF.put(impressionList, new ArrayList());
            }
            this.zzEF.get(impressionList).add(product);
            return (T)this;
        }

        public T addPromotion(Promotion promotion) {
            if (promotion == null) {
                zzae.zzac("promotion should be non-null");
                return (T)this;
            }
            this.zzEG.add(promotion);
            return (T)this;
        }

        public T setPromotionAction(String action) {
            this.zzED.put("&promoa", action);
            return (T)this;
        }

        public T addProduct(Product product) {
            if (product == null) {
                zzae.zzac("product should be non-null");
                return (T)this;
            }
            this.zzEH.add(product);
            return (T)this;
        }

        protected T setHitType(String hitType) {
            this.set("&t", hitType);
            return (T)this;
        }

        protected String get(String paramName) {
            return this.zzED.get(paramName);
        }
    }
}

