/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.TrackerHandler;
import com.google.android.gms.analytics.zzaa;
import com.google.android.gms.analytics.zzae;
import com.google.android.gms.analytics.zzai;
import com.google.android.gms.analytics.zzaj;
import com.google.android.gms.analytics.zzak;
import com.google.android.gms.analytics.zzal;
import com.google.android.gms.analytics.zzam;
import com.google.android.gms.analytics.zzan;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.analytics.zzf;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.analytics.zzv;
import com.google.android.gms.analytics.zzx;
import com.google.android.gms.analytics.zzy;
import com.google.android.gms.analytics.zzz;
import com.google.android.gms.internal.zzra;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class GoogleAnalytics
extends TrackerHandler {
    private static volatile GoogleAnalytics zzEl;
    private static List<Runnable> zzEm;
    private final Context mContext;
    private final zzra zzAM;
    private final zzy zzEn;
    private final zzf zzBS;
    private final zzaj zzEo;
    private final zzai zzEp;
    private final zzg zzEq;
    private final zzk zzAN;
    private final com.google.android.gms.analytics.zza zzEr;
    private Set<zza> zzEs;
    private boolean zzEt;
    private boolean zzBs;
    private volatile boolean zzEu;
    private String zzBb;
    private String zzBa;
    private static boolean zzEv;

    protected GoogleAnalytics(Context context, zzf thread, zzaj serviceManager, zzak proxy) {
        com.google.android.gms.common.internal.zzx.zzl((Object)context);
        Context context2 = context.getApplicationContext();
        com.google.android.gms.common.internal.zzx.zzl((Object)context2);
        com.google.android.gms.common.internal.zzx.zzl((Object)serviceManager);
        this.zzEn = zzy.zzfV();
        this.mContext = context2;
        this.zzAM = zzra.zzaf(context2);
        com.google.android.gms.common.internal.zzx.zzl((Object)this.zzAM);
        this.zzEo = serviceManager;
        this.zzBS = thread != null ? thread : new zzx(this, proxy);
        this.zzAN = new zzk(this.zzAM);
        this.zzEq = new zzg(this.zzAM);
        this.zzEp = new zzai(this.zzAM);
        this.zzEr = new com.google.android.gms.analytics.zza(this.zzAM, this.zzAN);
        this.zzEs = new HashSet<zza>();
        this.zzgk();
    }

    protected GoogleAnalytics(Context context) {
        this(context, null, zzv.zzfE(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GoogleAnalytics getInstance(Context context) {
        com.google.android.gms.common.internal.zzx.zzl((Object)context);
        if (zzEl != null) return zzEl;
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzEl != null) return zzEl;
            zzEl = new GoogleAnalytics(context);
            if (zzEm == null) return zzEl;
            for (Runnable runnable : zzEm) {
                runnable.run();
            }
            zzEm = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzEl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GoogleAnalytics zzgj() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return zzEl;
        }
    }

    private void zzgk() {
        zzaa zzaa2;
        int n;
        if (zzEv) {
            return;
        }
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 129);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zzae.zzab("PackageManager doesn't know about package: " + (Object)((Object)nameNotFoundException));
        }
        if (applicationInfo == null) {
            zzae.zzac("Couldn't get ApplicationInfo to load global config.");
            return;
        }
        Bundle bundle = applicationInfo.metaData;
        if (bundle != null && (n = bundle.getInt("com.google.android.gms.analytics.globalConfigResource")) > 0 && (zzaa2 = (zzaa)new zzz(this.mContext).zzD(n)) != null) {
            this.zza(zzaa2);
        }
    }

    void zza(zzaa zzaa2) {
        int n;
        zzae.zzab("Loading global config values.");
        if (zzaa2.zzfZ()) {
            this.zzBa = zzaa2.zzga();
            zzae.zzab("app name loaded: " + this.zzBa);
        }
        if (zzaa2.zzgb()) {
            this.zzBb = zzaa2.zzgc();
            zzae.zzab("app version loaded: " + this.zzBb);
        }
        if (zzaa2.zzgd() && (n = this.zzao(zzaa2.zzge())) >= 0) {
            zzae.zzab("log level loaded: " + n);
            this.getLogger().setLogLevel(n);
        }
        if (zzaa2.zzgf()) {
            this.zzEo.setLocalDispatchPeriod(zzaa2.zzgg());
        }
        if (zzaa2.zzgh()) {
            this.setDryRun(zzaa2.zzgi());
        }
    }

    private int zzao(String string) {
        String string2 = string.toLowerCase();
        if ("verbose".equals(string2)) {
            return 0;
        }
        if ("info".equals(string2)) {
            return 1;
        }
        if ("warning".equals(string2)) {
            return 2;
        }
        if ("error".equals(string2)) {
            return 3;
        }
        return -1;
    }

    public void setDryRun(boolean dryRun) {
        this.zzEn.zza(zzy.zza.zzDX);
        this.zzBs = dryRun;
    }

    public boolean isDryRunEnabled() {
        this.zzEn.zza(zzy.zza.zzDY);
        return this.zzBs;
    }

    public void enableAutoActivityReports(Application application) {
        if (Build.VERSION.SDK_INT >= 14 && !this.zzEt) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb());
            this.zzEt = true;
        }
    }

    public void reportActivityStart(Activity activity) {
        if (!this.zzEt) {
            this.zzl(activity);
        }
    }

    void zzl(Activity activity) {
        for (zza zza2 : this.zzEs) {
            zza2.zzn(activity);
        }
    }

    public void reportActivityStop(Activity activity) {
        if (!this.zzEt) {
            this.zzm(activity);
        }
    }

    void zzm(Activity activity) {
        for (zza zza2 : this.zzEs) {
            zza2.zzo(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(String trackingId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            this.zzEn.zza(zzy.zza.zzDI);
            return this.zza(new Tracker(this, trackingId, null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(int configResId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzam zzam2;
            this.zzEn.zza(zzy.zza.zzDI);
            Tracker tracker = new Tracker(this, null, null, null);
            if (configResId > 0 && (zzam2 = (zzam)new zzal(this.mContext).zzD(configResId)) != null) {
                tracker.zza(zzam2);
            }
            return this.zza(tracker);
        }
    }

    private Tracker zza(Tracker tracker) {
        if (this.zzBa != null) {
            tracker.set("&an", this.zzBa);
        }
        if (this.zzBb != null) {
            tracker.set("&av", this.zzBb);
        }
        return tracker;
    }

    void zza(zza zza2) {
        this.zzEs.add(zza2);
        if (this.mContext instanceof Application) {
            this.enableAutoActivityReports((Application)this.mContext);
        }
    }

    void zzb(zza zza2) {
        this.zzEs.remove(zza2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void zzx(Map<String, String> map) {
        com.google.android.gms.common.internal.zzx.zzl(map);
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzan.zza(map, "&ul", zzan.zza(Locale.getDefault()));
            zzan.zza(map, "&sr", this.zzEp);
            map.put("&_u", this.zzEn.zzfX());
            this.zzEn.zzfW();
            this.zzBS.zzx(map);
        }
    }

    public void setAppOptOut(boolean optOut) {
        this.zzEn.zza(zzy.zza.zzDL);
        this.zzEu = optOut;
        if (this.zzEu) {
            this.zzBS.zzfa();
        }
    }

    public boolean getAppOptOut() {
        this.zzEn.zza(zzy.zza.zzDM);
        return this.zzEu;
    }

    public Logger getLogger() {
        return zzae.getLogger();
    }

    zzd zzgl() {
        return this.zzEo.zzE(this.mContext);
    }

    public void setLogger(Logger logger) {
        this.zzEn.zza(zzy.zza.zzDZ);
        zzae.setLogger(logger);
    }

    public String getClientId() {
        return this.zzAN.getValue("&cid");
    }

    public Context getContext() {
        return this.mContext;
    }

    zzf zzgm() {
        return this.zzBS;
    }

    public zzai zzgn() {
        return this.zzEp;
    }

    public zzg zzgo() {
        return this.zzEq;
    }

    public zzk zzgp() {
        return this.zzAN;
    }

    public com.google.android.gms.analytics.zza zzgq() {
        return this.zzEr;
    }

    @Deprecated
    public void dispatchLocalHits() {
        this.zzEo.dispatchLocalHits();
    }

    @Deprecated
    public void setLocalDispatchPeriod(int dispatchPeriodInSeconds) {
        this.zzEo.setLocalDispatchPeriod(dispatchPeriodInSeconds);
    }

    void zzfj() {
        this.zzBS.zzfj();
    }

    class zzb
    implements Application.ActivityLifecycleCallbacks {
        zzb() {
        }

        public void onActivityStarted(Activity activity) {
            GoogleAnalytics.this.zzl(activity);
        }

        public void onActivityStopped(Activity activity) {
            GoogleAnalytics.this.zzm(activity);
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }
    }

    static interface zza {
        public void zzn(Activity var1);

        public void zzo(Activity var1);
    }
}

