/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.zzae;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zzBK;
    private final Tracker zzBL;
    private final Context mContext;
    private ExceptionParser zzBM;
    private GoogleAnalytics zzBN;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler originalHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zzBK = originalHandler;
        this.zzBL = tracker;
        this.zzBM = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        zzae.zzab("ExceptionReporter created, original handler is " + (originalHandler == null ? "null" : originalHandler.getClass().getName()));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzBM;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzBM = exceptionParser;
    }

    GoogleAnalytics zzfC() {
        if (this.zzBN == null) {
            this.zzBN = GoogleAnalytics.getInstance(this.mContext);
        }
        return this.zzBN;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Object object;
        String string = "UncaughtException";
        if (this.zzBM != null) {
            object = t != null ? t.getName() : null;
            string = this.zzBM.getDescription((String)object, e);
        }
        zzae.zzab("Tracking Exception: " + string);
        this.zzBL.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        object = this.zzfC();
        ((GoogleAnalytics)object).dispatchLocalHits();
        ((GoogleAnalytics)object).zzfj();
        if (this.zzBK != null) {
            zzae.zzab("Passing exception to original handler.");
            this.zzBK.uncaughtException(t, e);
        }
    }

    Thread.UncaughtExceptionHandler zzfD() {
        return this.zzBK;
    }
}

