/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlo;
import com.google.android.gms.internal.zzs;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AdvertisingIdClient {
    com.google.android.gms.common.zza zzln;
    zzs zzlo;
    boolean zzlp;
    Object zzlq = new Object();
    zza zzlr;
    private final Context mContext;
    final long zzls;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L);
    }

    public AdvertisingIdClient(Context context, long timeoutInMillis) {
        zzx.zzl((Object)context);
        this.mContext = context;
        this.zzlp = false;
        this.zzls = timeoutInMillis;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.zzb(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzb(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzx.zzbe((String)"Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzlp) {
                this.finish();
            }
            this.zzln = AdvertisingIdClient.zzh(this.mContext);
            this.zzlo = AdvertisingIdClient.zza(this.mContext, this.zzln);
            this.zzlp = true;
            if (bl) {
                this.zzZ();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzZ() {
        Object object = this.zzlq;
        synchronized (object) {
            if (this.zzlr != null) {
                this.zzlr.cancel();
                try {
                    this.zzlr.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.zzls > 0L) {
                this.zzlr = new zza(this, this.zzls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        zzx.zzbe((String)"Calling this from your main thread can lead to deadlock");
        Info info = null;
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzlp) {
                Object object = this.zzlq;
                synchronized (object) {
                    if (this.zzlr == null || !this.zzlr.zzaa()) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.zzb(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzlp) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzx.zzl((Object)this.zzln);
            zzx.zzl((Object)this.zzlo);
            try {
                info = new Info(this.zzlo.getId(), this.zzlo.zzc(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzZ();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzx.zzbe((String)"Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzln == null) {
                return;
            }
            try {
                if (this.zzlp) {
                    com.google.android.gms.internal.zzlo.zzka().zza(this.mContext, (ServiceConnection)this.zzln);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)illegalArgumentException);
            }
            this.zzlp = false;
            this.zzlo = null;
            this.zzln = null;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    static com.google.android.gms.common.zza zzh(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        PackageManager packageManager;
        try {
            packageManager = context.getPackageManager();
            packageManager.getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        try {
            GooglePlayServicesUtil.zzI((Context)context);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new IOException(googlePlayServicesNotAvailableException);
        }
        packageManager = new com.google.android.gms.common.zza();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        if (com.google.android.gms.internal.zzlo.zzka().zza(context, intent, (ServiceConnection)packageManager, 1)) {
            return packageManager;
        }
        throw new IOException("Connection failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context, -1L);
        try {
            advertisingIdClient.zzb(false);
            Info info = advertisingIdClient.getInfo();
            return info;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    static zzs zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzs.zza.zzb(zza2.zzhJ());
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
    }

    public static final class Info {
        private final String zzlx;
        private final boolean zzly;

        public Info(String advertisingId, boolean limitAdTrackingEnabled) {
            this.zzlx = advertisingId;
            this.zzly = limitAdTrackingEnabled;
        }

        public String getId() {
            return this.zzlx;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.zzly;
        }

        public String toString() {
            return "{" + this.zzlx + "}" + this.zzly;
        }
    }

    static class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzlt;
        private long zzlu;
        CountDownLatch zzlv;
        boolean zzlw;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzlt = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzlu = l;
            this.zzlv = new CountDownLatch(1);
            this.zzlw = false;
            this.start();
        }

        public void cancel() {
            this.zzlv.countDown();
        }

        public boolean zzaa() {
            return this.zzlw;
        }

        private void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzlt.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzlw = true;
            }
        }

        @Override
        public void run() {
            try {
                if (!this.zzlv.await(this.zzlu, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
            }
        }
    }
}

