/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.aa;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.m;
import com.google.android.gms.maps.model.n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
implements SafeParcelable {
    public static final m CREATOR = new m();
    private final int CK;
    private final List<LatLng> amx;
    private final List<List<LatLng>> amy;
    private float alU = 10.0f;
    private int alV = -16777216;
    private int alW = 0;
    private float alX = 0.0f;
    private boolean alY = true;
    private boolean amz = false;

    public PolygonOptions() {
        this.CK = 1;
        this.amx = new ArrayList<LatLng>();
        this.amy = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.CK = versionCode;
        this.amx = points;
        this.amy = holes;
        this.alU = strokeWidth;
        this.alV = strokeColor;
        this.alW = fillColor;
        this.alX = zIndex;
        this.alY = visible;
        this.amz = geodesic;
    }

    int getVersionCode() {
        return this.CK;
    }

    List of() {
        return this.amy;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (aa.ob()) {
            n.a(this, out, flags);
        } else {
            m.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.amx.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.amx.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.amx.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.amy.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.alU = width;
        return this;
    }

    public PolygonOptions strokeColor(int color2) {
        this.alV = color2;
        return this;
    }

    public PolygonOptions fillColor(int color2) {
        this.alW = color2;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.alX = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.alY = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.amz = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.amx;
    }

    public List<List<LatLng>> getHoles() {
        return this.amy;
    }

    public float getStrokeWidth() {
        return this.alU;
    }

    public int getStrokeColor() {
        return this.alV;
    }

    public int getFillColor() {
        return this.alW;
    }

    public float getZIndex() {
        return this.alX;
    }

    public boolean isVisible() {
        return this.alY;
    }

    public boolean isGeodesic() {
        return this.amz;
    }
}

