/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;

public interface ICameraUpdateFactoryDelegate
extends IInterface {
    public d zoomIn() throws RemoteException;

    public d zoomOut() throws RemoteException;

    public d scrollBy(float var1, float var2) throws RemoteException;

    public d zoomTo(float var1) throws RemoteException;

    public d zoomBy(float var1) throws RemoteException;

    public d zoomByWithFocus(float var1, int var2, int var3) throws RemoteException;

    public d newCameraPosition(CameraPosition var1) throws RemoteException;

    public d newLatLng(LatLng var1) throws RemoteException;

    public d newLatLngZoom(LatLng var1, float var2) throws RemoteException;

    public d newLatLngBounds(LatLngBounds var1, int var2) throws RemoteException;

    public d newLatLngBoundsWithSize(LatLngBounds var1, int var2, int var3, int var4) throws RemoteException;

    public static abstract class com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate$a
    extends Binder
    implements ICameraUpdateFactoryDelegate {
        public static ICameraUpdateFactoryDelegate aQ(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
            if (iInterface != null && iInterface instanceof ICameraUpdateFactoryDelegate) {
                return (ICameraUpdateFactoryDelegate)iInterface;
            }
            return new a(iBinder);
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    return true;
                }
                case 1: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    d d2 = this.zoomIn();
                    reply.writeNoException();
                    reply.writeStrongBinder(d2 != null ? d2.asBinder() : null);
                    return true;
                }
                case 2: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    d d3 = this.zoomOut();
                    reply.writeNoException();
                    reply.writeStrongBinder(d3 != null ? d3.asBinder() : null);
                    return true;
                }
                case 3: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f2 = data.readFloat();
                    float f3 = data.readFloat();
                    d d4 = this.scrollBy(f2, f3);
                    reply.writeNoException();
                    reply.writeStrongBinder(d4 != null ? d4.asBinder() : null);
                    return true;
                }
                case 4: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f4 = data.readFloat();
                    d d5 = this.zoomTo(f4);
                    reply.writeNoException();
                    reply.writeStrongBinder(d5 != null ? d5.asBinder() : null);
                    return true;
                }
                case 5: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f5 = data.readFloat();
                    d d6 = this.zoomBy(f5);
                    reply.writeNoException();
                    reply.writeStrongBinder(d6 != null ? d6.asBinder() : null);
                    return true;
                }
                case 6: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f6 = data.readFloat();
                    int n2 = data.readInt();
                    int n3 = data.readInt();
                    d d7 = this.zoomByWithFocus(f6, n2, n3);
                    reply.writeNoException();
                    reply.writeStrongBinder(d7 != null ? d7.asBinder() : null);
                    return true;
                }
                case 7: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    CameraPosition cameraPosition = 0 != data.readInt() ? CameraPosition.CREATOR.da(data) : null;
                    d d8 = this.newCameraPosition(cameraPosition);
                    reply.writeNoException();
                    reply.writeStrongBinder(d8 != null ? d8.asBinder() : null);
                    return true;
                }
                case 8: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLng latLng = 0 != data.readInt() ? LatLng.CREATOR.de(data) : null;
                    d d9 = this.newLatLng(latLng);
                    reply.writeNoException();
                    reply.writeStrongBinder(d9 != null ? d9.asBinder() : null);
                    return true;
                }
                case 9: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLng latLng = 0 != data.readInt() ? LatLng.CREATOR.de(data) : null;
                    float f7 = data.readFloat();
                    d d10 = this.newLatLngZoom(latLng, f7);
                    reply.writeNoException();
                    reply.writeStrongBinder(d10 != null ? d10.asBinder() : null);
                    return true;
                }
                case 10: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLngBounds latLngBounds = 0 != data.readInt() ? LatLngBounds.CREATOR.dd(data) : null;
                    int n4 = data.readInt();
                    d d11 = this.newLatLngBounds(latLngBounds, n4);
                    reply.writeNoException();
                    reply.writeStrongBinder(d11 != null ? d11.asBinder() : null);
                    return true;
                }
                case 11: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLngBounds latLngBounds = 0 != data.readInt() ? LatLngBounds.CREATOR.dd(data) : null;
                    int n5 = data.readInt();
                    int n6 = data.readInt();
                    int n7 = data.readInt();
                    d d12 = this.newLatLngBoundsWithSize(latLngBounds, n5, n6, n7);
                    reply.writeNoException();
                    reply.writeStrongBinder(d12 != null ? d12.asBinder() : null);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class a
        implements ICameraUpdateFactoryDelegate {
            private IBinder le;

            a(IBinder iBinder) {
                this.le = iBinder;
            }

            public IBinder asBinder() {
                return this.le;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public d zoomIn() throws RemoteException {
                d d2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    this.le.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    d2 = d.a.ap(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return d2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public d zoomOut() throws RemoteException {
                d d2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    this.le.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    d2 = d.a.ap(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return d2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public d scrollBy(float xPixel, float yPixel) throws RemoteException {
                d d2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(xPixel);
                    parcel.writeFloat(yPixel);
                    this.le.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    d2 = d.a.ap(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return d2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public d zoomTo(float zoom) throws RemoteException {
                d d2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(zoom);
                    this.le.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    d2 = d.a.ap(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return d2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public d zoomBy(float amount) throws RemoteException {
                d d2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(amount);
                    this.le.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    d2 = d.a.ap(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return d2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public d zoomByWithFocus(float amount, int screenFocusX, int screenFocusY) throws RemoteException {
                d d2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(amount);
                    parcel.writeInt(screenFocusX);
                    parcel.writeInt(screenFocusY);
                    this.le.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    d2 = d.a.ap(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return d2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public d newCameraPosition(CameraPosition cameraPosition) throws RemoteException {
                d d2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (cameraPosition != null) {
                        parcel.writeInt(1);
                        cameraPosition.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.le.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    d2 = d.a.ap(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return d2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public d newLatLng(LatLng latLng) throws RemoteException {
                d d2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (latLng != null) {
                        parcel.writeInt(1);
                        latLng.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.le.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    d2 = d.a.ap(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return d2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public d newLatLngZoom(LatLng latLng, float zoom) throws RemoteException {
                d d2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (latLng != null) {
                        parcel.writeInt(1);
                        latLng.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeFloat(zoom);
                    this.le.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    d2 = d.a.ap(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return d2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public d newLatLngBounds(LatLngBounds bounds, int padding) throws RemoteException {
                d d2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (bounds != null) {
                        parcel.writeInt(1);
                        bounds.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(padding);
                    this.le.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    d2 = d.a.ap(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return d2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public d newLatLngBoundsWithSize(LatLngBounds bounds, int width, int height, int padding) throws RemoteException {
                d d2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (bounds != null) {
                        parcel.writeInt(1);
                        bounds.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(width);
                    parcel.writeInt(height);
                    parcel.writeInt(padding);
                    this.le.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    d2 = d.a.ap(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return d2;
            }
        }
    }
}

