/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Point;
import android.os.RemoteException;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.dynamic.e;
import com.google.android.gms.internal.jx;
import com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.internal.s;
import com.google.android.gms.maps.internal.t;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.StreetViewPanoramaCamera;
import com.google.android.gms.maps.model.StreetViewPanoramaLocation;
import com.google.android.gms.maps.model.StreetViewPanoramaOrientation;

public class StreetViewPanorama {
    private final IStreetViewPanoramaDelegate alg;

    protected StreetViewPanorama(IStreetViewPanoramaDelegate sv) {
        this.alg = jx.i(sv);
    }

    IStreetViewPanoramaDelegate nQ() {
        return this.alg;
    }

    public boolean isZoomGesturesEnabled() {
        try {
            return this.alg.isZoomGesturesEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setZoomGesturesEnabled(boolean enableZoom) {
        try {
            this.alg.enableZoom(enableZoom);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public boolean isPanningGesturesEnabled() {
        try {
            return this.alg.isPanningGesturesEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setPanningGesturesEnabled(boolean enablePanning) {
        try {
            this.alg.enablePanning(enablePanning);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public boolean isUserNavigationEnabled() {
        try {
            return this.alg.isUserNavigationEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setUserNavigationEnabled(boolean enableUserNavigation) {
        try {
            this.alg.enableUserNavigation(enableUserNavigation);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public boolean isStreetNamesEnabled() {
        try {
            return this.alg.isStreetNamesEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setStreetNamesEnabled(boolean enableStreetNames) {
        try {
            this.alg.enableStreetNames(enableStreetNames);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void animateTo(StreetViewPanoramaCamera camera, long duration) {
        try {
            this.alg.animateTo(camera, duration);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public StreetViewPanoramaCamera getPanoramaCamera() {
        try {
            return this.alg.getPanoramaCamera();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setPosition(String panoId) {
        try {
            this.alg.setPositionWithID(panoId);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setPosition(LatLng position) {
        try {
            this.alg.setPosition(position);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setPosition(LatLng position, int radius) {
        try {
            this.alg.setPositionWithRadius(position, radius);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public StreetViewPanoramaLocation getLocation() {
        try {
            return this.alg.getStreetViewPanoramaLocation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public StreetViewPanoramaOrientation pointToOrientation(Point point) {
        try {
            return this.alg.pointToOrientation(e.k(point));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public Point orientationToPoint(StreetViewPanoramaOrientation orientation) {
        try {
            d d2 = this.alg.orientationToPoint(orientation);
            if (d2 == null) {
                return null;
            }
            return (Point)e.f(d2);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnStreetViewPanoramaChangeListener(final OnStreetViewPanoramaChangeListener listener) {
        try {
            if (listener == null) {
                this.alg.setOnStreetViewPanoramaChangeListener(null);
            } else {
                this.alg.setOnStreetViewPanoramaChangeListener(new s.a(){

                    @Override
                    public void onStreetViewPanoramaChange(StreetViewPanoramaLocation location) {
                        listener.onStreetViewPanoramaChange(location);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnStreetViewPanoramaCameraChangeListener(final OnStreetViewPanoramaCameraChangeListener listener) {
        try {
            if (listener == null) {
                this.alg.setOnStreetViewPanoramaCameraChangeListener(null);
            } else {
                this.alg.setOnStreetViewPanoramaCameraChangeListener(new r.a(){

                    @Override
                    public void onStreetViewPanoramaCameraChange(StreetViewPanoramaCamera camera) {
                        listener.onStreetViewPanoramaCameraChange(camera);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnStreetViewPanoramaClickListener(final OnStreetViewPanoramaClickListener listener) {
        try {
            if (listener == null) {
                this.alg.setOnStreetViewPanoramaClickListener(null);
            } else {
                this.alg.setOnStreetViewPanoramaClickListener(new t.a(){

                    @Override
                    public void onStreetViewPanoramaClick(StreetViewPanoramaOrientation orientation) {
                        listener.onStreetViewPanoramaClick(orientation);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static interface OnStreetViewPanoramaClickListener {
        public void onStreetViewPanoramaClick(StreetViewPanoramaOrientation var1);
    }

    public static interface OnStreetViewPanoramaCameraChangeListener {
        public void onStreetViewPanoramaCameraChange(StreetViewPanoramaCamera var1);
    }

    public static interface OnStreetViewPanoramaChangeListener {
        public void onStreetViewPanoramaChange(StreetViewPanoramaLocation var1);
    }
}

