/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.jv;
import com.google.android.gms.location.d;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int CK;
    int mPriority;
    long agr;
    long ags;
    boolean Wg;
    long age;
    int agt;
    float agu;
    long agv;
    public static final d CREATOR = new d();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.CK = 1;
        this.mPriority = 102;
        this.agr = 3600000L;
        this.ags = 600000L;
        this.Wg = false;
        this.age = Long.MAX_VALUE;
        this.agt = Integer.MAX_VALUE;
        this.agu = 0.0f;
        this.agv = 0L;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.ey(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.v(millis);
        this.agr = millis;
        if (!this.Wg) {
            this.ags = (long)((double)this.agr / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.agr;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.v(millis);
        this.Wg = true;
        this.ags = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.ags;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.age = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.age < 0L) {
            this.age = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.age = millis;
        if (this.age < 0L) {
            this.age = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.age;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.agt = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.agt;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.agu = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.agu;
    }

    private static void v(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void ey(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement, long maxWaitTime) {
        this.CK = versionCode;
        this.mPriority = priority;
        this.agr = interval;
        this.ags = fastestInterval;
        this.Wg = explicitFastestInterval;
        this.age = expireAt;
        this.agt = numUpdates;
        this.agu = smallestDisplacement;
        this.agv = maxWaitTime;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        d.a(this, parcel, flags);
    }

    public static String ez(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.ez(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.agr + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.ags + "ms");
        if (this.age != Long.MAX_VALUE) {
            long l2 = this.age - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.agt != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.agt);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return jv.hashCode(this.mPriority, this.agr, this.ags, this.Wg, this.age, this.agt, Float.valueOf(this.agu));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.agr == locationRequest.agr && this.ags == locationRequest.ags && this.Wg == locationRequest.Wg && this.age == locationRequest.age && this.agt == locationRequest.agt && this.agu == locationRequest.agu;
    }

    int getVersionCode() {
        return this.CK;
    }
}

