/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import com.google.android.gms.internal.nn;
import com.google.android.gms.location.Geofence;
import java.util.ArrayList;
import java.util.List;

public class GeofencingEvent {
    private final int tq;
    private final int agl;
    private final List<Geofence> agm;
    private final Location agn;

    private GeofencingEvent(int errorCode, int transitionType, List<Geofence> triggeringGeofences, Location triggeringLocaton) {
        this.tq = errorCode;
        this.agl = transitionType;
        this.agm = triggeringGeofences;
        this.agn = triggeringLocaton;
    }

    public static GeofencingEvent fromIntent(Intent intent) {
        if (intent == null) {
            return null;
        }
        int n2 = intent.getIntExtra("gms_error_code", -1);
        int n3 = GeofencingEvent.k(intent);
        List<Geofence> list = GeofencingEvent.l(intent);
        Location location = (Location)intent.getParcelableExtra("com.google.android.location.intent.extra.triggering_location");
        return new GeofencingEvent(n2, n3, list, location);
    }

    private static int k(Intent intent) {
        int n2 = intent.getIntExtra("com.google.android.location.intent.extra.transition", -1);
        if (n2 == -1) {
            return -1;
        }
        if (n2 == 1 || n2 == 2 || n2 == 4) {
            return n2;
        }
        return -1;
    }

    private static List<Geofence> l(Intent intent) {
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra("com.google.android.location.intent.extra.geofence_list");
        if (arrayList == null) {
            return null;
        }
        ArrayList<Geofence> arrayList2 = new ArrayList<Geofence>(arrayList.size());
        for (byte[] byArray : arrayList) {
            arrayList2.add(nn.h(byArray));
        }
        return arrayList2;
    }

    public boolean hasError() {
        return this.tq != -1;
    }

    public int getErrorCode() {
        return this.tq;
    }

    public int getGeofenceTransition() {
        return this.agl;
    }

    public List<Geofence> getTriggeringGeofences() {
        return this.agm;
    }

    public Location getTriggeringLocation() {
        return this.agn;
    }
}

