/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource TN;
    private final DataType TM;
    private final long UQ;
    private final long Wa;
    private final long VZ;
    private final int UR;
    private final LocationRequest We;
    private final long Wf;

    private SensorRequest(Builder builder) {
        this.TN = builder.TN;
        this.TM = builder.TM;
        this.UQ = builder.UQ;
        this.Wa = builder.Wa;
        this.VZ = builder.VZ;
        this.UR = builder.UR;
        this.We = null;
        this.Wf = builder.Wf;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.We = locationRequest;
        this.UQ = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.Wa = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.VZ = this.UQ;
        this.TM = dataSource.getDataType();
        this.UR = SensorRequest.a(locationRequest);
        this.TN = dataSource;
        long l2 = locationRequest.getExpirationTime();
        this.Wf = l2 == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l2 - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int a(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.TN;
    }

    public DataType getDataType() {
        return this.TM;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.UQ, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.Wa, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.VZ, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.UR;
    }

    public long kh() {
        return this.Wf;
    }

    public String toString() {
        return jv.h(this).a("dataSource", this.TN).a("dataType", this.TM).a("samplingRateMicros", this.UQ).a("deliveryLatencyMicros", this.VZ).a("timeOutMicros", this.Wf).toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRequest && this.a((SensorRequest)that);
    }

    private boolean a(SensorRequest sensorRequest) {
        return jv.equal(this.TN, sensorRequest.TN) && jv.equal(this.TM, sensorRequest.TM) && this.UQ == sensorRequest.UQ && this.Wa == sensorRequest.Wa && this.VZ == sensorRequest.VZ && this.UR == sensorRequest.UR && jv.equal(this.We, sensorRequest.We) && this.Wf == sensorRequest.Wf;
    }

    public int hashCode() {
        return jv.hashCode(this.TN, this.TM, this.UQ, this.Wa, this.VZ, this.UR, this.We, this.Wf);
    }

    public static int dl(int n2) {
        switch (n2) {
            case 1: 
            case 3: {
                return n2;
            }
        }
        return 2;
    }

    public static class Builder {
        private DataSource TN;
        private DataType TM;
        private long UQ = -1L;
        private long Wa = 0L;
        private long VZ = 0L;
        private boolean Wg = false;
        private int UR = 2;
        private long Wf = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.TN = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.TM = dataType;
            return this;
        }

        public Builder setSamplingRate(long interval, TimeUnit unit) {
            jx.b(interval >= 0L, (Object)"Cannot use a negative sampling interval");
            this.UQ = unit.toMicros(interval);
            if (!this.Wg) {
                this.Wa = this.UQ / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int fastestInterval, TimeUnit unit) {
            jx.b(fastestInterval >= 0, (Object)"Cannot use a negative interval");
            this.Wg = true;
            this.Wa = unit.toMicros(fastestInterval);
            return this;
        }

        public Builder setMaxDeliveryLatency(int interval, TimeUnit unit) {
            jx.b(interval >= 0, (Object)"Cannot use a negative delivery interval");
            this.VZ = unit.toMicros(interval);
            return this;
        }

        public Builder setAccuracyMode(int accuracyMode) {
            this.UR = SensorRequest.dl(accuracyMode);
            return this;
        }

        public Builder setTimeout(long timeout, TimeUnit timeUnit) {
            jx.b(timeout > 0L, "Invalid time out value specified: %d", timeout);
            jx.b(timeUnit != null, (Object)"Invalid time unit specified");
            this.Wf = timeUnit.toMicros(timeout);
            return this;
        }

        public SensorRequest build() {
            jx.a(this.TN != null || this.TM != null, "Must call setDataSource() or setDataType()");
            jx.a(this.TM == null || this.TN == null || this.TM.equals(this.TN.getDataType()), "Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

