/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.DataReadResult;
import com.google.android.gms.internal.jx;
import java.util.concurrent.TimeUnit;

public interface HistoryApi {
    public PendingResult<DataReadResult> readData(GoogleApiClient var1, DataReadRequest var2);

    public PendingResult<Status> insertData(GoogleApiClient var1, DataSet var2);

    public PendingResult<Status> deleteData(GoogleApiClient var1, DataDeleteRequest var2);

    public static class ViewIntentBuilder {
        private final Context mContext;
        private final DataType TM;
        private DataSource TN;
        private long LW;
        private long TO;
        private String TP;

        public ViewIntentBuilder(Context context, DataType dataType) {
            this.mContext = context;
            this.TM = dataType;
        }

        public ViewIntentBuilder setTimeInterval(long start, long end, TimeUnit timeUnit) {
            this.LW = timeUnit.toMillis(start);
            this.TO = timeUnit.toMillis(end);
            return this;
        }

        public ViewIntentBuilder setDataSource(DataSource dataSource) {
            jx.b(dataSource.getDataType().equals(this.TM), "Data source %s is not for the data type %s", dataSource, this.TM);
            this.TN = dataSource;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String packageName) {
            this.TP = packageName;
            return this;
        }

        public Intent build() {
            jx.a(this.LW > 0L, "Start time must be set");
            jx.a(this.TO > this.LW, "End time must be set and after start time");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(DataType.getMimeType(this.TN.getDataType()));
            intent.putExtra("vnd.google.fitness.start_time", this.LW);
            intent.putExtra("vnd.google.fitness.end_time", this.TO);
            c.a(this.TN, intent, "vnd.google.fitness.data_source");
            return this.i(intent);
        }

        private Intent i(Intent intent) {
            if (this.TP == null) {
                return intent;
            }
            Intent intent2 = new Intent(intent).setPackage(this.TP);
            ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent2, 0);
            if (resolveInfo != null) {
                String string2 = resolveInfo.activityInfo.name;
                intent2.setComponent(new ComponentName(this.TP, string2));
                return intent2;
            }
            return intent;
        }
    }
}

