/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.zza;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzei;
import com.google.android.gms.internal.zzek;
import com.google.android.gms.internal.zzgd;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.json.JSONObject;

@zzgd
public final class zzej
extends zzeg.zza {
    private final MediationAdapter zzyf;

    public zzej(MediationAdapter mediationAdapter) {
        this.zzyf = mediationAdapter;
    }

    @Override
    public zzd getView() throws RemoteException {
        if (!(this.zzyf instanceof MediationBannerAdapter)) {
            zzb.zzaC("MediationAdapter is not a MediationBannerAdapter: " + this.zzyf.getClass().getCanonicalName());
            throw new RemoteException();
        }
        try {
            MediationBannerAdapter mediationBannerAdapter = (MediationBannerAdapter)this.zzyf;
            return zze.zzw((Object)mediationBannerAdapter.getBannerView());
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not get banner view from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void zza(zzd zzd2, AdSizeParcel adSizeParcel, AdRequestParcel adRequestParcel, String string2, zzeh zzeh2) throws RemoteException {
        this.zza(zzd2, adSizeParcel, adRequestParcel, string2, null, zzeh2);
    }

    @Override
    public void zza(zzd zzd2, AdSizeParcel adSizeParcel, AdRequestParcel adRequestParcel, String string2, String string3, zzeh zzeh2) throws RemoteException {
        if (!(this.zzyf instanceof MediationBannerAdapter)) {
            zzb.zzaC("MediationAdapter is not a MediationBannerAdapter: " + this.zzyf.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzb.zzay("Requesting banner ad from adapter.");
        try {
            MediationBannerAdapter mediationBannerAdapter = (MediationBannerAdapter)this.zzyf;
            HashSet<String> hashSet = adRequestParcel.zzrZ != null ? new HashSet<String>(adRequestParcel.zzrZ) : null;
            zzei zzei2 = new zzei(adRequestParcel.zzrX == -1L ? null : new Date(adRequestParcel.zzrX), adRequestParcel.zzrY, hashSet, adRequestParcel.zzsf, adRequestParcel.zzsa, adRequestParcel.zzsb);
            Bundle bundle = adRequestParcel.zzsh != null ? adRequestParcel.zzsh.getBundle(mediationBannerAdapter.getClass().getName()) : null;
            mediationBannerAdapter.requestBannerAd((Context)zze.zzn((zzd)zzd2), new zzek(zzeh2), this.zza(string2, adRequestParcel.zzsb, string3), zza.zza(adSizeParcel.width, adSizeParcel.height, adSizeParcel.zzsm), zzei2, bundle);
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not request banner ad from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void zza(zzd zzd2, AdRequestParcel adRequestParcel, String string2, zzeh zzeh2) throws RemoteException {
        this.zza(zzd2, adRequestParcel, string2, null, zzeh2);
    }

    @Override
    public void zza(zzd zzd2, AdRequestParcel adRequestParcel, String string2, String string3, zzeh zzeh2) throws RemoteException {
        if (!(this.zzyf instanceof MediationInterstitialAdapter)) {
            zzb.zzaC("MediationAdapter is not a MediationInterstitialAdapter: " + this.zzyf.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzb.zzay("Requesting interstitial ad from adapter.");
        try {
            MediationInterstitialAdapter mediationInterstitialAdapter = (MediationInterstitialAdapter)this.zzyf;
            HashSet<String> hashSet = adRequestParcel.zzrZ != null ? new HashSet<String>(adRequestParcel.zzrZ) : null;
            zzei zzei2 = new zzei(adRequestParcel.zzrX == -1L ? null : new Date(adRequestParcel.zzrX), adRequestParcel.zzrY, hashSet, adRequestParcel.zzsf, adRequestParcel.zzsa, adRequestParcel.zzsb);
            Bundle bundle = adRequestParcel.zzsh != null ? adRequestParcel.zzsh.getBundle(mediationInterstitialAdapter.getClass().getName()) : null;
            mediationInterstitialAdapter.requestInterstitialAd((Context)zze.zzn((zzd)zzd2), new zzek(zzeh2), this.zza(string2, adRequestParcel.zzsb, string3), zzei2, bundle);
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not request interstitial ad from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void zza(zzd zzd2, AdRequestParcel adRequestParcel, String string2, com.google.android.gms.ads.internal.reward.mediation.client.zza zza2, String string3) throws RemoteException {
        if (!(this.zzyf instanceof MediationRewardedVideoAdAdapter)) {
            zzb.zzaC("MediationAdapter is not a MediationRewardedVideoAdAdapter: " + this.zzyf.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzb.zzay("Initialize rewarded video adapter.");
        try {
            MediationRewardedVideoAdAdapter mediationRewardedVideoAdAdapter = (MediationRewardedVideoAdAdapter)this.zzyf;
            HashSet<String> hashSet = adRequestParcel.zzrZ != null ? new HashSet<String>(adRequestParcel.zzrZ) : null;
            zzei zzei2 = new zzei(adRequestParcel.zzrX == -1L ? null : new Date(adRequestParcel.zzrX), adRequestParcel.zzrY, hashSet, adRequestParcel.zzsf, adRequestParcel.zzsa, adRequestParcel.zzsb);
            Bundle bundle = adRequestParcel.zzsh != null ? adRequestParcel.zzsh.getBundle(mediationRewardedVideoAdAdapter.getClass().getName()) : null;
            mediationRewardedVideoAdAdapter.initialize((Context)zze.zzn((zzd)zzd2), zzei2, string2, new com.google.android.gms.ads.internal.reward.mediation.client.zzb(zza2), this.zza(string3, adRequestParcel.zzsb, null), bundle);
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not initialize rewarded video adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void zza(AdRequestParcel adRequestParcel, String string2) throws RemoteException {
        if (!(this.zzyf instanceof MediationRewardedVideoAdAdapter)) {
            zzb.zzaC("MediationAdapter is not a MediationRewardedVideoAdAdapter: " + this.zzyf.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzb.zzay("Requesting rewarded video ad from adapter.");
        try {
            MediationRewardedVideoAdAdapter mediationRewardedVideoAdAdapter = (MediationRewardedVideoAdAdapter)this.zzyf;
            HashSet<String> hashSet = adRequestParcel.zzrZ != null ? new HashSet<String>(adRequestParcel.zzrZ) : null;
            zzei zzei2 = new zzei(adRequestParcel.zzrX == -1L ? null : new Date(adRequestParcel.zzrX), adRequestParcel.zzrY, hashSet, adRequestParcel.zzsf, adRequestParcel.zzsa, adRequestParcel.zzsb);
            Bundle bundle = adRequestParcel.zzsh != null ? adRequestParcel.zzsh.getBundle(mediationRewardedVideoAdAdapter.getClass().getName()) : null;
            mediationRewardedVideoAdAdapter.loadAd(zzei2, this.zza(string2, adRequestParcel.zzsb, null), bundle);
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not load rewarded video ad from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void showVideo() throws RemoteException {
        if (!(this.zzyf instanceof MediationRewardedVideoAdAdapter)) {
            zzb.zzaC("MediationAdapter is not a MediationRewardedVideoAdAdapter: " + this.zzyf.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzb.zzay("Show rewarded video ad from adapter.");
        try {
            MediationRewardedVideoAdAdapter mediationRewardedVideoAdAdapter = (MediationRewardedVideoAdAdapter)this.zzyf;
            mediationRewardedVideoAdAdapter.showVideo();
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not show rewarded video ad from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public boolean isInitialized() throws RemoteException {
        if (!(this.zzyf instanceof MediationRewardedVideoAdAdapter)) {
            zzb.zzaC("MediationAdapter is not a MediationRewardedVideoAdAdapter: " + this.zzyf.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzb.zzay("Check if adapter is initialized.");
        try {
            MediationRewardedVideoAdAdapter mediationRewardedVideoAdAdapter = (MediationRewardedVideoAdAdapter)this.zzyf;
            return mediationRewardedVideoAdAdapter.isInitialized();
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not check if adapter is initialized.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void showInterstitial() throws RemoteException {
        if (!(this.zzyf instanceof MediationInterstitialAdapter)) {
            zzb.zzaC("MediationAdapter is not a MediationInterstitialAdapter: " + this.zzyf.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzb.zzay("Showing interstitial from adapter.");
        try {
            MediationInterstitialAdapter mediationInterstitialAdapter = (MediationInterstitialAdapter)this.zzyf;
            mediationInterstitialAdapter.showInterstitial();
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not show interstitial from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void destroy() throws RemoteException {
        try {
            this.zzyf.onDestroy();
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not destroy adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void pause() throws RemoteException {
        try {
            this.zzyf.onPause();
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not pause adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void resume() throws RemoteException {
        try {
            this.zzyf.onResume();
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not resume adapter.", throwable);
            throw new RemoteException();
        }
    }

    private Bundle zza(String string2, int n, String string3) throws RemoteException {
        zzb.zzaC("Server parameters: " + string2);
        try {
            Bundle bundle = new Bundle();
            if (string2 != null) {
                JSONObject jSONObject = new JSONObject(string2);
                bundle = new Bundle();
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    bundle.putString(string4, jSONObject.getString(string4));
                }
            }
            if (this.zzyf instanceof AdMobAdapter) {
                bundle.putString("adJson", string3);
                bundle.putInt("tagForChildDirectedTreatment", n);
            }
            return bundle;
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not get Server Parameters Bundle.", throwable);
            throw new RemoteException();
        }
    }
}

