/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzr;
import com.google.android.gms.ads.internal.client.zzt;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzl;
import com.google.android.gms.ads.internal.zzn;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzay;
import com.google.android.gms.internal.zzaz;
import com.google.android.gms.internal.zzbh;
import com.google.android.gms.internal.zzbk;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzcd;
import com.google.android.gms.internal.zzce;
import com.google.android.gms.internal.zzci;
import com.google.android.gms.internal.zzde;
import com.google.android.gms.internal.zzff;
import com.google.android.gms.internal.zzfj;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhe;
import com.google.android.gms.internal.zzhf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

@zzgd
public abstract class zza
extends zzr.zza
implements com.google.android.gms.ads.internal.client.zza,
zzk,
zza.zza,
zzaw,
zzde,
zzft.zza,
zzhe {
    private zzce zzoj;
    private zzcd zzok;
    private zzcd zzol;
    protected final zzn zzom;
    protected final zzp zzon;
    protected transient AdRequestParcel zzoo;
    protected final zzay zzop;

    zza(zzp zzp2, zzn zzn2) {
        this.zzon = zzp2;
        this.zzom = zzn2 != null ? zzn2 : new zzn(this);
        zzo.zzbv().zzH(this.zzon.zzpH);
        zzo.zzby().zzb(this.zzon.zzpH, this.zzon.zzpJ);
        this.zzop = zzo.zzby().zzgd();
    }

    void zzaL() {
        this.zzoj = new zzce("load_ad");
        this.zzok = new zzcd(-1L, null, null);
        this.zzol = new zzcd(-1L, null, null);
    }

    @Override
    public void destroy() {
        com.google.android.gms.common.internal.zzu.zzbY((String)"destroy must be called on the main UI thread.");
        this.zzom.cancel();
        this.zzop.zzh(this.zzon.zzpO);
        this.zzon.destroy();
    }

    @Override
    public zzd zzaM() {
        com.google.android.gms.common.internal.zzu.zzbY((String)"getAdFrame must be called on the main UI thread.");
        return zze.zzw((Object)((Object)this.zzon.zzpK));
    }

    @Override
    public AdSizeParcel zzaN() {
        com.google.android.gms.common.internal.zzu.zzbY((String)"getAdSize must be called on the main UI thread.");
        return this.zzon.zzpN;
    }

    @Override
    public boolean isReady() {
        com.google.android.gms.common.internal.zzu.zzbY((String)"isLoaded must be called on the main UI thread.");
        return this.zzon.zzpL == null && this.zzon.zzpM == null && this.zzon.zzpO != null;
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel) {
        com.google.android.gms.common.internal.zzu.zzbY((String)"loadAd must be called on the main UI thread.");
        if (this.zzon.zzpL != null || this.zzon.zzpM != null) {
            if (this.zzoo != null) {
                zzb.zzaC("Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            }
            this.zzoo = adRequestParcel;
            return false;
        }
        zzb.zzaA("Starting ad request.");
        this.zzaL();
        this.zzok = this.zzoj.zzdo();
        if (!adRequestParcel.zzsa) {
            zzb.zzaA("Use AdRequest.Builder.addTestDevice(\"" + com.google.android.gms.ads.internal.client.zzk.zzcA().zzO(this.zzon.zzpH) + "\") to get test ads on this device.");
        }
        return this.zzb(adRequestParcel);
    }

    protected abstract boolean zzb(AdRequestParcel var1);

    @Override
    public void zza(zzha.zza zza2) {
        this.zzoj.zza(this.zzok, "arf");
        this.zzol = this.zzoj.zzdo();
        this.zzon.zzpL = null;
        this.zzon.zzpP = zza2;
        if (this.zzb(zza2)) {
            zzb.zzay("AdRenderer: " + this.zzon.zzpM.getClass().getName());
        }
    }

    protected abstract boolean zzb(zzha.zza var1);

    boolean zza(zzha zzha2) {
        return false;
    }

    @Override
    public void zzb(zzha zzha2) {
        this.zzoj.zza(this.zzol, "awr");
        this.zzoj.zza(this.zzok, "ttc");
        this.zzon.zzpM = null;
        if (zzha2.errorCode != -2 && zzha2.errorCode != 3) {
            zzo.zzby().zzb(this.zzon.zzbI());
        }
        if (zzha2.errorCode == -1) {
            return;
        }
        if (this.zza(zzha2)) {
            zzb.zzay("Ad refresh scheduled.");
        }
        if (zzha2.errorCode != -2) {
            this.zze(zzha2.errorCode);
            return;
        }
        if (this.zzon.zzqf == null) {
            this.zzon.zzqf = new zzhf(this.zzon.zzpG);
        }
        this.zzop.zzg(this.zzon.zzpO);
        if (this.zza(this.zzon.zzpO, zzha2)) {
            this.zzon.zzpO = zzha2;
            this.zzon.zzbO();
            if (zzo.zzby().zzfY() != null) {
                zzo.zzby().zzfY().zza(this.zzoj);
            }
            if (this.zzon.zzbM()) {
                this.zzaT();
            }
        }
    }

    protected abstract boolean zza(zzha var1, zzha var2);

    @Override
    public void onAdClicked() {
        if (this.zzon.zzpO == null) {
            zzb.zzaC("Ad state was null when trying to ping click URLs.");
            return;
        }
        zzb.zzay("Pinging click URLs.");
        this.zzon.zzpQ.zzfQ();
        if (this.zzon.zzpO.zzxF != null) {
            zzo.zzbv().zza(this.zzon.zzpH, this.zzon.zzpJ.zzGG, this.zza(this.zzon.zzpO.zzxF, this.zzon.zzpO.zzCC));
        }
        if (this.zzon.zzpR != null) {
            try {
                this.zzon.zzpR.onAdClicked();
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not notify onAdClicked event.", remoteException);
            }
        }
    }

    @Override
    public void zzaO() {
        this.zzaR();
    }

    @Override
    public void onAppEvent(String name, String info) {
        if (this.zzon.zzpT != null) {
            try {
                this.zzon.zzpT.onAppEvent(name, info);
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not call the AppEventListener.", remoteException);
            }
        }
    }

    @Override
    public void zza(zzaz zzaz2, boolean bl) {
        if (this.zzon.zzpO != null && this.zzon.zzpO.zzzE != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("isVisible", bl ? "1" : "0");
            this.zzon.zzpO.zzzE.zzc("onAdVisibilityChanged", hashMap);
        }
    }

    @Override
    public void zzaP() {
        com.google.android.gms.common.internal.zzu.zzbY((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzon.zzpO == null) {
            zzb.zzaC("Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        zzb.zzay("Pinging manual tracking URLs.");
        if (this.zzon.zzpO.zzCM != null) {
            zzo.zzbv().zza(this.zzon.zzpH, this.zzon.zzpJ.zzGG, this.zzon.zzpO.zzCM);
        }
    }

    @Override
    public void pause() {
        com.google.android.gms.common.internal.zzu.zzbY((String)"pause must be called on the main UI thread.");
    }

    @Override
    public void resume() {
        com.google.android.gms.common.internal.zzu.zzbY((String)"resume must be called on the main UI thread.");
    }

    protected boolean zzc(AdRequestParcel adRequestParcel) {
        ViewParent viewParent = this.zzon.zzpK.getParent();
        return viewParent instanceof View && ((View)viewParent).isShown() && zzo.zzbv().zzgl();
    }

    public void zzd(AdRequestParcel adRequestParcel) {
        if (this.zzc(adRequestParcel)) {
            this.zza(adRequestParcel);
        } else {
            zzb.zzaA("Ad is not visible. Not refreshing ad.");
            this.zzom.zzf(adRequestParcel);
        }
    }

    @Override
    public void zza(com.google.android.gms.ads.internal.client.zzn zzn2) {
        com.google.android.gms.common.internal.zzu.zzbY((String)"setAdListener must be called on the main UI thread.");
        this.zzon.zzpS = zzn2;
    }

    @Override
    public void zza(zzm zzm2) {
        com.google.android.gms.common.internal.zzu.zzbY((String)"setAdListener must be called on the main UI thread.");
        this.zzon.zzpR = zzm2;
    }

    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        com.google.android.gms.common.internal.zzu.zzbY((String)"setAdSize must be called on the main UI thread.");
        this.zzon.zzpN = adSizeParcel;
        if (this.zzon.zzpO != null && this.zzon.zzqh == 0) {
            this.zzon.zzpO.zzzE.zza(adSizeParcel);
        }
        if (this.zzon.zzpK == null) {
            return;
        }
        if (this.zzon.zzpK.getChildCount() > 1) {
            this.zzon.zzpK.removeView(this.zzon.zzpK.getNextView());
        }
        this.zzon.zzpK.setMinimumWidth(adSizeParcel.widthPixels);
        this.zzon.zzpK.setMinimumHeight(adSizeParcel.heightPixels);
        this.zzon.zzpK.requestLayout();
    }

    @Override
    public void zza(zzt zzt2) {
        com.google.android.gms.common.internal.zzu.zzbY((String)"setAppEventListener must be called on the main UI thread.");
        this.zzon.zzpT = zzt2;
    }

    @Override
    public void zza(zzff zzff2) {
        throw new IllegalStateException("setInAppPurchaseListener is not supported for current ad type");
    }

    @Override
    public void zza(zzci zzci2) {
        throw new IllegalStateException("setOnCustomRenderedAdLoadedListener is not supported for current ad type");
    }

    @Override
    public void zza(zzfj zzfj2, String string) {
        throw new IllegalStateException("setPlayStorePurchaseParams is not supported for current ad type");
    }

    @Override
    public void zza(zzu zzu2) {
        com.google.android.gms.common.internal.zzu.zzbY((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzon.zzpU = zzu2;
    }

    @Override
    public void stopLoading() {
        com.google.android.gms.common.internal.zzu.zzbY((String)"stopLoading must be called on the main UI thread.");
        this.zzon.zzf(true);
    }

    Bundle zza(zzbk zzbk2) {
        if (zzbk2 == null) {
            return null;
        }
        if (zzbk2.zzct()) {
            zzbk2.wakeup();
        }
        zzbh zzbh2 = zzbk2.zzcr();
        String string = null;
        if (zzbh2 != null) {
            string = zzbh2.zzci();
            zzb.zzay("In AdManger: loadAd, " + zzbh2.toString());
        }
        if (string != null) {
            Bundle bundle = new Bundle(1);
            bundle.putString("fingerprint", string);
            bundle.putInt("v", 1);
            return bundle;
        }
        return null;
    }

    protected void zzb(View view) {
        this.zzon.zzpK.addView(view, zzo.zzbx().zzgt());
    }

    protected boolean zzaQ() {
        zzb.zzaB("Ad closing.");
        if (this.zzon.zzpS == null) {
            return false;
        }
        try {
            this.zzon.zzpS.onAdClosed();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdClosed().", remoteException);
            return false;
        }
    }

    private boolean zzaR() {
        zzb.zzaA("Ad leaving application.");
        if (this.zzon.zzpS == null) {
            return false;
        }
        try {
            this.zzon.zzpS.onAdLeftApplication();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdLeftApplication().", remoteException);
            return false;
        }
    }

    protected boolean zzaS() {
        zzb.zzaA("Ad opening.");
        if (this.zzon.zzpS == null) {
            return false;
        }
        try {
            this.zzon.zzpS.onAdOpened();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdOpened().", remoteException);
            return false;
        }
    }

    protected boolean zzaT() {
        zzb.zzaA("Ad finished loading.");
        if (this.zzon.zzpS == null) {
            return false;
        }
        try {
            this.zzon.zzpS.onAdLoaded();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdLoaded().", remoteException);
            return false;
        }
    }

    protected boolean zze(int n) {
        zzb.zzaC("Failed to load ad: " + n);
        if (this.zzon.zzpS == null) {
            return false;
        }
        try {
            this.zzon.zzpS.onAdFailedToLoad(n);
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdFailedToLoad().", remoteException);
            return false;
        }
    }

    protected void recordImpression() {
        this.zzc(this.zzon.zzpO);
    }

    protected void zzc(zzha zzha2) {
        if (zzha2 == null) {
            zzb.zzaC("Ad state was null when trying to ping impression URLs.");
            return;
        }
        zzb.zzay("Pinging Impression URLs.");
        this.zzon.zzpQ.zzfP();
        if (zzha2.zzxG != null) {
            zzo.zzbv().zza(this.zzon.zzpH, this.zzon.zzpJ.zzGG, this.zza(zzha2.zzxG, zzha2.zzCC));
        }
    }

    @Override
    public void zza(HashSet<zzhb> hashSet) {
        this.zzon.zza(hashSet);
    }

    String zza(String string, String string2, int n) {
        if (zzbz.zzun.get().booleanValue() && zzl.zzq(this.zzon.zzpH).zzbl() && !TextUtils.isEmpty((CharSequence)string)) {
            return Uri.parse((String)string).buildUpon().appendQueryParameter("ga_cid", string2).appendQueryParameter("ga_hid", String.valueOf(n)).build().toString();
        }
        return string;
    }

    ArrayList<String> zza(List<String> list, String string) {
        int n = zzl.zzq(this.zzon.zzpH).zzbn();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            arrayList.add(this.zza(string2, string, n));
        }
        return arrayList;
    }
}

