/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.internal.zzbs;
import com.google.android.gms.internal.zzcf;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzfa;
import com.google.android.gms.internal.zzfq;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzt;
import com.google.android.gms.internal.zzu;
import com.google.android.gms.internal.zzx;
import com.google.android.gms.internal.zzy;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzeo
public class zzw
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object zzoe = new Object();
    private final WeakReference<zzfa> zzok;
    private WeakReference<ViewTreeObserver> zzol;
    private final WeakReference<View> zzom;
    private final zzu zzon;
    private final Context zzoh;
    private final zzcf zzoo;
    private final zzfx<zzy> zzop;
    private boolean zzoq;
    private final WindowManager zzor;
    private final PowerManager zzos;
    private final KeyguardManager zzot;
    private zzx zzou;
    private boolean zzov;
    private boolean zznE = false;
    private boolean zzow = false;
    private boolean zzox;
    private boolean zzoy;
    private BroadcastReceiver zzoz;
    private final HashSet<zzt> zzoA = new HashSet();
    private zzfq zznk;
    private final zzbs zzoB = new zzbs(){

        @Override
        public void zza(zzgd zzgd2, Map<String, String> map) {
            if (!zzw.this.zza(map)) {
                return;
            }
            zzw.this.zza((View)zzgd2.getWebView(), map);
        }
    };
    private final zzbs zzoC = new zzbs(){

        @Override
        public void zza(zzgd zzgd2, Map<String, String> map) {
            if (!zzw.this.zza(map)) {
                return;
            }
            zzb.zzaj("Received request to untrack: " + zzw.this.zzon.zzbf());
            zzw.this.destroy();
        }
    };
    private final zzbs zzoD = new zzbs(){

        @Override
        public void zza(zzgd zzgd2, Map<String, String> map) {
            if (!zzw.this.zza(map)) {
                return;
            }
            if (!map.containsKey("isVisible")) {
                return;
            }
            Boolean bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
            zzw.this.zzh(bl);
        }
    };

    public zzw(AdSizeParcel adSizeParcel, zzfa zzfa2, VersionInfoParcel versionInfoParcel, View view, zzcf zzcf2) {
        this.zzoo = zzcf2;
        this.zzok = new WeakReference<zzfa>(zzfa2);
        this.zzom = new WeakReference<View>(view);
        this.zzol = new WeakReference<Object>(null);
        this.zzox = true;
        this.zznk = new zzfq(200L);
        this.zzon = new zzu(UUID.randomUUID().toString(), versionInfoParcel, adSizeParcel.zzpX, zzfa2.zzBs, zzfa2.zzbg());
        this.zzop = this.zzoo.zzda();
        this.zzor = (WindowManager)view.getContext().getSystemService("window");
        this.zzos = (PowerManager)view.getContext().getApplicationContext().getSystemService("power");
        this.zzot = (KeyguardManager)view.getContext().getSystemService("keyguard");
        this.zzoh = view.getContext().getApplicationContext();
        try {
            final JSONObject jSONObject = this.zzd(view);
            this.zzop.zza(new zzfx.zzd<zzy>(){

                public void zzc(zzy zzy2) {
                    zzw.this.zza(jSONObject);
                }

                @Override
                public /* synthetic */ void zza(Object object) {
                    this.zzc((zzy)object);
                }
            }, new zzfx.zza(){

                @Override
                public void run() {
                }
            });
        }
        catch (JSONException jSONException) {
        }
        catch (RuntimeException runtimeException) {
            zzb.zzb("Failure while processing active view data.", runtimeException);
        }
        this.zzop.zza(new zzfx.zzd<zzy>(){

            public void zzc(zzy zzy2) {
                zzw.this.zzoq = true;
                zzw.this.zza(zzy2);
                zzw.this.zzbh();
                zzw.this.zzi(false);
            }

            @Override
            public /* synthetic */ void zza(Object object) {
                this.zzc((zzy)object);
            }
        }, new zzfx.zza(){

            @Override
            public void run() {
                zzw.this.destroy();
            }
        });
        zzb.zzaj("Tracking ad unit: " + this.zzon.zzbf());
    }

    public void zza(zzt zzt2) {
        this.zzoA.add(zzt2);
    }

    protected void zzh(boolean bl) {
        for (zzt zzt2 : this.zzoA) {
            zzt2.zza(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzbh() {
        Object object = this.zzoe;
        synchronized (object) {
            if (this.zzoz != null) {
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            this.zzoz = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    zzw.this.zzi(false);
                }
            };
            this.zzoh.registerReceiver(this.zzoz, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzbi() {
        Object object = this.zzoe;
        synchronized (object) {
            if (this.zzoz != null) {
                this.zzoh.unregisterReceiver(this.zzoz);
                this.zzoz = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzbn();
            this.zzbi();
            this.zzox = false;
            this.zzbk();
            this.zzop.zza(new zzfx.zzd<zzy>(){

                public void zzc(zzy zzy2) {
                    zzw.this.zzb(zzy2);
                }

                @Override
                public /* synthetic */ void zza(Object object) {
                    this.zzc((zzy)object);
                }
            }, new zzfx.zzb());
            this.zzoo.zzb(this.zzop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbj() {
        Object object = this.zzoe;
        synchronized (object) {
            if (this.zzox) {
                this.zzoy = true;
                try {
                    JSONObject jSONObject = this.zzbp();
                    this.zza(jSONObject);
                }
                catch (JSONException jSONException) {
                    zzb.zzb("JSON failure while processing active view data.", jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzb.zzb("Failure while processing active view data.", runtimeException);
                }
                zzb.zzaj("Untracking ad unit: " + this.zzon.zzbf());
            }
        }
    }

    protected void zza(View view, Map<String, String> map) {
        this.zzi(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzi(boolean bl) {
        Object object = this.zzoe;
        synchronized (object) {
            boolean bl2;
            if (!this.zzoq || !this.zzox) {
                return;
            }
            if (bl && !this.zznk.tryAcquire()) {
                return;
            }
            zzfa zzfa2 = (zzfa)this.zzok.get();
            View view = (View)this.zzom.get();
            boolean bl3 = bl2 = view == null || zzfa2 == null;
            if (bl2) {
                this.zzbj();
                return;
            }
            try {
                JSONObject jSONObject = this.zzd(view);
                this.zza(jSONObject);
            }
            catch (RuntimeException | JSONException throwable) {
                zzb.zza("Active view update failed.", throwable);
            }
            this.zzbm();
            this.zzbk();
        }
    }

    protected void zzbk() {
        if (this.zzou != null) {
            this.zzou.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzbl() {
        Object object = this.zzoe;
        synchronized (object) {
            return this.zzox;
        }
    }

    protected int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    protected void zzbm() {
        View view = (View)this.zzom.get();
        if (view == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzol.get();
        ViewTreeObserver viewTreeObserver2 = view.getViewTreeObserver();
        if (viewTreeObserver2 == viewTreeObserver) {
            return;
        }
        this.zzbn();
        if (!this.zzov || viewTreeObserver != null && viewTreeObserver.isAlive()) {
            this.zzov = true;
            viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zzol = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
    }

    protected boolean zza(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzon.zzbf());
    }

    protected void zza(zzy zzy2) {
        zzy2.zza("/updateActiveView", this.zzoB);
        zzy2.zza("/untrackActiveViewUnit", this.zzoC);
        zzy2.zza("/visibilityChanged", this.zzoD);
    }

    protected void zzb(zzy zzy2) {
        zzy2.zzb("/visibilityChanged", this.zzoD);
        zzy2.zzb("/untrackActiveViewUnit", this.zzoC);
        zzy2.zzb("/updateActiveView", this.zzoB);
    }

    protected void zzbn() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzol.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected JSONObject zzbo() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zzon.zzbd()).put("activeViewJSON", (Object)this.zzon.zzbe()).put("timestamp", zzh.zzaU().elapsedRealtime()).put("adFormat", (Object)this.zzon.zzbc()).put("hashCode", (Object)this.zzon.zzbf()).put("isMraid", this.zzon.zzbg());
        return jSONObject;
    }

    protected void zza(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = new JSONArray();
            final JSONObject jSONObject2 = new JSONObject();
            jSONArray.put((Object)jSONObject);
            jSONObject2.put("units", (Object)jSONArray);
            this.zzop.zza(new zzfx.zzd<zzy>(){

                public void zzc(zzy zzy2) {
                    zzy2.zza("AFMA_updateActiveView", jSONObject2);
                }

                @Override
                public /* synthetic */ void zza(Object object) {
                    this.zzc((zzy)object);
                }
            }, new zzfx.zza(){

                @Override
                public void run() {
                }
            });
        }
        catch (Throwable throwable) {
            zzb.zzb("Skipping active view message.", throwable);
        }
    }

    protected JSONObject zzd(View view) throws JSONException {
        boolean bl = zzh.zzaS().zzk(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzb.zzb("Failure getting view location.", exception);
        }
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        rect.left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        rect2.right = this.zzor.getDefaultDisplay().getWidth();
        rect2.bottom = this.zzor.getDefaultDisplay().getHeight();
        Rect rect3 = new Rect();
        boolean bl2 = view.getGlobalVisibleRect(rect3, null);
        Rect rect4 = new Rect();
        boolean bl3 = view.getLocalVisibleRect(rect4);
        Rect rect5 = new Rect();
        view.getHitRect(rect5);
        JSONObject jSONObject = this.zzbo();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isStopped", this.zzow).put("isPaused", this.zznE).put("isAttachedToWindow", bl).put("viewBox", (Object)new JSONObject().put("top", this.zza(rect2.top, displayMetrics)).put("bottom", this.zza(rect2.bottom, displayMetrics)).put("left", this.zza(rect2.left, displayMetrics)).put("right", this.zza(rect2.right, displayMetrics))).put("adBox", (Object)new JSONObject().put("top", this.zza(rect.top, displayMetrics)).put("bottom", this.zza(rect.bottom, displayMetrics)).put("left", this.zza(rect.left, displayMetrics)).put("right", this.zza(rect.right, displayMetrics))).put("globalVisibleBox", (Object)new JSONObject().put("top", this.zza(rect3.top, displayMetrics)).put("bottom", this.zza(rect3.bottom, displayMetrics)).put("left", this.zza(rect3.left, displayMetrics)).put("right", this.zza(rect3.right, displayMetrics))).put("globalVisibleBoxVisible", bl2).put("localVisibleBox", (Object)new JSONObject().put("top", this.zza(rect4.top, displayMetrics)).put("bottom", this.zza(rect4.bottom, displayMetrics)).put("left", this.zza(rect4.left, displayMetrics)).put("right", this.zza(rect4.right, displayMetrics))).put("localVisibleBoxVisible", bl3).put("hitBox", (Object)new JSONObject().put("top", this.zza(rect5.top, displayMetrics)).put("bottom", this.zza(rect5.bottom, displayMetrics)).put("left", this.zza(rect5.left, displayMetrics)).put("right", this.zza(rect5.right, displayMetrics))).put("screenDensity", (double)displayMetrics.density).put("isVisible", this.zze(view));
        return jSONObject;
    }

    protected boolean zze(View view) {
        return view.getVisibility() == 0 && view.isShown() && this.isScreenOn() && (!this.zzot.inKeyguardRestrictedInputMode() || zzh.zzaQ().zzeZ());
    }

    boolean isScreenOn() {
        return this.zzos.isScreenOn();
    }

    protected JSONObject zzbp() throws JSONException {
        JSONObject jSONObject = this.zzbo();
        jSONObject.put("doneReasonCode", (Object)"u");
        return jSONObject;
    }

    public void onScrollChanged() {
        this.zzi(true);
    }

    public void onGlobalLayout() {
        this.zzi(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzx zzx2) {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzou = zzx2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzow = true;
            this.zzi(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.zzoe;
        synchronized (object) {
            this.zznE = true;
            this.zzi(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.zzoe;
        synchronized (object) {
            this.zznE = false;
            this.zzi(false);
        }
    }
}

