/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzge;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzic;
import com.google.android.gms.internal.zzk;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzeo
public class zzgg
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzgd {
    private final zzge zzxS;
    private final zza zzDp;
    private final Object zzoe = new Object();
    private final zzk zzsW;
    private final VersionInfoParcel zzoi;
    private zzc zzDq;
    private AdSizeParcel zzuO;
    private boolean zzDr;
    private boolean zzDs;
    private boolean zzDt;
    private boolean zzDu;
    private boolean zzDv;
    private Boolean zzBV;
    private int zzDw;
    private zzc zzDx;
    boolean zzDy;
    private int zzvS = -1;
    private int zzvR = -1;
    private int zzvU = -1;
    private int zzvV = -1;
    private final WindowManager zzor;

    static zzgg zzb(Context context, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzk zzk2, VersionInfoParcel versionInfoParcel) {
        zza zza2 = new zza(context);
        return new zzgg(zza2, adSizeParcel, bl, bl2, zzk2, versionInfoParcel);
    }

    protected zzgg(zza zza2, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzk zzk2, VersionInfoParcel versionInfoParcel) {
        super((Context)zza2);
        this.zzDp = zza2;
        this.zzuO = adSizeParcel;
        this.zzDt = bl;
        this.zzDv = false;
        this.zzDw = -1;
        this.zzsW = zzk2;
        this.zzoi = versionInfoParcel;
        this.zzor = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(0);
        }
        zzh.zzaQ().zza((Context)zza2, versionInfoParcel.zzCI, webSettings);
        zzh.zzaS().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzxS = zzh.zzaS().zzb(this, bl2);
        this.setWebViewClient(this.zzxS);
        this.setWebChromeClient(zzh.zzaS().zze(this));
        this.zzfL();
        if (zzic.zznj()) {
            this.addJavascriptInterface(new zzgh(this), "googleAdsJsInterface");
        }
    }

    @Override
    public WebView getWebView() {
        return this;
    }

    public boolean zzfH() {
        int n;
        int n2;
        if (!this.zzft().zzbg()) {
            return false;
        }
        DisplayMetrics displayMetrics = zzh.zzaQ().zza(this.zzor);
        int n3 = zzj.zzbJ().zzb(displayMetrics, displayMetrics.widthPixels);
        int n4 = zzj.zzbJ().zzb(displayMetrics, displayMetrics.heightPixels);
        Activity activity = this.zzfp();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            int[] nArray = zzh.zzaQ().zzg(activity);
            n2 = zzj.zzbJ().zzb(displayMetrics, nArray[0]);
            n = zzj.zzbJ().zzb(displayMetrics, nArray[1]);
        }
        if (this.zzvR == n3 && this.zzvS == n4 && this.zzvU == n2 && this.zzvV == n) {
            return false;
        }
        boolean bl = this.zzvR != n3 || this.zzvS != n4;
        this.zzvR = n3;
        this.zzvS = n4;
        this.zzvU = n2;
        this.zzvV = n;
        new zzdg(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzor.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public void zzb(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzh.zzaQ().zzx(map);
        }
        catch (JSONException jSONException) {
            zzb.zzan("Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateJavascript(String script, ValueCallback<String> resultCallback) {
        Object object = this.zzoe;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzb.zzan("The webview is destroyed. Ignoring action.");
                if (resultCallback != null) {
                    resultCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(script, resultCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzap(String string2) {
        Object object = this.zzoe;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzb.zzan("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUrl(String uri) {
        Object object = this.zzoe;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadUrl(uri);
            } else {
                zzb.zzan("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzao(String string2) {
        Object object = this.zzoe;
        synchronized (object) {
            super.loadUrl(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(String data, String mimeType, String encoding) {
        Object object = this.zzoe;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(data, mimeType, encoding);
            } else {
                zzb.zzan("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        Object object = this.zzoe;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
            } else {
                zzb.zzan("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zza(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzoe;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.evaluateJavascript(string2, valueCallback);
            } else {
                zzb.zzan("The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
            }
        }
    }

    protected void zzaq(String string2) {
        if (zzic.zznk()) {
            if (this.zzeQ() == null) {
                this.zzfI();
            }
            if (this.zzeQ().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
            } else {
                this.zzap("javascript:" + string2);
            }
        } else {
            this.zzap("javascript:" + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzfI() {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzBV = zzh.zzaT().zzeQ();
            if (this.zzBV == null) {
                try {
                    String string2 = "(function(){})()";
                    this.evaluateJavascript(string2, null);
                    this.zzb(true);
                }
                catch (IllegalStateException illegalStateException) {
                    this.zzb(false);
                }
            }
        }
    }

    void zzb(Boolean bl) {
        this.zzBV = bl;
        zzh.zzaT().zzb(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean zzeQ() {
        Object object = this.zzoe;
        synchronized (object) {
            return this.zzBV;
        }
    }

    @Override
    public void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zzb(string2, string3);
    }

    @Override
    public void zzb(String string2, String string3) {
        String string4 = string2 + "(" + string3 + ");";
        this.zzaq(string4);
    }

    @Override
    public void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        zzb.zzam("Dispatching AFMA event: " + stringBuilder.toString());
        this.zzaq(stringBuilder.toString());
    }

    @Override
    public void zzfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzoi.zzCI);
        this.zzb("onhide", hashMap);
    }

    @Override
    public void zzp(int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzoi.zzCI);
        this.zzb("onhide", hashMap);
    }

    @Override
    public void zzdy() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzoi.zzCI);
        this.zzb("onshow", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzc zzfr() {
        Object object = this.zzoe;
        synchronized (object) {
            return this.zzDq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzc zzfs() {
        Object object = this.zzoe;
        synchronized (object) {
            return this.zzDx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdSizeParcel zzah() {
        Object object = this.zzoe;
        synchronized (object) {
            return this.zzuO;
        }
    }

    @Override
    public zzge zzft() {
        return this.zzxS;
    }

    @Override
    public boolean zzfu() {
        return this.zzDr;
    }

    @Override
    public zzk zzfv() {
        return this.zzsW;
    }

    @Override
    public VersionInfoParcel zzfw() {
        return this.zzoi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzfx() {
        Object object = this.zzoe;
        synchronized (object) {
            return this.zzDt;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            this.getContext().startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzb.zzaj("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.zzsW != null) {
            this.zzsW.zza(event);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.zzoe;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzDt) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            if (this.zzuO.zzpY) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzor.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n2 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n4 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n5 = Integer.MAX_VALUE;
            if (n == Integer.MIN_VALUE || n == 0x40000000) {
                n5 = n2;
            }
            int n6 = Integer.MAX_VALUE;
            if (n3 == Integer.MIN_VALUE || n3 == 0x40000000) {
                n6 = n4;
            }
            if (this.zzuO.widthPixels > n5 || this.zzuO.heightPixels > n6) {
                float f = this.zzDp.getResources().getDisplayMetrics().density;
                zzb.zzan("Not enough space to show ad. Needs " + (int)((float)this.zzuO.widthPixels / f) + "x" + (int)((float)this.zzuO.heightPixels / f) + " dp, but only has " + (int)((float)n2 / f) + "x" + (int)((float)n4 / f) + " dp.");
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzuO.widthPixels, this.zzuO.heightPixels);
            }
        }
    }

    public void onGlobalLayout() {
        boolean bl = this.zzfH();
        zzc zzc2 = this.zzfr();
        if (zzc2 != null && bl) {
            zzc2.zzdx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(Context context, AdSizeParcel adSizeParcel) {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzfJ();
            this.setContext(context);
            this.zzDq = null;
            this.zzuO = adSizeParcel;
            this.zzDt = false;
            this.zzDr = false;
            this.zzDw = -1;
            zzh.zzaS().zzb(this);
            this.loadUrl("about:blank");
            this.zzxS.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzc zzc2) {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzDq = zzc2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(zzc zzc2) {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzDx = zzc2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzuO = adSizeParcel;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzB(boolean bl) {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzDt = bl;
            this.zzfL();
        }
    }

    private void zzfJ() {
        Activity activity = this.zzfp();
        if (this.zzDv && activity != null) {
            zzh.zzaS().zzb(activity, this);
            this.zzDv = false;
        }
    }

    void zzfK() {
        Activity activity = this.zzfp();
        if (!this.zzDv && activity != null && this.zzDy) {
            zzh.zzaQ().zza(activity, this);
            this.zzDv = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzfz() {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzfK();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        Object object = this.zzoe;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzDy = true;
                if (this.zzxS.zzbg()) {
                    this.zzfK();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.zzoe;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzfJ();
                this.zzDy = false;
            }
            super.onDetachedFromWindow();
        }
    }

    @Override
    public void setContext(Context context) {
        this.zzDp.setBaseContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzC(boolean bl) {
        Object object = this.zzoe;
        synchronized (object) {
            if (this.zzDq != null) {
                this.zzDq.zza(this.zzxS.zzbg(), bl);
            } else {
                this.zzDr = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation() {
        Object object = this.zzoe;
        synchronized (object) {
            return this.zzDw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(int requestedOrientation) {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzDw = requestedOrientation;
            if (this.zzDq != null) {
                this.zzDq.setRequestedOrientation(this.zzDw);
            }
        }
    }

    @Override
    public Activity zzfp() {
        return this.zzDp.zzfp();
    }

    @Override
    public Context zzfq() {
        return this.zzDp.zzfq();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzfL() {
        Object object = this.zzoe;
        synchronized (object) {
            if (this.zzDt || this.zzuO.zzpY) {
                if (Build.VERSION.SDK_INT < 14) {
                    zzb.zzaj("Disabling hardware acceleration on an overlay.");
                    this.zzfM();
                } else {
                    zzb.zzaj("Enabling hardware acceleration on an overlay.");
                    this.zzfN();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                zzb.zzaj("Disabling hardware acceleration on an AdView.");
                this.zzfM();
            } else {
                zzb.zzaj("Enabling hardware acceleration on an AdView.");
                this.zzfN();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzfM() {
        Object object = this.zzoe;
        synchronized (object) {
            if (!this.zzDu) {
                zzh.zzaS().zzm((View)this);
            }
            this.zzDu = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzfN() {
        Object object = this.zzoe;
        synchronized (object) {
            if (this.zzDu) {
                zzh.zzaS().zzl((View)this);
            }
            this.zzDu = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzfJ();
            if (this.zzDq != null) {
                this.zzDq.close();
                this.zzDq.onDestroy();
                this.zzDq = null;
            }
            this.zzxS.reset();
            if (this.zzDs) {
                return;
            }
            zzh.zzbb().zza(this);
            this.zzDs = true;
            zzb.zzam("Initiating WebView self destruct sequence in 3...");
            this.zzxS.zzfB();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzfy() {
        Object object = this.zzoe;
        synchronized (object) {
            zzb.zzam("Destroying WebView!");
            super.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.zzoe;
        synchronized (object) {
            return this.zzDs;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
    }

    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onPause();
        }
        catch (Exception exception) {
            zzb.zzb("Could not pause webview.", exception);
        }
    }

    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onResume();
        }
        catch (Exception exception) {
            zzb.zzb("Could not resume webview.", exception);
        }
    }

    @Override
    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
        }
        catch (Exception exception) {
            zzb.zzb("Could not stop loading webview.", exception);
        }
    }

    @zzeo
    public static class zza
    extends MutableContextWrapper {
        private Activity zzDz;
        private Context zzoh;
        private Context zzDA;

        public zza(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context base) {
            this.zzoh = base.getApplicationContext();
            this.zzDz = base instanceof Activity ? (Activity)base : null;
            this.zzDA = base;
            super.setBaseContext(this.zzoh);
        }

        public void startActivity(Intent intent) {
            if (this.zzDz != null && !zzic.zznl()) {
                this.zzDz.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.zzoh.startActivity(intent);
            }
        }

        public Activity zzfp() {
            return this.zzDz;
        }

        public Object getSystemService(String service) {
            return this.zzDA.getSystemService(service);
        }

        public Context zzfq() {
            return this.zzDA;
        }
    }
}

