/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.internal.zzeo;
import java.util.Locale;

@zzeo
public final class zzev {
    public final int zzAY;
    public final boolean zzAZ;
    public final boolean zzBa;
    public final String zzBb;
    public final String zzBc;
    public final boolean zzBd;
    public final boolean zzBe;
    public final boolean zzBf;
    public final String zzBg;
    public final String zzBh;
    public final int zzBi;
    public final int zzBj;
    public final int zzBk;
    public final int zzBl;
    public final int zzBm;
    public final int zzBn;
    public final float zzzi;
    public final int zzzg;
    public final int zzzh;
    public final double zzBo;
    public final boolean zzBp;
    public final boolean zzBq;
    public final int zzBr;

    public zzev(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Locale locale = Locale.getDefault();
        PackageManager packageManager = context.getPackageManager();
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        this.zzAY = audioManager.getMode();
        this.zzAZ = zzev.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzBa = zzev.zza(packageManager, "http://www.google.com") != null;
        this.zzBb = telephonyManager.getNetworkOperator();
        this.zzBc = locale.getCountry();
        this.zzBd = zzj.zzbJ().zzfj();
        this.zzBe = audioManager.isMusicActive();
        this.zzBf = audioManager.isSpeakerphoneOn();
        this.zzBg = locale.getLanguage();
        this.zzBh = zzev.zza(packageManager);
        this.zzBi = audioManager.getStreamVolume(3);
        this.zzBj = zzev.zza(context, connectivityManager, packageManager);
        this.zzBk = telephonyManager.getNetworkType();
        this.zzBl = telephonyManager.getPhoneType();
        this.zzBm = audioManager.getRingerMode();
        this.zzBn = audioManager.getStreamVolume(2);
        this.zzzi = displayMetrics.density;
        this.zzzg = displayMetrics.widthPixels;
        this.zzzh = displayMetrics.heightPixels;
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzBo = (float)n2 / (float)n3;
            this.zzBp = n == 2 || n == 5;
        } else {
            this.zzBo = -1.0;
            this.zzBp = false;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzBq = connectivityManager.isActiveNetworkMetered();
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            this.zzBr = networkInfo != null ? connectivityManager.getActiveNetworkInfo().getDetailedState().ordinal() : -1;
        } else {
            this.zzBq = false;
            this.zzBr = -1;
        }
    }

    private static String zza(PackageManager packageManager) {
        ResolveInfo resolveInfo = zzev.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
            return packageInfo != null ? packageInfo.versionCode + "." + activityInfo.packageName : null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static int zza(Context context, ConnectivityManager connectivityManager, PackageManager packageManager) {
        int n = -2;
        if (zzh.zzaQ().zza(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            n = networkInfo != null ? networkInfo.getType() : -1;
        }
        return n;
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        return packageManager.resolveActivity(intent, 65536);
    }
}

