/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.internal.zzat;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzbi;
import com.google.android.gms.internal.zzbs;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzem;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzfa;
import com.google.android.gms.internal.zzfo;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzfu;
import com.google.android.gms.internal.zzfv;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzhy;
import com.google.android.gms.internal.zzk;
import com.google.android.gms.internal.zzy;
import com.google.android.gms.internal.zzz;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzeo
public class zzek
implements Callable<zzfa> {
    private static final long zzyv = TimeUnit.SECONDS.toMillis(60L);
    private final Context mContext;
    private final zzfo zzyw;
    private final com.google.android.gms.ads.internal.zza zzsS;
    private final zzk zzsW;
    private final zzz zzyx;
    private final Object zzoe = new Object();
    private final zzfa.zza zzyh;
    private boolean zzyy;
    private int zzyl;
    private List<String> zzyz;

    public zzek(Context context, com.google.android.gms.ads.internal.zza zza2, zzz zzz2, zzfo zzfo2, zzk zzk2, zzfa.zza zza3) {
        this.mContext = context;
        this.zzsS = zza2;
        this.zzyw = zzfo2;
        this.zzyx = zzz2;
        this.zzyh = zza3;
        this.zzsW = zzk2;
        this.zzyy = false;
        this.zzyl = -2;
        this.zzyz = null;
    }

    public zzfa zzei() {
        try {
            zzy zzy2 = this.zzej();
            JSONObject jSONObject = this.zzd(zzy2);
            zza zza2 = this.zzd(jSONObject);
            zzbi.zza zza3 = this.zza(zzy2, zza2, jSONObject);
            zzfa zzfa2 = this.zza(zza3);
            return zzfa2;
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Malformed native JSON response.", jSONException);
        }
        catch (TimeoutException timeoutException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Timeout when loading native ad.", timeoutException);
        }
        if (!this.zzyy) {
            this.zzv(0);
        }
        return this.zza(null);
    }

    private zzy zzej() throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        if (this.zzek()) {
            return null;
        }
        String string2 = zzat.zzrU.get();
        String string3 = this.zzyh.zzBz.zzwB.indexOf("https") == 0 ? "https:" : "http:";
        String string4 = string3 + string2;
        zzy zzy2 = this.zzyx.zza(this.mContext, this.zzyh.zzBy.zzmJ, string4).get(zzyv, TimeUnit.MILLISECONDS);
        zzy2.zza(this.zzsS, this.zzsS, this.zzsS, this.zzsS, false, this.zzsS, this.zzsS, null, this.zzsS);
        return zzy2;
    }

    private JSONObject zzd(final zzy zzy2) throws TimeoutException, JSONException {
        zzbs zzbs2;
        if (this.zzek()) {
            return null;
        }
        final zzfs zzfs2 = new zzfs();
        final zzb zzb2 = new zzb();
        zzb2.zzyJ = zzbs2 = new zzbs(){

            @Override
            public void zza(zzgd zzgd2, Map<String, String> map) {
                zzy2.zzb("/nativeAdPreProcess", zzb2.zzyJ);
                try {
                    String string2 = map.get("success");
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        zzfs2.zzc(new JSONObject(string2).getJSONArray("ads").getJSONObject(0));
                        return;
                    }
                }
                catch (JSONException jSONException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("Malformed native JSON response.", jSONException);
                }
                zzek.this.zzv(0);
                zzv.zza((boolean)zzek.this.zzek(), (Object)"Unable to set the ad state error!");
                zzfs2.zzc(null);
            }
        };
        zzy2.zza("/nativeAdPreProcess", zzbs2);
        JSONObject jSONObject = new JSONObject(this.zzyh.zzBz.zzzr);
        zzy2.zza("google.afma.nativeAds.preProcessJsonGmsg", jSONObject);
        return (JSONObject)zzfs2.get(zzyv, TimeUnit.MILLISECONDS);
    }

    protected zza zzd(JSONObject jSONObject) throws JSONException {
        if (this.zzek()) {
            return null;
        }
        String string2 = jSONObject.getString("template_id");
        if ("2".equals(string2)) {
            return new zzel();
        }
        if ("1".equals(string2)) {
            return new zzem();
        }
        this.zzv(0);
        return null;
    }

    private zzbi.zza zza(zzy zzy2, zza zza2, JSONObject jSONObject) throws ExecutionException, InterruptedException, JSONException {
        if (this.zzek()) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("tracking_urls_and_actions");
        String[] stringArray = this.zzc(jSONObject2, "impression_tracking_urls");
        this.zzyz = stringArray == null ? null : Arrays.asList(stringArray);
        Object t = zza2.zza(this, jSONObject);
        if (t == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzak("Failed to retrieve ad assets.");
            return null;
        }
        t.zza(new zzbi(this.mContext, this.zzsS, zzy2, this.zzsW, jSONObject, (zzbi.zza)t));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzfa zza(zzbi.zza zza2) {
        int n;
        Object object = this.zzoe;
        synchronized (object) {
            n = this.zzyl;
            if (zza2 == null && this.zzyl == -2) {
                n = 0;
            }
        }
        if (n != -2) {
            zza2 = null;
        }
        return new zzfa(this.zzyh.zzBy.zzyW, null, this.zzyh.zzBz.zzuC, n, this.zzyh.zzBz.zzuD, this.zzyz, this.zzyh.zzBz.orientation, this.zzyh.zzBz.zzuG, this.zzyh.zzBy.zzyZ, false, null, null, null, null, null, 0L, this.zzyh.zzmP, this.zzyh.zzBz.zzzs, this.zzyh.zzBv, this.zzyh.zzBw, this.zzyh.zzBz.zzzy, this.zzyh.zzBs, zza2, this.zzyh.zzBy.zzzm);
    }

    public zzfv<zzbe> zze(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject("attribution");
        if (jSONObject2 == null) {
            return new zzft<Object>(null);
        }
        final String string2 = jSONObject2.optString("text");
        final int n = jSONObject2.optInt("text_size", -1);
        final Integer n2 = this.zzb(jSONObject2, "text_color");
        final Integer n3 = this.zzb(jSONObject2, "bg_color");
        zzfv<Drawable> zzfv2 = this.zza(jSONObject2, "image", false);
        return zzfu.zza(zzfv2, new zzfu.zza<Drawable, zzbe>(){

            public zzbe zza(Drawable drawable) {
                return drawable == null || TextUtils.isEmpty((CharSequence)string2) ? null : new zzbe(string2, drawable, n3, n2, n > 0 ? Integer.valueOf(n) : null);
            }

            @Override
            public /* synthetic */ Object zzb(Object object) {
                return this.zza((Drawable)object);
            }
        });
    }

    private Integer zzb(JSONObject jSONObject, String string2) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            int n = jSONObject2.getInt("r");
            int n2 = jSONObject2.getInt("g");
            int n3 = jSONObject2.getInt("b");
            return Color.rgb((int)n, (int)n2, (int)n3);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public zzfv<Drawable> zza(JSONObject jSONObject, String string2, final boolean bl) throws JSONException {
        String string3;
        JSONObject jSONObject2 = bl ? jSONObject.getJSONObject(string2) : jSONObject.optJSONObject(string2);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        String string4 = string3 = bl ? jSONObject2.getString("url") : jSONObject2.optString("url");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            this.zza(0, bl);
            return new zzft<Object>(null);
        }
        return this.zzyw.zza(string3, new zzfo.zza<Drawable>(){

            public Drawable zzel() {
                zzek.this.zza(2, bl);
                return null;
            }

            public Drawable zza(InputStream inputStream) {
                byte[] byArray = null;
                try {
                    byArray = zzhy.zzd((InputStream)inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (byArray == null) {
                    zzek.this.zza(2, bl);
                    return null;
                }
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                if (bitmap == null) {
                    zzek.this.zza(2, bl);
                    return null;
                }
                return new BitmapDrawable(Resources.getSystem(), bitmap);
            }

            @Override
            public /* synthetic */ Object zzem() {
                return this.zzel();
            }

            @Override
            public /* synthetic */ Object zzb(InputStream inputStream) {
                return this.zza(inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzek() {
        Object object = this.zzoe;
        synchronized (object) {
            return this.zzyy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzv(int n) {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzyy = true;
            this.zzyl = n;
        }
    }

    public void zza(int n, boolean bl) {
        if (bl) {
            this.zzv(n);
        }
    }

    private String[] zzc(JSONObject jSONObject, String string2) throws JSONException {
        JSONArray jSONArray = jSONObject.optJSONArray(string2);
        if (jSONArray == null) {
            return null;
        }
        String[] stringArray = new String[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            stringArray[i] = jSONArray.getString(i);
        }
        return stringArray;
    }

    @Override
    public /* synthetic */ Object call() throws Exception {
        return this.zzei();
    }

    class zzb {
        public zzbs zzyJ;

        zzb() {
        }
    }

    public static interface zza<T extends zzbi.zza> {
        public T zza(zzek var1, JSONObject var2) throws JSONException, InterruptedException, ExecutionException;
    }
}

