/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.internal.zzak;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzgd;
import java.util.Map;

@zzeo
public class zzdd
extends zzdg {
    private final Map<String, String> zzvi;
    private final Context mContext;

    public zzdd(zzgd zzgd2, Map<String, String> map) {
        super(zzgd2, "storePicture");
        this.zzvi = map;
        this.mContext = zzgd2.zzfp();
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzQ("Activity context is not available");
            return;
        }
        zzak zzak2 = zzh.zzaQ().zzz(this.mContext);
        if (!zzak2.zzbX()) {
            this.zzQ("Feature is not supported by the device.");
            return;
        }
        final String string2 = this.zzvi.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzQ("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            this.zzQ("Invalid image url: " + string2);
            return;
        }
        final String string3 = this.zzP(string2);
        if (!zzh.zzaQ().zzaf(string3)) {
            this.zzQ("Image type not recognized: " + string3);
            return;
        }
        AlertDialog.Builder builder = zzh.zzaQ().zzy(this.mContext);
        builder.setTitle((CharSequence)zzh.zzaT().zzc(R.string.store_picture_title, "Save image"));
        builder.setMessage((CharSequence)zzh.zzaT().zzc(R.string.store_picture_message, "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)zzh.zzaT().zzc(R.string.accept, "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                DownloadManager downloadManager = (DownloadManager)zzdd.this.mContext.getSystemService("download");
                try {
                    DownloadManager.Request request = zzdd.this.zzg(string2, string3);
                    downloadManager.enqueue(request);
                }
                catch (IllegalStateException illegalStateException) {
                    zzdd.this.zzQ("Could not store picture.");
                }
            }
        });
        builder.setNegativeButton((CharSequence)zzh.zzaT().zzc(R.string.decline, "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzdd.this.zzQ("User canceled the download.");
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    DownloadManager.Request zzg(String string2, String string3) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_PICTURES, string3);
        zzh.zzaS().zza(request);
        return request;
    }

    String zzP(String string2) {
        Uri uri = Uri.parse((String)string2);
        return uri.getLastPathSegment();
    }
}

