/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzbo;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzgd;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.JSONObject;

@zzeo
public final class zzca
extends zzbo {
    private final Map<zzgd, Integer> zztL = new WeakHashMap<zzgd, Integer>();

    private static int zza(Context context, Map<String, String> map, String string, int n) {
        String string2 = map.get(string);
        int n2 = n;
        if (string2 != null) {
            try {
                n2 = zzj.zzbJ().zzb(context, Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                zzb.zzan("Could not parse " + string + " in a video GMSG: " + string2);
            }
        }
        return n2;
    }

    @Override
    public void zzb(zzgd zzgd2, Map<String, String> map) {
        Object object;
        String string = map.get("action");
        if (string == null) {
            zzb.zzan("Action missing from video GMSG.");
            return;
        }
        if (zzb.zzC(3)) {
            object = new JSONObject(map);
            object.remove("google.afma.Notify_dt");
            zzb.zzaj("Video GMSG: " + string + " " + object.toString());
        }
        if ("background".equals(string)) {
            object = map.get("color");
            if (TextUtils.isEmpty((CharSequence)object)) {
                zzb.zzan("Color parameter missing from color video GMSG.");
                return;
            }
            try {
                zzg zzg2;
                int n = Color.parseColor((String)object);
                zzc zzc2 = zzgd2.zzfr();
                if (zzc2 != null && (zzg2 = zzc2.zzds()) != null) {
                    zzg2.setBackgroundColor(n);
                    return;
                }
                this.zztL.put(zzgd2, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzb.zzan("Invalid color parameter in video GMSG.");
            }
            return;
        }
        object = zzgd2.zzfr();
        if (object == null) {
            zzb.zzan("Could not get ad overlay for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string);
        boolean bl2 = "position".equals(string);
        if (bl || bl2) {
            Context context = zzgd2.getContext();
            int n = zzca.zza(context, map, "x", 0);
            int n2 = zzca.zza(context, map, "y", 0);
            int n3 = zzca.zza(context, map, "w", -1);
            int n4 = zzca.zza(context, map, "h", -1);
            if (bl && ((zzc)object).zzds() == null) {
                ((zzc)object).zze(n, n2, n3, n4);
                if (this.zztL.containsKey(zzgd2)) {
                    int n5 = this.zztL.get(zzgd2);
                    zzg zzg3 = ((zzc)object).zzds();
                    zzg3.setBackgroundColor(n5);
                }
            } else {
                ((zzc)object).zzd(n, n2, n3, n4);
            }
        } else {
            zzg zzg4 = ((zzc)object).zzds();
            if (zzg4 == null) {
                zzg.zza(zzgd2, "no_video_view", null);
                return;
            }
            if ("click".equals(string)) {
                Context context = zzgd2.getContext();
                int n = zzca.zza(context, map, "x", 0);
                int n6 = zzca.zza(context, map, "y", 0);
                long l = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
                zzg4.zzb(motionEvent);
                motionEvent.recycle();
            } else if ("controls".equals(string)) {
                String string2 = map.get("enabled");
                if (string2 == null) {
                    zzb.zzan("Enabled parameter missing from controls video GMSG.");
                    return;
                }
                zzg4.zzv(Boolean.parseBoolean(string2));
            } else if ("currentTime".equals(string)) {
                String string3 = map.get("time");
                if (string3 == null) {
                    zzb.zzan("Time parameter missing from currentTime video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string3);
                    int n = (int)(f * 1000.0f);
                    zzg4.seekTo(n);
                }
                catch (NumberFormatException numberFormatException) {
                    zzb.zzan("Could not parse time parameter from currentTime video GMSG: " + string3);
                }
            } else if ("hide".equals(string)) {
                zzg4.setVisibility(4);
            } else if ("load".equals(string)) {
                zzg4.zzdF();
            } else if ("muted".equals(string)) {
                boolean bl3 = Boolean.parseBoolean(map.get("muted"));
                if (bl3) {
                    zzg4.zzdG();
                } else {
                    zzg4.zzdH();
                }
            } else if ("pause".equals(string)) {
                zzg4.pause();
            } else if ("play".equals(string)) {
                zzg4.play();
            } else if ("show".equals(string)) {
                zzg4.setVisibility(0);
            } else if ("src".equals(string)) {
                zzg4.zzT(map.get("src"));
            } else if ("volume".equals(string)) {
                String string4 = map.get("volume");
                if (string4 == null) {
                    zzb.zzan("Level parameter missing from volume video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    zzg4.zza(f);
                }
                catch (NumberFormatException numberFormatException) {
                    zzb.zzan("Could not parse volume parameter from volume video GMSG: " + string4);
                }
            } else if ("watermark".equals(string)) {
                zzg4.zzdJ();
            } else {
                zzb.zzan("Unknown video action: " + string);
            }
        }
    }
}

