/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.internal.zzbs;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzfk;
import com.google.android.gms.internal.zzfl;
import com.google.android.gms.internal.zzgd;
import java.io.BufferedOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzeo
public class zzbt
implements zzbs {
    private final Context mContext;
    private final VersionInfoParcel zzoi;

    public zzbt(Context context, VersionInfoParcel versionInfoParcel) {
        this.mContext = context;
        this.zzoi = versionInfoParcel;
    }

    protected zzb zzb(JSONObject jSONObject) {
        String string = jSONObject.optString("http_request_id");
        String string2 = jSONObject.optString("url");
        String string3 = jSONObject.optString("post_body", null);
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzb("Error constructing http request.", malformedURLException);
        }
        ArrayList<zza> arrayList = new ArrayList<zza>();
        JSONArray jSONArray = jSONObject.optJSONArray("headers");
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i);
            if (jSONObject2 == null) continue;
            String string4 = jSONObject2.optString("key");
            String string5 = jSONObject2.optString("value");
            arrayList.add(new zza(string4, string5));
        }
        return new zzb(string, uRL, arrayList, string3);
    }

    protected JSONObject zza(zzd zzd2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("http_request_id", (Object)zzd2.zzcR());
            if (zzd2.getBody() != null) {
                jSONObject.put("body", (Object)zzd2.getBody());
            }
            JSONArray jSONArray = new JSONArray();
            for (zza zza2 : zzd2.zzcW()) {
                jSONArray.put((Object)new JSONObject().put("key", (Object)zza2.getKey()).put("value", (Object)zza2.getValue()));
            }
            jSONObject.put("headers", (Object)jSONArray);
            jSONObject.put("response_code", zzd2.getResponseCode());
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzb("Error constructing JSON for http response.", jSONException);
        }
        return jSONObject;
    }

    protected zzc zza(zzb zzb2) {
        try {
            Object object;
            HttpURLConnection httpURLConnection = (HttpURLConnection)zzb2.zzcS().openConnection();
            zzh.zzaQ().zza(this.mContext, this.zzoi.zzCI, false, httpURLConnection);
            for (zza object22 : zzb2.zzcT()) {
                httpURLConnection.addRequestProperty(object22.getKey(), object22.getValue());
            }
            if (!TextUtils.isEmpty((CharSequence)zzb2.zzcU())) {
                httpURLConnection.setDoOutput(true);
                object = zzb2.zzcU().getBytes();
                httpURLConnection.setFixedLengthStreamingMode(((Object)object).length);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
                bufferedOutputStream.write((byte[])object);
                bufferedOutputStream.close();
            }
            object = new ArrayList();
            if (httpURLConnection.getHeaderFields() != null) {
                for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
                    for (String string : entry.getValue()) {
                        ((ArrayList)object).add(new zza(entry.getKey(), string));
                    }
                }
            }
            zzd zzd2 = new zzd(zzb2.zzcR(), httpURLConnection.getResponseCode(), (List<zza>)object, zzh.zzaQ().zza(new InputStreamReader(httpURLConnection.getInputStream())));
            return new zzc(true, zzd2, null);
        }
        catch (Exception exception) {
            return new zzc(false, null, exception.toString());
        }
    }

    public JSONObject zzF(String string) {
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzak("The request is not a valid JSON.");
            try {
                return new JSONObject().put("success", false);
            }
            catch (JSONException jSONException2) {
                return new JSONObject();
            }
        }
        JSONObject jSONObject2 = new JSONObject();
        String string2 = "";
        try {
            string2 = jSONObject.optString("http_request_id");
            zzb zzb2 = this.zzb(jSONObject);
            zzc zzc2 = this.zza(zzb2);
            if (zzc2.isSuccess()) {
                JSONObject jSONObject3 = this.zza(zzc2.zzcV());
                jSONObject2.put("response", (Object)jSONObject3);
                jSONObject2.put("success", true);
            } else {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string2));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)zzc2.getReason());
            }
        }
        catch (Exception exception) {
            try {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string2));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)exception.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return jSONObject2;
    }

    @Override
    public void zza(final zzgd zzgd2, final Map<String, String> map) {
        zzfk.zza(new Runnable(){

            @Override
            public void run() {
                com.google.android.gms.ads.internal.util.client.zzb.zzaj("Received Http request.");
                String string = (String)map.get("http_request");
                final JSONObject jSONObject = zzbt.this.zzF(string);
                if (jSONObject == null) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzak("Response should not be null.");
                    return;
                }
                zzfl.zzCr.post(new Runnable(){

                    @Override
                    public void run() {
                        zzgd2.zzb("fetchHttpRequestCompleted", jSONObject);
                        com.google.android.gms.ads.internal.util.client.zzb.zzaj("Dispatched http response.");
                    }
                });
            }
        });
    }

    @zzeo
    class zzc {
        private final zzd zztA;
        private final boolean zztB;
        private final String zztC;

        public zzc(boolean bl, zzd zzd2, String string) {
            this.zztB = bl;
            this.zztA = zzd2;
            this.zztC = string;
        }

        public String getReason() {
            return this.zztC;
        }

        public zzd zzcV() {
            return this.zztA;
        }

        public boolean isSuccess() {
            return this.zztB;
        }
    }

    @zzeo
    static class zzd {
        private final String zztw;
        private final int zztD;
        private final List<zza> zztE;
        private final String zzsI;

        public zzd(String string, int n, List<zza> list, String string2) {
            this.zztw = string;
            this.zztD = n;
            this.zztE = list == null ? new ArrayList<zza>() : list;
            this.zzsI = string2;
        }

        public String zzcR() {
            return this.zztw;
        }

        public int getResponseCode() {
            return this.zztD;
        }

        public Iterable<zza> zzcW() {
            return this.zztE;
        }

        public String getBody() {
            return this.zzsI;
        }
    }

    @zzeo
    static class zzb {
        private final String zztw;
        private final URL zztx;
        private final ArrayList<zza> zzty;
        private final String zztz;

        public zzb(String string, URL uRL, ArrayList<zza> arrayList, String string2) {
            this.zztw = string;
            this.zztx = uRL;
            this.zzty = arrayList == null ? new ArrayList() : arrayList;
            this.zztz = string2;
        }

        public String zzcR() {
            return this.zztw;
        }

        public URL zzcS() {
            return this.zztx;
        }

        public ArrayList<zza> zzcT() {
            return this.zzty;
        }

        public String zzcU() {
            return this.zztz;
        }
    }

    @zzeo
    static class zza {
        private final String zzra;
        private final String mValue;

        public zza(String string, String string2) {
            this.zzra = string;
            this.mValue = string2;
        }

        public String getKey() {
            return this.zzra;
        }

        public String getValue() {
            return this.mValue;
        }
    }
}

