/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzbo;
import com.google.android.gms.internal.zzbs;
import com.google.android.gms.internal.zzca;
import com.google.android.gms.internal.zzce;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzg;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzk;
import com.google.android.gms.internal.zzl;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzeo
public final class zzbr {
    public static final zzbs zzti = new zzbs(){

        @Override
        public void zza(zzgd zzgd2, Map<String, String> map) {
        }
    };
    public static final zzbs zztj = new zzbs(){

        @Override
        public void zza(zzgd zzgd2, Map<String, String> map) {
            String string = map.get("urls");
            if (TextUtils.isEmpty((CharSequence)string)) {
                zzb.zzan("URLs missing in canOpenURLs GMSG.");
                return;
            }
            String[] stringArray = string.split(",");
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            PackageManager packageManager = zzgd2.getContext().getPackageManager();
            for (String string2 : stringArray) {
                String[] stringArray2 = string2.split(";", 2);
                String string3 = stringArray2[0].trim();
                String string4 = stringArray2.length > 1 ? stringArray2[1].trim() : "android.intent.action.VIEW";
                Uri uri = Uri.parse((String)string3);
                Intent intent = new Intent(string4, uri);
                ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
                hashMap.put(string2, resolveInfo != null);
            }
            zzgd2.zzb("openableURLs", hashMap);
        }
    };
    public static final zzbs zztk = new zzbs(){

        @Override
        public void zza(zzgd zzgd2, Map<String, String> map) {
            JSONArray jSONArray;
            JSONObject jSONObject;
            PackageManager packageManager = zzgd2.getContext().getPackageManager();
            String string = map.get("data");
            try {
                jSONObject = new JSONObject(string);
            }
            catch (JSONException jSONException) {
                zzgd2.zzb("openableIntents", new JSONObject());
                return;
            }
            try {
                jSONArray = jSONObject.getJSONArray("intents");
            }
            catch (JSONException jSONException) {
                zzgd2.zzb("openableIntents", new JSONObject());
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (int i = 0; i < jSONArray.length(); ++i) {
                ResolveInfo resolveInfo;
                JSONObject jSONObject3;
                try {
                    jSONObject3 = jSONArray.getJSONObject(i);
                }
                catch (JSONException jSONException) {
                    zzb.zzb("Error parsing the intent data.", jSONException);
                    continue;
                }
                String string2 = jSONObject3.optString("id");
                String string3 = jSONObject3.optString("u");
                String string4 = jSONObject3.optString("i");
                String string5 = jSONObject3.optString("m");
                String string6 = jSONObject3.optString("p");
                String string7 = jSONObject3.optString("c");
                String string8 = jSONObject3.optString("f");
                String string9 = jSONObject3.optString("e");
                Intent intent = new Intent();
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    intent.setData(Uri.parse((String)string3));
                }
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    intent.setAction(string4);
                }
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    intent.setType(string5);
                }
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    intent.setPackage(string6);
                }
                if (!TextUtils.isEmpty((CharSequence)string7) && ((ResolveInfo)(resolveInfo = string7.split("/", 2))).length == 2) {
                    intent.setComponent(new ComponentName((String)resolveInfo[0], (String)resolveInfo[1]));
                }
                boolean bl = (resolveInfo = packageManager.resolveActivity(intent, 65536)) != null;
                try {
                    jSONObject2.put(string2, bl);
                    continue;
                }
                catch (JSONException jSONException) {
                    zzb.zzb("Error constructing openable urls response.", jSONException);
                }
            }
            zzgd2.zzb("openableIntents", jSONObject2);
        }
    };
    public static final zzbs zztl = new zzbs(){

        @Override
        public void zza(zzgd zzgd2, Map<String, String> map) {
            Object object;
            String string = map.get("u");
            if (string == null) {
                zzb.zzan("URL missing from click GMSG.");
                return;
            }
            Uri uri = Uri.parse((String)string);
            try {
                object = zzgd2.zzfv();
                if (object != null && object.zzb(uri)) {
                    uri = object.zza(uri, zzgd2.getContext());
                }
            }
            catch (zzl zzl2) {
                zzb.zzan("Unable to append parameter to URL: " + string);
            }
            string = uri.toString();
            object = new zzfp(zzgd2.getContext(), zzgd2.zzfw().zzCI, string);
            ((zzfh)object).zzeW();
        }
    };
    public static final zzbs zztm = new zzbs(){

        @Override
        public void zza(zzgd zzgd2, Map<String, String> map) {
            zzc zzc2 = zzgd2.zzfr();
            if (zzc2 != null) {
                zzc2.close();
            } else {
                zzc zzc3 = zzgd2.zzfs();
                if (zzc3 != null) {
                    zzc3.close();
                } else {
                    zzb.zzan("A GMSG tried to close something that wasn't an overlay.");
                }
            }
        }
    };
    public static final zzbs zztn = new zzbo(){

        @Override
        public void zzb(zzgd zzgd2, Map<String, String> map) {
            zzgd2.zzC("1".equals(map.get("custom_close")));
        }
    };
    public static final zzbs zzto = new zzbs(){

        @Override
        public void zza(zzgd zzgd2, Map<String, String> map) {
            String string = map.get("u");
            if (string == null) {
                zzb.zzan("URL missing from httpTrack GMSG.");
                return;
            }
            zzfp zzfp2 = new zzfp(zzgd2.getContext(), zzgd2.zzfw().zzCI, string);
            zzfp2.zzeW();
        }
    };
    public static final zzbs zztp = new zzbs(){

        @Override
        public void zza(zzgd zzgd2, Map<String, String> map) {
            zzb.zzal("Received log message: " + map.get("string"));
        }
    };
    public static final zzbs zztq = new zzbs(){

        @Override
        public void zza(zzgd zzgd2, Map<String, String> map) {
            String string = map.get("tx");
            String string2 = map.get("ty");
            String string3 = map.get("td");
            try {
                int n = Integer.parseInt(string);
                int n2 = Integer.parseInt(string2);
                int n3 = Integer.parseInt(string3);
                zzk zzk2 = zzgd2.zzfv();
                if (zzk2 != null) {
                    zzg zzg2 = zzk2.zzC();
                    zzg2.zza(n, n2, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                zzb.zzan("Could not parse touch parameters from gmsg.");
            }
        }
    };
    public static final zzbs zztr = new zzca();
    public static final zzbs zzts = new zzce();
}

