/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.ViewSwitcher;
import com.google.android.gms.ads.internal.InterstitialAdParameterParcel;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzn;
import com.google.android.gms.ads.internal.client.zzp;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzf;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.purchase.GInAppPurchaseManagerInfoParcel;
import com.google.android.gms.ads.internal.purchase.zzc;
import com.google.android.gms.ads.internal.purchase.zzd;
import com.google.android.gms.ads.internal.purchase.zzg;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzae;
import com.google.android.gms.internal.zzat;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzay;
import com.google.android.gms.internal.zzaz;
import com.google.android.gms.internal.zzbc;
import com.google.android.gms.internal.zzbg;
import com.google.android.gms.internal.zzbh;
import com.google.android.gms.internal.zzbm;
import com.google.android.gms.internal.zzbn;
import com.google.android.gms.internal.zzbq;
import com.google.android.gms.internal.zzbu;
import com.google.android.gms.internal.zzbw;
import com.google.android.gms.internal.zzcl;
import com.google.android.gms.internal.zzcr;
import com.google.android.gms.internal.zzdh;
import com.google.android.gms.internal.zzdo;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzdv;
import com.google.android.gms.internal.zzef;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzfa;
import com.google.android.gms.internal.zzfb;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzff;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzfl;
import com.google.android.gms.internal.zzfn;
import com.google.android.gms.internal.zzfq;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzge;
import com.google.android.gms.internal.zzt;
import com.google.android.gms.internal.zzv;
import com.google.android.gms.internal.zzw;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;

@zzeo
public class zza
extends zzn.zza
implements com.google.android.gms.ads.internal.client.zza,
zzf,
zzi,
com.google.android.gms.ads.internal.purchase.zzj,
zza.zza,
com.google.android.gms.ads.internal.zzc,
zzbq,
zzbu,
zzbw,
zzcl,
zzdh,
zzef.zza,
zzfe,
zzt {
    private zzay zzmr;
    private zzax zzms;
    private zzax zzmt;
    private AdRequestParcel zzmu;
    private final zzcr zzmv;
    private final zzb zzmw;
    private final com.google.android.gms.ads.internal.zzg zzmx;
    private final zzv zzmy;
    private final Messenger zzmz;
    private boolean zzmA;
    private boolean zzmB;

    public zza(Context context, AdSizeParcel adSizeParcel, String string2, zzcr zzcr2, VersionInfoParcel versionInfoParcel) {
        this(new zzb(context, adSizeParcel, string2, versionInfoParcel), zzcr2, null);
    }

    zza(zzb zzb2, zzcr zzcr2, com.google.android.gms.ads.internal.zzg zzg2) {
        this.zzmw = zzb2;
        this.zzmv = zzcr2;
        this.zzmx = zzg2 != null ? zzg2 : new com.google.android.gms.ads.internal.zzg(this);
        zzh.zzaQ().zzw(this.zzmw.zzmH);
        zzh.zzaT().zzb(this.zzmw.zzmH, this.zzmw.zzmJ);
        this.zzmy = zzh.zzaT().zzeR();
        this.zzmz = new Messenger((Handler)new zzdo(this.zzmw.zzmH));
    }

    void zzaf() {
        this.zzmr = new zzay("load_ad");
        this.zzms = new zzax(-1L, null, null);
        this.zzmt = new zzax(-1L, null, null);
    }

    @Override
    public void destroy() {
        com.google.android.gms.common.internal.zzv.zzbI((String)"destroy must be called on the main UI thread.");
        this.zzmx.cancel();
        this.zzmy.zze(this.zzmw.zzmQ);
        this.zzmw.destroy();
    }

    @Override
    public com.google.android.gms.dynamic.zzd zzag() {
        com.google.android.gms.common.internal.zzv.zzbI((String)"getAdFrame must be called on the main UI thread.");
        return zze.zzt((Object)((Object)this.zzmw.zzmM));
    }

    @Override
    public AdSizeParcel zzah() {
        com.google.android.gms.common.internal.zzv.zzbI((String)"getAdSize must be called on the main UI thread.");
        return this.zzmw.zzmP;
    }

    @Override
    public boolean isReady() {
        com.google.android.gms.common.internal.zzv.zzbI((String)"isLoaded must be called on the main UI thread.");
        return this.zzmw.zzmK == null && this.zzmw.zzmO == null && this.zzmw.zzmQ != null;
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel) {
        com.google.android.gms.common.internal.zzv.zzbI((String)"loadAd must be called on the main UI thread.");
        if (this.zzmw.zzmK != null || this.zzmw.zzmO != null) {
            if (this.zzmu != null) {
                com.google.android.gms.ads.internal.util.client.zzb.zzan("Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            }
            this.zzmu = adRequestParcel;
            return false;
        }
        if (this.zzmw.zzmP.zzpY && this.zzmw.zzmQ != null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzan("An interstitial is already loading. Aborting.");
            return false;
        }
        if (!this.zzaz()) {
            return false;
        }
        com.google.android.gms.ads.internal.util.client.zzb.zzal("Starting ad request.");
        this.zzaf();
        this.zzms = this.zzmr.zzct();
        if (!adRequestParcel.zzpL) {
            com.google.android.gms.ads.internal.util.client.zzb.zzal("Use AdRequest.Builder.addTestDevice(\"" + zzj.zzbJ().zzC(this.zzmw.zzmH) + "\") to get test ads on this device.");
        }
        Bundle bundle = null;
        bundle = this.zza(zzh.zzaT().zzs(this.zzmw.zzmH));
        this.zzmx.cancel();
        this.zzmw.zznd = 0;
        AdRequestInfoParcel.zza zza2 = this.zza(adRequestParcel, bundle);
        this.zzmw.zzmK = zzh.zzaM().zza(this.zzmw.zzmH, zza2, this.zzmw.zzmI, this);
        return true;
    }

    private zzgd zza(com.google.android.gms.ads.internal.zzb zzb2) {
        zzgd zzgd2 = null;
        if (this.zzmw.zzmP.zzpY) {
            zzgd2 = zzh.zzaR().zza(this.zzmw.zzmH, this.zzmw.zzmP, false, false, this.zzmw.zzmI, this.zzmw.zzmJ);
            zzgd2.zzft().zzb(this, null, this, this, zzat.zzrO.get(), this, this, zzb2, null);
        } else if (!this.zzmw.zzmP.zzqa) {
            View view = this.zzmw.zzmM.getNextView();
            if (view instanceof zzgd) {
                zzgd2 = (zzgd)view;
                zzgd2.zza(this.zzmw.zzmH, this.zzmw.zzmP);
            } else {
                if (view != null) {
                    this.zzmw.zzmM.removeView(view);
                }
                zzgd2 = zzh.zzaR().zza(this.zzmw.zzmH, this.zzmw.zzmP, false, false, this.zzmw.zzmI, this.zzmw.zzmJ);
                if (this.zzmw.zzmP.zzpZ == null) {
                    this.zzc((View)zzgd2.getWebView());
                }
            }
            zzgd2.zzft().zzb(this, this, this, this, false, this, null, zzb2, this);
        }
        return zzgd2;
    }

    @Override
    public void zza(zzfa.zza zza2) {
        Object object;
        this.zzmr.zza(this.zzms, "arf");
        this.zzmt = this.zzmr.zzct();
        this.zzmw.zzmK = null;
        this.zzmw.zzmR = zza2;
        zzgd zzgd2 = null;
        if (!this.zzmw.zzmP.zzqa) {
            object = new com.google.android.gms.ads.internal.zzb();
            zzgd2 = this.zza((com.google.android.gms.ads.internal.zzb)object);
            ((com.google.android.gms.ads.internal.zzb)object).zza(new zzb.zzb(zza2, zzgd2));
            zzgd2.setOnTouchListener(new View.OnTouchListener((com.google.android.gms.ads.internal.zzb)object){
                final /* synthetic */ com.google.android.gms.ads.internal.zzb zzmC;
                {
                    this.zzmC = zzb2;
                }

                public boolean onTouch(View v, MotionEvent event) {
                    this.zzmC.recordClick();
                    return false;
                }
            });
            zzgd2.setOnClickListener(new View.OnClickListener((com.google.android.gms.ads.internal.zzb)object){
                final /* synthetic */ com.google.android.gms.ads.internal.zzb zzmC;
                {
                    this.zzmC = zzb2;
                }

                public void onClick(View v) {
                    this.zzmC.recordClick();
                }
            });
        }
        if (zza2.zzmP != null) {
            this.zzmw.zzmP = zza2.zzmP;
        }
        if (zza2.errorCode != -2) {
            this.zza(new zzfa(zza2, zzgd2, null, null, null, null, null));
            return;
        }
        if (!zza2.zzBz.zzzt && zza2.zzBz.zzzC) {
            object = null;
            if (zza2.zzBz.zzwB != null) {
                object = Uri.parse((String)zza2.zzBz.zzwB).buildUpon().query(null).build().toString();
            }
            zzaz zzaz2 = new zzaz(this, (String)object, zza2.zzBz.zzzr);
            try {
                if (this.zzmw.zzmY != null) {
                    this.zzmw.zznd = 1;
                    this.zzmw.zzmY.zza(zzaz2);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not call the onCustomRenderedAdLoadedListener.", remoteException);
            }
            catch (RuntimeException runtimeException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzd("Exception happens when invoking onCustomRenderedAdLoaded.", runtimeException);
                zzh.zzaT().zzc(runtimeException, true);
            }
        }
        this.zzmw.zznd = 0;
        this.zzmw.zzmO = zzh.zzaP().zza(this.zzmw.zzmH, this, zza2, this.zzmw.zzmI, zzgd2, this.zzmv, this);
        com.google.android.gms.ads.internal.util.client.zzb.zzaj("AdRenderer: " + this.zzmw.zzmO.getClass().getName());
    }

    boolean zza(zzfa zzfa2, boolean bl) {
        AdRequestParcel adRequestParcel;
        boolean bl2 = false;
        if (this.zzmu != null) {
            adRequestParcel = this.zzmu;
            this.zzmu = null;
        } else {
            adRequestParcel = zzfa2.zzyW;
            bl2 = adRequestParcel.extras != null ? adRequestParcel.extras.getBoolean("_noRefresh", false) : false;
        }
        bl2 |= bl;
        if (this.zzmw.zzmP.zzpY) {
            if (this.zzmw.zznd == 0) {
                zzh.zzaS().zza(zzfa2.zzwz.getWebView());
            }
        } else if (!bl2 && this.zzmw.zznd == 0) {
            if (zzfa2.zzuG > 0L) {
                this.zzmx.zza(adRequestParcel, zzfa2.zzuG);
            } else if (zzfa2.zzBt != null && zzfa2.zzBt.zzuG > 0L) {
                this.zzmx.zza(adRequestParcel, zzfa2.zzBt.zzuG);
            } else if (!zzfa2.zzzt && zzfa2.errorCode == 2) {
                this.zzmx.zzc(adRequestParcel);
            }
        }
        return this.zzmx.zzaK();
    }

    @Override
    public void zza(zzfa zzfa2) {
        this.zzmr.zza(this.zzmt, "awr");
        this.zzmr.zza(this.zzms, "ttc");
        this.zzmw.zzmO = null;
        boolean bl = this.zzmw.zzmP.zzqa;
        this.zza((List<String>)null);
        if (zzfa2.errorCode != -2 && zzfa2.errorCode != 3) {
            zzh.zzaT().zzb(this.zzmw.zzaB());
        }
        if (zzfa2.errorCode == -1) {
            return;
        }
        if (this.zza(zzfa2, bl)) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaj("Ad refresh scheduled.");
        }
        if (zzfa2.errorCode == 3 && zzfa2.zzBt != null && zzfa2.zzBt.zzuE != null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaj("Pinging no fill URLs.");
            zzh.zzba().zza(this.zzmw.zzmH, this.zzmw.zzmJ.zzCI, zzfa2, this.zzmw.zzmG, false, zzfa2.zzBt.zzuE);
        }
        if (zzfa2.errorCode != -2) {
            this.zza(zzfa2.errorCode);
            return;
        }
        if (!this.zzmw.zzmP.zzpY && !bl && this.zzmw.zznd == 0) {
            if (!this.zzb(zzfa2)) {
                this.zza(0);
                return;
            }
            if (this.zzmw.zzmM != null) {
                this.zzmw.zzmM.zzmF.zzag(zzfa2.zzzy);
            }
        }
        if (this.zzmw.zzmQ != null && this.zzmw.zzmQ.zzuX != null) {
            this.zzmw.zzmQ.zzuX.zza((zzcl)null);
        }
        if (zzfa2.zzuX != null) {
            zzfa2.zzuX.zza(this);
        }
        this.zzmy.zzd(this.zzmw.zzmQ);
        this.zzmw.zzmQ = zzfa2;
        this.zzmw.zzmS.zzj(zzfa2.zzBv);
        this.zzmw.zzmS.zzk(zzfa2.zzBw);
        this.zzmw.zzmS.zzy(this.zzmw.zzmP.zzpY);
        this.zzmw.zzmS.zzz(zzfa2.zzzt);
        if (!this.zzmw.zzmP.zzpY && !bl && this.zzmw.zznd == 0) {
            this.zze(false);
        }
        if (this.zzmw.zznb == null) {
            this.zzmw.zznb = new zzff(this.zzmw.zzmG);
        }
        int n = 0;
        int n2 = 0;
        if (zzfa2.zzBt != null) {
            n = zzfa2.zzBt.zzuH;
            n2 = zzfa2.zzBt.zzuI;
        }
        this.zzmw.zznb.zzf(n, n2);
        if (this.zzmw.zznd == 0) {
            Object object;
            if (!this.zzmw.zzmP.zzpY && zzfa2.zzwz != null && (zzfa2.zzwz.zzft().zzbg() || zzfa2.zzBs != null)) {
                object = this.zzmy.zza(this.zzmw.zzmP, this.zzmw.zzmQ);
                if (zzfa2.zzwz.zzft().zzbg() && object != null) {
                    ((zzw)object).zza(this);
                }
            }
            if (this.zzmw.zzmQ.zzwz != null) {
                object = this.zzmw.zzmQ.zzwz.zzft();
                ((zzge)((Object)object)).zzfG();
            }
            if (bl) {
                object = zzfa2.zzBx;
                if (object instanceof zzbh && this.zzmw.zzmX != null) {
                    this.zzay();
                } else if (object instanceof zzbg && this.zzmw.zzmW != null) {
                    this.zzax();
                } else {
                    com.google.android.gms.ads.internal.util.client.zzb.zzan("No matching listener for retrieved native ad template.");
                    this.zza(0);
                    return;
                }
            }
            this.zzaw();
        } else if (this.zzmw.zznc != null && zzfa2.zzBs != null) {
            zzw zzw2 = this.zzmy.zza(this.zzmw.zzmP, this.zzmw.zzmQ, this.zzmw.zznc);
        }
        if (zzh.zzaT().zzeM() != null) {
            zzh.zzaT().zzeM().zza(this.zzmr);
        }
    }

    @Override
    public void zzb(View view) {
        this.zzmw.zznc = view;
        this.zza(new zzfa(this.zzmw.zzmR, null, null, null, null, null, null));
    }

    @Override
    public void onAdClicked() {
        this.recordClick();
    }

    @Override
    public void zzai() {
        this.zzau();
    }

    @Override
    public void zzaj() {
        this.zzmy.zzd(this.zzmw.zzmQ);
        if (this.zzmw.zzmP.zzpY) {
            this.zzaA();
        }
        this.zzmA = false;
        this.zzat();
        this.zzmw.zzmS.zzeF();
    }

    @Override
    public void zzak() {
        if (this.zzmw.zzmP.zzpY) {
            this.zze(false);
        }
        this.zzmA = true;
        this.zzav();
    }

    @Override
    public void onAppEvent(String name, String info) {
        if (this.zzmw.zzmT != null) {
            try {
                this.zzmw.zzmT.onAppEvent(name, info);
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not call the AppEventListener.", remoteException);
            }
        }
    }

    @Override
    public void zza(String string2, ArrayList<String> arrayList) {
        zzd zzd2 = new zzd(string2, arrayList, this.zzmw.zzmH, this.zzmw.zzmJ.zzCI);
        if (this.zzmw.zzmV == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzan("InAppPurchaseListener is not set. Try to launch default purchase flow.");
            if (!zzj.zzbJ().zzD(this.zzmw.zzmH)) {
                com.google.android.gms.ads.internal.util.client.zzb.zzan("Google Play Service unavailable, cannot launch default purchase flow.");
                return;
            }
            if (this.zzmw.zzmU == null) {
                com.google.android.gms.ads.internal.util.client.zzb.zzan("PlayStorePurchaseListener is not set.");
                return;
            }
            if (this.zzmw.zzna == null) {
                com.google.android.gms.ads.internal.util.client.zzb.zzan("PlayStorePurchaseVerifier is not initialized.");
                return;
            }
            if (this.zzmw.zzne) {
                com.google.android.gms.ads.internal.util.client.zzb.zzan("An in-app purchase request is already in progress, abort");
                return;
            }
            this.zzmw.zzne = true;
            try {
                if (!this.zzmw.zzmU.isValidPurchase(string2)) {
                    this.zzmw.zzne = false;
                    return;
                }
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzan("Could not start In-App purchase.");
                this.zzmw.zzne = false;
                return;
            }
            zzh.zzaZ().zza(this.zzmw.zzmH, this.zzmw.zzmJ.zzCL, new GInAppPurchaseManagerInfoParcel(this.zzmw.zzmH, this.zzmw.zzna, zzd2, this));
        } else {
            try {
                this.zzmw.zzmV.zza(zzd2);
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzan("Could not start In-App purchase.");
            }
        }
    }

    @Override
    public void zza(String string2, boolean bl, int n, final Intent intent, com.google.android.gms.ads.internal.purchase.zzf zzf2) {
        try {
            if (this.zzmw.zzmU != null) {
                this.zzmw.zzmU.zza(new zzg(this.zzmw.zzmH, string2, bl, n, intent, zzf2));
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzan("Fail to invoke PlayStorePurchaseListener.");
        }
        zzfl.zzCr.postDelayed(new Runnable(){

            @Override
            public void run() {
                int n = zzh.zzaZ().zzd(intent);
                zzh.zzaZ();
                if (n == 0 && ((zza)zza.this).zzmw.zzmQ != null && ((zza)zza.this).zzmw.zzmQ.zzwz != null && ((zza)zza.this).zzmw.zzmQ.zzwz.zzfr() != null) {
                    ((zza)zza.this).zzmw.zzmQ.zzwz.zzfr().close();
                }
                ((zza)zza.this).zzmw.zzne = false;
            }
        }, 500L);
    }

    @Override
    public void zzal() {
        this.onAdClicked();
    }

    @Override
    public void zzam() {
        this.zzaj();
    }

    @Override
    public void zzan() {
        this.zzai();
    }

    @Override
    public void zzao() {
        this.zzak();
    }

    @Override
    public void zzap() {
        if (this.zzmw.zzmQ != null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzan("Mediation adapter " + this.zzmw.zzmQ.zzuW + " refreshed, but mediation adapters should never refresh.");
        }
        this.zze(true);
        this.zzaw();
    }

    @Override
    public void zza(int n, int n2, int n3, int n4) {
        this.zzav();
    }

    @Override
    public void zzaq() {
        this.zzat();
    }

    @Override
    public void zza(zzw zzw2, boolean bl) {
        if (this.zzmw.zzmQ != null && this.zzmw.zzmQ.zzwz != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("isVisible", bl ? "1" : "0");
            this.zzmw.zzmQ.zzwz.zzb("onAdVisibilityChanged", hashMap);
        }
    }

    @Override
    public void zzar() {
        com.google.android.gms.common.internal.zzv.zzbI((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzmw.zzmQ == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzan("Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        com.google.android.gms.ads.internal.util.client.zzb.zzaj("Pinging manual tracking URLs.");
        if (this.zzmw.zzmQ.zzzv != null) {
            zzh.zzaQ().zza(this.zzmw.zzmH, this.zzmw.zzmJ.zzCI, this.zzmw.zzmQ.zzzv);
        }
    }

    @Override
    public void pause() {
        com.google.android.gms.common.internal.zzv.zzbI((String)"pause must be called on the main UI thread.");
        if (this.zzmw.zzmQ != null && this.zzmw.zznd == 0) {
            zzh.zzaS().zza(this.zzmw.zzmQ.zzwz.getWebView());
        }
        if (this.zzmw.zzmQ != null && this.zzmw.zzmQ.zzuV != null) {
            try {
                this.zzmw.zzmQ.zzuV.pause();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzan("Could not pause mediation adapter.");
            }
        }
        this.zzmy.zzf(this.zzmw.zzmQ);
        this.zzmx.pause();
    }

    @Override
    public void resume() {
        com.google.android.gms.common.internal.zzv.zzbI((String)"resume must be called on the main UI thread.");
        if (this.zzmw.zzmQ != null && this.zzmw.zznd == 0) {
            zzh.zzaS().zzb(this.zzmw.zzmQ.zzwz.getWebView());
        }
        if (this.zzmw.zzmQ != null && this.zzmw.zzmQ.zzuV != null) {
            try {
                this.zzmw.zzmQ.zzuV.resume();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzan("Could not resume mediation adapter.");
            }
        }
        this.zzmx.resume();
        this.zzmy.zzg(this.zzmw.zzmQ);
    }

    public void zzb(AdRequestParcel adRequestParcel) {
        ViewParent viewParent = this.zzmw.zzmM.getParent();
        if (viewParent instanceof View && ((View)viewParent).isShown() && zzh.zzaQ().zzeZ() && !this.zzmA) {
            this.zza(adRequestParcel);
        } else {
            com.google.android.gms.ads.internal.util.client.zzb.zzal("Ad is not visible. Not refreshing ad.");
            this.zzmx.zzc(adRequestParcel);
        }
    }

    @Override
    public void zza(zzm zzm2) {
        com.google.android.gms.common.internal.zzv.zzbI((String)"setAdListener must be called on the main UI thread.");
        this.zzmw.zzmN = zzm2;
    }

    @Override
    public void zza(zzl zzl2) {
        com.google.android.gms.common.internal.zzv.zzbI((String)"setAdListener must be called on the main UI thread.");
        this.zzmw.zzmL = zzl2;
    }

    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        com.google.android.gms.common.internal.zzv.zzbI((String)"setAdSize must be called on the main UI thread.");
        this.zzmw.zzmP = adSizeParcel;
        if (this.zzmw.zzmQ != null && this.zzmw.zznd == 0) {
            this.zzmw.zzmQ.zzwz.zza(adSizeParcel);
        }
        if (this.zzmw.zzmM.getChildCount() > 1) {
            this.zzmw.zzmM.removeView(this.zzmw.zzmM.getNextView());
        }
        this.zzmw.zzmM.setMinimumWidth(adSizeParcel.widthPixels);
        this.zzmw.zzmM.setMinimumHeight(adSizeParcel.heightPixels);
        this.zzmw.zzmM.requestLayout();
    }

    @Override
    public void zza(zzp zzp2) {
        com.google.android.gms.common.internal.zzv.zzbI((String)"setAppEventListener must be called on the main UI thread.");
        this.zzmw.zzmT = zzp2;
    }

    @Override
    public void zza(zzdr zzdr2) {
        com.google.android.gms.common.internal.zzv.zzbI((String)"setInAppPurchaseListener must be called on the main UI thread.");
        this.zzmw.zzmV = zzdr2;
    }

    @Override
    public void zza(zzbc zzbc2) {
        com.google.android.gms.common.internal.zzv.zzbI((String)"setOnCustomRenderedAdLoadedListener must be called on the main UI thread.");
        this.zzmw.zzmY = zzbc2;
    }

    @Override
    public void zza(zzdv zzdv2, String string2) {
        com.google.android.gms.common.internal.zzv.zzbI((String)"setPlayStorePurchaseParams must be called on the main UI thread.");
        this.zzmw.zzna = new zzk(string2);
        this.zzmw.zzmU = zzdv2;
        if (!zzh.zzaT().zzeN() && zzdv2 != null) {
            new zzc(this.zzmw.zzmH, this.zzmw.zzmU, this.zzmw.zzna).zzeW();
        }
    }

    public void zza(List<String> list) {
        com.google.android.gms.common.internal.zzv.zzbI((String)"setNativeTemplates must be called on the main UI thread.");
        this.zzmw.zzmZ = list;
    }

    @Override
    public void zza(zzq zzq2) {
        com.google.android.gms.common.internal.zzv.zzbI((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzmw.zzng = zzq2;
    }

    @Override
    public void zzd(boolean bl) {
        this.zzmw.zznf = bl;
    }

    @Override
    public void showInterstitial() {
        Object object;
        com.google.android.gms.common.internal.zzv.zzbI((String)"showInterstitial must be called on the main UI thread.");
        if (!this.zzmw.zzmP.zzpY) {
            com.google.android.gms.ads.internal.util.client.zzb.zzan("Cannot call showInterstitial on a banner ad.");
            return;
        }
        if (this.zzmw.zzmQ == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzan("The interstitial has not loaded.");
            return;
        }
        if (!this.zzmB) {
            com.google.android.gms.ads.internal.util.client.zzb.zzan("It is not recommended to show an interstitial before onAdLoaded completes.");
            object = new Bundle();
            object.putString("appid", this.zzmw.zzmH.getApplicationContext().getPackageName());
            object.putString("action", "show_interstitial_before_load_finish");
            this.zza((Bundle)object);
        }
        if (!zzh.zzaQ().zzB(this.zzmw.zzmH)) {
            com.google.android.gms.ads.internal.util.client.zzb.zzan("It is not recommended to show an interstitial when app is not in foreground.");
            object = new Bundle();
            object.putString("appid", this.zzmw.zzmH.getApplicationContext().getPackageName());
            object.putString("action", "show_interstitial_app_not_in_foreground");
            this.zza((Bundle)object);
        }
        if (this.zzmw.zznd == 1) {
            return;
        }
        if (this.zzmw.zzmQ.zzwz.zzfx()) {
            com.google.android.gms.ads.internal.util.client.zzb.zzan("The interstitial is already showing.");
            return;
        }
        this.zzmw.zzmQ.zzwz.zzB(true);
        if (this.zzmw.zzmQ.zzwz.zzft().zzbg() || this.zzmw.zzmQ.zzBs != null) {
            object = this.zzmy.zza(this.zzmw.zzmP, this.zzmw.zzmQ);
            if (this.zzmw.zzmQ.zzwz.zzft().zzbg() && object != null) {
                ((zzw)object).zza(this);
            }
        }
        if (this.zzmw.zzmQ.zzzt) {
            try {
                this.zzmw.zzmQ.zzuV.showInterstitial();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not show interstitial.", remoteException);
                this.zzaA();
            }
        } else {
            object = new InterstitialAdParameterParcel(this.zzmw.zznf, this.zzas());
            int n = this.zzmw.zzmQ.zzwz.getRequestedOrientation();
            if (n == -1) {
                n = this.zzmw.zzmQ.orientation;
            }
            AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(this, this, this, this.zzmw.zzmQ.zzwz, n, this.zzmw.zzmJ, this.zzmw.zzmQ.zzzy, (InterstitialAdParameterParcel)object);
            zzh.zzaO().zza(this.zzmw.zzmH, adOverlayInfoParcel);
        }
    }

    private void zza(Bundle bundle) {
        zzh.zzaQ().zza(this.zzmw.zzmH, this.zzmw.zzmJ.zzCI, "gmob-apps", bundle);
    }

    protected boolean zzas() {
        if (!(this.zzmw.zzmH instanceof Activity)) {
            return false;
        }
        Window window = ((Activity)this.zzmw.zzmH).getWindow();
        if (window == null || window.getDecorView() == null) {
            return false;
        }
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        window.getDecorView().getGlobalVisibleRect(rect, null);
        window.getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.bottom != 0 && rect2.bottom != 0 && rect.top == rect2.top;
    }

    @Override
    public void stopLoading() {
        com.google.android.gms.common.internal.zzv.zzbI((String)"stopLoading must be called on the main UI thread.");
        this.zzmw.zzg(true);
    }

    Bundle zza(zzae zzae2) {
        if (zzae2 == null) {
            return null;
        }
        if (zzae2.zzbD()) {
            zzae2.wakeup();
        }
        zzab zzab2 = zzae2.zzbB();
        String string2 = null;
        if (zzab2 != null) {
            string2 = zzab2.zzbs();
            com.google.android.gms.ads.internal.util.client.zzb.zzaj("In AdManger: loadAd, " + zzab2.toString());
        }
        if (string2 != null) {
            Bundle bundle = new Bundle(1);
            bundle.putString("fingerprint", string2);
            bundle.putInt("v", 1);
            return bundle;
        }
        return null;
    }

    @Override
    public String getMediationAdapterClassName() {
        if (this.zzmw.zzmQ != null) {
            return this.zzmw.zzmQ.zzuW;
        }
        return null;
    }

    protected void zzc(View view) {
        this.zzmw.zzmM.addView(view, zzh.zzaS().zzfh());
    }

    private void zzat() {
        com.google.android.gms.ads.internal.util.client.zzb.zzal("Ad closing.");
        if (this.zzmw.zzmN != null) {
            try {
                this.zzmw.zzmN.onAdClosed();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not call AdListener.onAdClosed().", remoteException);
            }
        }
    }

    private void zza(int n) {
        com.google.android.gms.ads.internal.util.client.zzb.zzan("Failed to load ad: " + n);
        if (this.zzmw.zzmN != null) {
            try {
                this.zzmw.zzmN.onAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not call AdListener.onAdFailedToLoad().", remoteException);
            }
        }
    }

    private void zzau() {
        com.google.android.gms.ads.internal.util.client.zzb.zzal("Ad leaving application.");
        if (this.zzmw.zzmN != null) {
            try {
                this.zzmw.zzmN.onAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not call AdListener.onAdLeftApplication().", remoteException);
            }
        }
    }

    private void zzav() {
        com.google.android.gms.ads.internal.util.client.zzb.zzal("Ad opening.");
        if (this.zzmw.zzmN != null) {
            try {
                this.zzmw.zzmN.onAdOpened();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not call AdListener.onAdOpened().", remoteException);
            }
        }
    }

    private void zzaw() {
        com.google.android.gms.ads.internal.util.client.zzb.zzal("Ad finished loading.");
        if (this.zzmw.zzmN != null) {
            try {
                this.zzmw.zzmN.onAdLoaded();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not call AdListener.onAdLoaded().", remoteException);
            }
        }
        this.zzmB = true;
    }

    private void zzax() {
        try {
            if (this.zzmw.zzmQ.zzBx instanceof zzbg && this.zzmw.zzmW != null) {
                this.zzmw.zzmW.zza((zzbg)this.zzmw.zzmQ.zzBx);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not call OnAppInstallAdLoadedListener.onAppInstallAdLoaded().", remoteException);
        }
    }

    private void zzay() {
        try {
            if (this.zzmw.zzmQ.zzBx instanceof zzbh && this.zzmw.zzmX != null) {
                this.zzmw.zzmX.zza((zzbh)this.zzmw.zzmQ.zzBx);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not call OnContentAdLoadedListener.onContentAdLoaded().", remoteException);
        }
    }

    public boolean zzaz() {
        boolean bl = true;
        if (!zzh.zzaQ().zza(this.zzmw.zzmH.getPackageManager(), this.zzmw.zzmH.getPackageName(), "android.permission.INTERNET")) {
            if (!this.zzmw.zzmP.zzpY) {
                zzj.zzbJ().zza((ViewGroup)this.zzmw.zzmM, this.zzmw.zzmP, "Missing internet permission in AndroidManifest.xml.", "Missing internet permission in AndroidManifest.xml. You must have the following declaration: <uses-permission android:name=\"android.permission.INTERNET\" />");
            }
            bl = false;
        }
        if (!zzh.zzaQ().zzv(this.zzmw.zzmH)) {
            if (!this.zzmw.zzmP.zzpY) {
                zzj.zzbJ().zza((ViewGroup)this.zzmw.zzmM, this.zzmw.zzmP, "Missing AdActivity with android:configChanges in AndroidManifest.xml.", "Missing AdActivity with android:configChanges in AndroidManifest.xml. You must have the following declaration within the <application> element: <activity android:name=\"com.google.android.gms.ads.AdActivity\" android:configChanges=\"keyboard|keyboardHidden|orientation|screenLayout|uiMode|screenSize|smallestScreenSize\" />");
            }
            bl = false;
        }
        if (!bl && this.zzmw.zzmM != null) {
            this.zzmw.zzmM.setVisibility(0);
        }
        return bl;
    }

    private AdRequestInfoParcel.zza zza(AdRequestParcel adRequestParcel, Bundle bundle) {
        Object object;
        Object object2;
        PackageInfo packageInfo;
        PackageManager packageManager;
        ApplicationInfo applicationInfo = this.zzmw.zzmH.getApplicationInfo();
        try {
            packageManager = this.zzmw.zzmH.getPackageManager();
            packageInfo = packageManager.getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        packageManager = this.zzmw.zzmH.getResources().getDisplayMetrics();
        Bundle bundle2 = null;
        if (this.zzmw.zzmM != null && this.zzmw.zzmM.getParent() != null) {
            object2 = new int[2];
            this.zzmw.zzmM.getLocationOnScreen((int[])object2);
            Object object3 = object2[0];
            object = object2[1];
            int bl = this.zzmw.zzmM.getWidth();
            int l = this.zzmw.zzmM.getHeight();
            int n = 0;
            if (this.zzmw.zzmM.isShown() && object3 + bl > 0 && object + l > 0 && object3 <= packageManager.widthPixels && object <= packageManager.heightPixels) {
                n = 1;
            }
            bundle2 = new Bundle(5);
            bundle2.putInt("x", (int)object3);
            bundle2.putInt("y", (int)object);
            bundle2.putInt("width", bl);
            bundle2.putInt("height", l);
            bundle2.putInt("visible", n);
        }
        object2 = zzh.zzaT().zzeK();
        this.zzmw.zzmS = new zzfb((String)object2, this.zzmw.zzmG);
        this.zzmw.zzmS.zze(adRequestParcel);
        String string2 = zzh.zzaQ().zza(this.zzmw.zzmH, (View)this.zzmw.zzmM, this.zzmw.zzmP);
        object = com.google.android.gms.ads.internal.zzf.zzl(this.zzmw.zzmH).zzaJ();
        boolean bl = com.google.android.gms.ads.internal.zzf.zzl(this.zzmw.zzmH).isInitialized();
        long l = 0L;
        if (this.zzmw.zzng != null) {
            try {
                l = this.zzmw.zzng.getValue();
            }
            catch (RemoteException string3) {
                com.google.android.gms.ads.internal.util.client.zzb.zzan("Cannot get correlation id, default to 0.");
            }
        }
        String string3 = UUID.randomUUID().toString();
        Bundle bundle3 = zzh.zzaT().zza(this.zzmw.zzmH, this, (String)object2);
        return new AdRequestInfoParcel.zza(bundle2, adRequestParcel, this.zzmw.zzmP, this.zzmw.zzmG, applicationInfo, packageInfo, (String)object2, zzh.zzaT().getSessionId(), this.zzmw.zzmJ, bundle3, this.zzmw.zzmZ, bundle, zzh.zzaT().zzeO(), this.zzmz, packageManager.widthPixels, packageManager.heightPixels, packageManager.density, string2, bl, (int)object, l, string3, zzat.zzcg());
    }

    @Override
    public void recordClick() {
        if (this.zzmw.zzmQ == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzan("Ad state was null when trying to ping click URLs.");
            return;
        }
        com.google.android.gms.ads.internal.util.client.zzb.zzaj("Pinging click URLs.");
        this.zzmw.zzmS.zzeE();
        if (this.zzmw.zzmQ.zzuC != null) {
            zzh.zzaQ().zza(this.zzmw.zzmH, this.zzmw.zzmJ.zzCI, this.zzb(this.zzmw.zzmQ.zzuC));
        }
        if (this.zzmw.zzmQ.zzBt != null && this.zzmw.zzmQ.zzBt.zzuC != null) {
            zzh.zzba().zza(this.zzmw.zzmH, this.zzmw.zzmJ.zzCI, this.zzmw.zzmQ, this.zzmw.zzmG, false, this.zzb(this.zzmw.zzmQ.zzBt.zzuC));
        }
        if (this.zzmw.zzmQ.zzuU != null && this.zzmw.zzmQ.zzuU.zzuw != null) {
            zzh.zzba().zza(this.zzmw.zzmH, this.zzmw.zzmJ.zzCI, this.zzmw.zzmQ, this.zzmw.zzmG, false, this.zzmw.zzmQ.zzuU.zzuw);
        }
        if (this.zzmw.zzmL != null) {
            try {
                this.zzmw.zzmL.onAdClicked();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not notify onAdClicked event.", remoteException);
            }
        }
    }

    @Override
    public void recordImpression() {
        this.zze(false);
    }

    private void zze(boolean bl) {
        if (this.zzmw.zzmQ == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzan("Ad state was null when trying to ping impression URLs.");
            return;
        }
        com.google.android.gms.ads.internal.util.client.zzb.zzaj("Pinging Impression URLs.");
        this.zzmw.zzmS.zzeD();
        if (this.zzmw.zzmQ.zzuD != null) {
            zzh.zzaQ().zza(this.zzmw.zzmH, this.zzmw.zzmJ.zzCI, this.zzb(this.zzmw.zzmQ.zzuD));
        }
        if (this.zzmw.zzmQ.zzBt != null && this.zzmw.zzmQ.zzBt.zzuD != null) {
            zzh.zzba().zza(this.zzmw.zzmH, this.zzmw.zzmJ.zzCI, this.zzmw.zzmQ, this.zzmw.zzmG, bl, this.zzb(this.zzmw.zzmQ.zzBt.zzuD));
        }
        if (this.zzmw.zzmQ.zzuU != null && this.zzmw.zzmQ.zzuU.zzux != null) {
            zzh.zzba().zza(this.zzmw.zzmH, this.zzmw.zzmJ.zzCI, this.zzmw.zzmQ, this.zzmw.zzmG, bl, this.zzmw.zzmQ.zzuU.zzux);
        }
    }

    @Override
    public void zza(HashSet<zzfb> hashSet) {
        this.zzmw.zza(hashSet);
    }

    private void zzaA() {
        if (this.zzmw.zznd == 0) {
            this.zzmw.zzaC();
            this.zzmw.zzmQ = null;
            this.zzmw.zznf = false;
            this.zzmB = false;
        }
    }

    private boolean zzb(zzfa zzfa2) {
        View view;
        if (zzfa2.zzzt) {
            try {
                view = (View)zze.zzg((com.google.android.gms.dynamic.zzd)zzfa2.zzuV.getView());
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not get View from mediation adapter.", remoteException);
                return false;
            }
            View view2 = this.zzmw.zzmM.getNextView();
            if (view2 != null) {
                if (view2 instanceof zzgd) {
                    ((zzgd)view2).destroy();
                }
                this.zzmw.zzmM.removeView(view2);
            }
            try {
                this.zzc(view);
            }
            catch (Throwable throwable) {
                com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not add mediation view to view hierarchy.", throwable);
                return false;
            }
        }
        if (zzfa2.zzBu != null) {
            zzfa2.zzwz.zza(zzfa2.zzBu);
            this.zzmw.zzmM.removeAllViews();
            this.zzmw.zzmM.setMinimumWidth(zzfa2.zzBu.widthPixels);
            this.zzmw.zzmM.setMinimumHeight(zzfa2.zzBu.heightPixels);
            this.zzc((View)zzfa2.zzwz.getWebView());
        }
        if (this.zzmw.zzmM.getChildCount() > 1) {
            this.zzmw.zzmM.showNext();
        }
        if (this.zzmw.zzmQ != null) {
            view = this.zzmw.zzmM.getNextView();
            if (view instanceof zzgd) {
                ((zzgd)view).zza(this.zzmw.zzmH, this.zzmw.zzmP);
            } else if (view != null) {
                this.zzmw.zzmM.removeView(view);
            }
            this.zzmw.zzaE();
        }
        this.zzmw.zzmM.setVisibility(0);
        return true;
    }

    public String zza(String string2, String string3, int n) {
        if (zzat.zzrQ.get().booleanValue() && com.google.android.gms.ads.internal.zzf.zzl(this.zzmw.zzmH).isInitialized() && !TextUtils.isEmpty((CharSequence)string2)) {
            return Uri.parse((String)string2).buildUpon().appendQueryParameter("ga_cid", string3).appendQueryParameter("ga_hid", String.valueOf(n)).build().toString();
        }
        return string2;
    }

    public ArrayList<String> zzb(List<String> list) {
        String string2 = this.zzmw.zzmQ.zzzm;
        int n = com.google.android.gms.ads.internal.zzf.zzl(this.zzmw.zzmH).zzaJ();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : list) {
            arrayList.add(this.zza(string3, string2, n));
        }
        return arrayList;
    }

    @zzeo
    static class zzb
    implements ViewTreeObserver.OnGlobalLayoutListener,
    ViewTreeObserver.OnScrollChangedListener {
        public final String zzmG;
        public final Context zzmH;
        public final com.google.android.gms.internal.zzk zzmI;
        public final VersionInfoParcel zzmJ;
        public zzfh zzmK;
        public zzl zzmL;
        public zza zzmM;
        public zzm zzmN;
        public zzfh zzmO;
        public AdSizeParcel zzmP;
        public zzfa zzmQ;
        public zzfa.zza zzmR;
        public zzfb zzmS;
        public zzp zzmT;
        public zzdv zzmU;
        public zzdr zzmV;
        public zzbm zzmW;
        public zzbn zzmX;
        public zzbc zzmY;
        public List<String> zzmZ;
        public zzk zzna;
        public zzff zznb = null;
        public View zznc = null;
        public int zznd = 0;
        public boolean zzne = false;
        public boolean zznf = false;
        public zzq zzng;
        private HashSet<zzfb> zznh = null;
        private int zzni = -1;
        private int zznj = -1;
        private zzfq zznk;

        public zzb(Context context, AdSizeParcel adSizeParcel, String string2, VersionInfoParcel versionInfoParcel) {
            this(context, adSizeParcel, string2, versionInfoParcel, null);
        }

        zzb(Context context, AdSizeParcel adSizeParcel, String string2, VersionInfoParcel versionInfoParcel, com.google.android.gms.internal.zzk zzk2) {
            zzat.zzo(context);
            if (adSizeParcel.zzpY || adSizeParcel.zzqa) {
                this.zzmM = null;
            } else {
                this.zzmM = new zza(context);
                this.zzmM.setMinimumWidth(adSizeParcel.widthPixels);
                this.zzmM.setMinimumHeight(adSizeParcel.heightPixels);
                this.zzmM.setVisibility(4);
            }
            if (context != null && context instanceof Activity && this.zzmM != null) {
                zzh.zzaQ().zza((Activity)context, this);
                zzh.zzaQ().zza((Activity)context, this);
            }
            this.zzmP = adSizeParcel;
            this.zzmG = string2;
            this.zzmH = context;
            this.zzmJ = versionInfoParcel;
            this.zzmI = zzk2 != null ? zzk2 : new com.google.android.gms.internal.zzk((com.google.android.gms.internal.zzg)new com.google.android.gms.ads.internal.zzd(this));
            this.zznk = new zzfq(200L);
        }

        public void zza(HashSet<zzfb> hashSet) {
            this.zznh = hashSet;
        }

        public HashSet<zzfb> zzaB() {
            return this.zznh;
        }

        public void zzaC() {
            if (this.zzmQ != null && this.zzmQ.zzwz != null) {
                this.zzmQ.zzwz.destroy();
            }
        }

        public void zzaD() {
            if (this.zzmQ != null && this.zzmQ.zzwz != null) {
                this.zzmQ.zzwz.stopLoading();
            }
        }

        public void zzaE() {
            if (this.zzmQ != null && this.zzmQ.zzuV != null) {
                try {
                    this.zzmQ.zzuV.destroy();
                }
                catch (RemoteException remoteException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzan("Could not destroy mediation adapter.");
                }
            }
        }

        public void onGlobalLayout() {
            this.zzf(false);
        }

        public void onScrollChanged() {
            this.zzf(true);
        }

        private void zzf(boolean bl) {
            if (this.zzmM != null && this.zzmQ != null && this.zzmQ.zzwz != null) {
                if (!this.zzmQ.zzwz.zzft().zzbg()) {
                    return;
                }
                if (bl && !this.zznk.tryAcquire()) {
                    return;
                }
                int[] nArray = new int[2];
                this.zzmM.getLocationOnScreen(nArray);
                int n = zzj.zzbJ().zzc(this.zzmH, nArray[0]);
                int n2 = zzj.zzbJ().zzc(this.zzmH, nArray[1]);
                if (n != this.zzni || n2 != this.zznj) {
                    this.zzni = n;
                    this.zznj = n2;
                    this.zzmQ.zzwz.zzft().zza(this.zzni, this.zznj, !bl);
                }
            }
        }

        public void zzg(boolean bl) {
            if (this.zznd == 0) {
                this.zzaD();
            }
            if (this.zzmK != null) {
                this.zzmK.cancel();
            }
            if (this.zzmO != null) {
                this.zzmO.cancel();
            }
            if (bl) {
                this.zzmQ = null;
            }
        }

        public void destroy() {
            this.zzmN = null;
            this.zzmT = null;
            this.zzmU = null;
            this.zzmV = null;
            this.zzmY = null;
            this.zzng = null;
            if (this.zzmH != null && this.zzmH instanceof Activity && this.zzmM != null) {
                zzh.zzaS().zzb((Activity)this.zzmH, this);
                zzh.zzaQ().zzb((Activity)this.zzmH, this);
            }
            this.zzg(false);
            if (this.zzmM != null) {
                this.zzmM.removeAllViews();
            }
            this.zzaC();
            this.zzaE();
            this.zzmQ = null;
        }
    }

    @zzeo
    public static final class zza
    extends ViewSwitcher {
        private final zzfn zzmF;

        public zza(Context context) {
            super(context);
            this.zzmF = new zzfn(context);
        }

        public boolean onInterceptTouchEvent(MotionEvent event) {
            this.zzmF.zzc(event);
            return false;
        }

        public void removeAllViews() {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View view = this.getChildAt(i);
                if (view == null || !(view instanceof zzgd)) continue;
                ((zzgd)view).destroy();
            }
            super.removeAllViews();
        }
    }
}

