/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.RemoteException;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.request.zze;
import com.google.android.gms.ads.internal.request.zzg;
import com.google.android.gms.ads.internal.request.zzi;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.internal.zzal;
import com.google.android.gms.internal.zzat;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzeq;
import com.google.android.gms.internal.zzfh;

@zzeo
public abstract class zzd
extends zzfh
implements zzc.zza {
    private final AdRequestInfoParcel zzul;
    private final zzc.zza zzyS;
    private final Object zzoe = new Object();
    private AdResponseParcel zzyi;

    public zzd(AdRequestInfoParcel adRequestInfoParcel, zzc.zza zza2) {
        this.zzul = adRequestInfoParcel;
        this.zzyS = zza2;
    }

    public abstract void zzeo();

    public abstract zzi zzep();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzyi = adResponseParcel;
            this.zzoe.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzcX() {
        try {
            zzi zzi2 = this.zzep();
            if (zzi2 == null) {
                AdResponseParcel adResponseParcel = new AdResponseParcel(0);
                this.zzyS.zzb(adResponseParcel);
            } else if (this.zza(zzi2, this.zzul)) {
                this.zzh(zzh.zzaU().elapsedRealtime());
            }
        }
        finally {
            this.zzeo();
        }
    }

    @Override
    public final void onStop() {
        this.zzeo();
    }

    boolean zza(zzi zzi2, AdRequestInfoParcel adRequestInfoParcel) {
        try {
            zzi2.zza(adRequestInfoParcel, new zzg(this));
            return true;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service.", remoteException);
            zzh.zzaT().zzc(remoteException, true);
        }
        catch (NullPointerException nullPointerException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service due to an Exception.", nullPointerException);
            zzh.zzaT().zzc(nullPointerException, true);
        }
        catch (SecurityException securityException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service due to an Exception.", securityException);
            zzh.zzaT().zzc(securityException, true);
        }
        catch (Throwable throwable) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service due to an Exception.", throwable);
            zzh.zzaT().zzc(throwable, true);
        }
        this.zzyS.zzb(new AdResponseParcel(0));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzh(long l) {
        Object object = this.zzoe;
        synchronized (object) {
            do {
                if (this.zzyi == null) continue;
                this.zzyS.zzb(this.zzyi);
                return;
            } while (this.zzd(l));
            if (this.zzyi != null) {
                this.zzyS.zzb(this.zzyi);
            } else {
                this.zzyS.zzb(new AdResponseParcel(0));
            }
            return;
        }
    }

    protected boolean zzd(long l) {
        long l2 = 60000L - (zzh.zzaU().elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzoe.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    @zzeo
    public static class zzb
    extends zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private final zzc.zza zzyS;
        private final Object zzoe = new Object();
        protected zze zzyT;

        public zzb(Context context, AdRequestInfoParcel adRequestInfoParcel, zzc.zza zza2) {
            super(adRequestInfoParcel, zza2);
            this.zzyS = zza2;
            this.zzyT = new zze(context, this, this, adRequestInfoParcel.zzmJ.zzCK);
            this.connect();
        }

        protected void connect() {
            this.zzyT.connect();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public zzi zzep() {
            Object object = this.zzoe;
            synchronized (object) {
                try {
                    return this.zzyT.zzes();
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzeo() {
            Object object = this.zzoe;
            synchronized (object) {
                if (this.zzyT.isConnected() || this.zzyT.isConnecting()) {
                    this.zzyT.disconnect();
                }
                Binder.flushPendingCommands();
            }
        }

        public void onConnectionFailed(ConnectionResult result) {
            this.zzyS.zzb(new AdResponseParcel(0));
        }

        public void onConnected(Bundle connectionHint) {
            this.zzeW();
        }

        public void onConnectionSuspended(int cause) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaj("Disconnected from remote ad request service.");
        }
    }

    @zzeo
    public static final class zza
    extends zzd {
        private final Context mContext;

        public zza(Context context, AdRequestInfoParcel adRequestInfoParcel, zzc.zza zza2) {
            super(adRequestInfoParcel, zza2);
            this.mContext = context;
        }

        @Override
        public zzi zzep() {
            zzal zzal2 = new zzal(zzat.zzrh.get());
            return zzeq.zza(this.mContext, zzal2, zzep.zzew());
        }

        @Override
        public void zzeo() {
        }
    }
}

