/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.zzf;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.internal.zzae;
import com.google.android.gms.internal.zzck;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzfa;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzfl;
import com.google.android.gms.internal.zzg;
import com.google.android.gms.internal.zzk;
import org.json.JSONException;
import org.json.JSONObject;

@zzeo
public class zzb
extends zzfh
implements zzc.zza {
    private final zza.zza zzyN;
    private final AdRequestInfoParcel.zza zzyO;
    private final Object zzyg = new Object();
    private final Context mContext;
    private final zzk zzsW;
    zzfh zzyP;
    Object zzoe = new Object();
    AdResponseParcel zzyi;
    zzck zzum;

    public zzb(Context context, AdRequestInfoParcel.zza zza2, zzk zzk2, zza.zza zza3) {
        this.zzyN = zza3;
        this.mContext = context;
        this.zzyO = zza2;
        this.zzsW = zzk2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        Object object = this.zzoe;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaj("Received ad response.");
            this.zzyi = adResponseParcel;
            this.zzoe.notify();
        }
    }

    zzfh zzb(AdRequestInfoParcel adRequestInfoParcel) {
        return zzc.zza(this.mContext, adRequestInfoParcel, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzcX() {
        Object object = this.zzoe;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaj("AdLoaderBackgroundTask started.");
            zzg zzg2 = this.zzsW.zzC();
            String string2 = zzg2.zza(this.mContext);
            zzf zzf2 = zzf.zzl(this.mContext);
            String string3 = zzf2.getClientId();
            AdRequestInfoParcel adRequestInfoParcel = new AdRequestInfoParcel(this.zzyO, string2, string3);
            AdSizeParcel adSizeParcel = null;
            int n = -2;
            long l = -1L;
            try {
                long l2 = zzh.zzaU().elapsedRealtime();
                zzfh zzfh2 = this.zzb(adRequestInfoParcel);
                Object object2 = this.zzyg;
                synchronized (object2) {
                    this.zzyP = zzfh2;
                    if (this.zzyP == null) {
                        throw new zza("Could not start the ad request service.", 0);
                    }
                }
                this.zzh(l2);
                l = zzh.zzaU().elapsedRealtime();
                this.zzen();
                if (adRequestInfoParcel.zzmP.zzpZ != null) {
                    adSizeParcel = this.zzc(adRequestInfoParcel);
                }
                this.zzw(this.zzyi.zzzD);
            }
            catch (zza zza2) {
                n = zza2.getErrorCode();
                if (n == 3 || n == -1) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzal(zza2.getMessage());
                } else {
                    com.google.android.gms.ads.internal.util.client.zzb.zzan(zza2.getMessage());
                }
                this.zzyi = this.zzyi == null ? new AdResponseParcel(n) : new AdResponseParcel(n, this.zzyi.zzuG);
                zzfl.zzCr.post(new Runnable(){

                    @Override
                    public void run() {
                        zzb.this.onStop();
                    }
                });
            }
            JSONObject jSONObject = null;
            if (!TextUtils.isEmpty((CharSequence)this.zzyi.zzzB)) {
                try {
                    jSONObject = new JSONObject(this.zzyi.zzzB);
                }
                catch (Exception exception) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("Error parsing the JSON for Active View.", exception);
                }
            }
            final zzfa.zza zza3 = new zzfa.zza(adRequestInfoParcel, this.zzyi, this.zzum, adSizeParcel, n, l, this.zzyi.zzzx, jSONObject);
            zzfl.zzCr.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = zzb.this.zzoe;
                    synchronized (object) {
                        zzb.this.zzyN.zza(zza3);
                    }
                }
            });
        }
    }

    protected void zzw(boolean bl) {
        zzh.zzaT().zzA(bl);
        zzae zzae2 = zzh.zzaT().zzs(this.mContext);
        if (zzae2 != null && !zzae2.isAlive()) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaj("start fetching content...");
            zzae2.zzbz();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzyg;
        synchronized (object) {
            if (this.zzyP != null) {
                this.zzyP.cancel();
            }
        }
    }

    protected void zzen() throws zza {
        if (this.zzyi.errorCode == -3) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzyi.zzzr)) {
            throw new zza("No fill from ad server.", 3);
        }
        zzh.zzaT().zza(this.mContext, this.zzyi.zzze);
        if (this.zzyi.zzzt) {
            try {
                this.zzum = new zzck(this.zzyi.zzzr);
            }
            catch (JSONException jSONException) {
                throw new zza("Could not parse mediation config: " + this.zzyi.zzzr, 0);
            }
        }
    }

    protected AdSizeParcel zzc(AdRequestInfoParcel adRequestInfoParcel) throws zza {
        int n;
        int n2;
        if (this.zzyi.zzzw == null) {
            throw new zza("The ad response must specify one of the supported ad sizes.", 0);
        }
        String[] stringArray = this.zzyi.zzzw.split("x");
        if (stringArray.length != 2) {
            throw new zza("Invalid ad size format from the ad response: " + this.zzyi.zzzw, 0);
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new zza("Invalid ad size number from the ad response: " + this.zzyi.zzzw, 0);
        }
        for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzmP.zzpZ) {
            int n3;
            float f = this.mContext.getResources().getDisplayMetrics().density;
            int n4 = adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / f) : adSizeParcel.width;
            int n5 = n3 = adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / f) : adSizeParcel.height;
            if (n2 != n4 || n != n3) continue;
            return new AdSizeParcel(adSizeParcel, adRequestInfoParcel.zzmP.zzpZ);
        }
        throw new zza("The ad size from the ad response was not one of the requested sizes: " + this.zzyi.zzzw, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzh(long l) throws zza {
        do {
            if (this.zzd(l)) continue;
            throw new zza("Timed out waiting for ad response.", 2);
        } while (this.zzyi == null);
        Object object = this.zzyg;
        synchronized (object) {
            this.zzyP = null;
        }
        if (this.zzyi.errorCode != -2 && this.zzyi.errorCode != -3) {
            throw new zza("There was a problem getting an ad response. ErrorCode: " + this.zzyi.errorCode, this.zzyi.errorCode);
        }
    }

    protected boolean zzd(long l) throws zza {
        long l2 = 60000L - (zzh.zzaU().elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzoe.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            throw new zza("Ad request cancelled.", -1);
        }
        return true;
    }

    @zzeo
    static final class zza
    extends Exception {
        private final int zzyl;

        public zza(String string2, int n) {
            super(string2);
            this.zzyl = n;
        }

        public int getErrorCode() {
            return this.zzyl;
        }
    }
}

