/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.text.TextUtils;
import android.util.Base64;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzeo;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

@zzeo
public class zzl {
    public static boolean zzc(String string2, String string3, String string4) {
        if (TextUtils.isEmpty((CharSequence)string3) || TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string4)) {
            zzb.zzak("Purchase verification failed: missing data.");
            return false;
        }
        PublicKey publicKey = zzl.zzW(string2);
        return zzl.zza(publicKey, string3, string4);
    }

    public static PublicKey zzW(String string2) {
        try {
            byte[] byArray = Base64.decode((String)string2, (int)0);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            zzb.zzak("Invalid key specification.");
            throw new IllegalArgumentException(invalidKeySpecException);
        }
    }

    public static boolean zza(PublicKey publicKey, String string2, String string3) {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initVerify(publicKey);
            signature.update(string2.getBytes());
            if (!signature.verify(Base64.decode((String)string3, (int)0))) {
                zzb.zzak("Signature verification failed.");
                return false;
            }
            return true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            zzb.zzak("NoSuchAlgorithmException.");
        }
        catch (InvalidKeyException invalidKeyException) {
            zzb.zzak("Invalid key specification.");
        }
        catch (SignatureException signatureException) {
            zzb.zzak("Signature exception.");
        }
        return false;
    }
}

