/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.MediaController;
import android.widget.TextView;
import android.widget.VideoView;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzfl;
import com.google.android.gms.internal.zzgd;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

@zzeo
public class zzg
extends FrameLayout
implements AudioManager.OnAudioFocusChangeListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener {
    private final zzgd zznp;
    private final MediaController zzwJ;
    private final zza zzwK;
    private final FrameLayout zzwL;
    private final VideoView zzwM;
    private TextView zzwN;
    private MediaPlayer zzwO;
    private boolean zzwP;
    private boolean zzwQ;
    private long zzwR;
    private long zzwS;
    private String zztN;
    private float zzwT;

    public static void zza(zzgd zzgd2, String string2, String string3) {
        boolean bl = string3 == null;
        HashMap<String, String> hashMap = new HashMap<String, String>(bl ? 2 : 3);
        hashMap.put("what", string2);
        if (!bl) {
            hashMap.put("extra", string3);
        }
        zzg.zza(zzgd2, "error", hashMap);
    }

    private static void zza(zzgd zzgd2, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        zzg.zza(zzgd2, string2, hashMap);
    }

    private static void zza(zzgd zzgd2, String string2, String string3, String string4) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put(string3, string4);
        zzg.zza(zzgd2, string2, hashMap);
    }

    private static void zza(zzgd zzgd2, String string2, Map<String, String> map) {
        map.put("event", string2);
        zzgd2.zzb("onVideoEvent", map);
    }

    public zzg(Context context, zzgd zzgd2) {
        super(context);
        this.zznp = zzgd2;
        this.zzwL = new FrameLayout(context);
        this.addView((View)this.zzwL);
        ContextWrapper contextWrapper = new ContextWrapper(context){

            public void sendBroadcast(Intent intent) {
            }
        };
        this.zzwM = new VideoView((Context)contextWrapper){

            protected void onWindowVisibilityChanged(int visibility) {
                super.onWindowVisibilityChanged(visibility);
                if (visibility == 0 && zzg.this.zzwO == null) {
                    zzg.this.zzdK();
                }
                if (visibility == 8) {
                    zzg.this.zzwS = zzg.this.zzwR;
                    zzg.this.zzwO = null;
                }
            }
        };
        this.zzwL.addView((View)this.zzwM, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        this.zzwN = new TextView(context);
        this.zzwN.setBackgroundColor(-16777216);
        this.zzdK();
        this.zzwJ = new MediaController(context);
        this.zzwT = 1.0f;
        this.zzwK = new zza(this);
        this.zzwK.zzdR();
        this.zzwM.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.zzwM.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.zzwM.setOnErrorListener((MediaPlayer.OnErrorListener)this);
    }

    public void zzf(int n, int n2, int n3, int n4) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzwL.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public void destroy() {
        AudioManager audioManager = this.zzdQ();
        if (audioManager != null) {
            audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
        }
        this.zzwK.cancel();
        this.zzwM.stopPlayback();
    }

    public void zzdF() {
        if (!TextUtils.isEmpty((CharSequence)this.zztN)) {
            this.zzwM.setVideoPath(this.zztN);
        } else {
            zzg.zza(this.zznp, "no_src", null);
        }
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        zzg.zza(this.zznp, "ended");
    }

    public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
        zzg.zza(this.zznp, String.valueOf(what), String.valueOf(extra));
        return true;
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        this.zzwO = mediaPlayer;
        if (this.zzwS == 0L) {
            final float f = (float)mediaPlayer.getDuration() / 1000.0f;
            final int n = mediaPlayer.getVideoWidth();
            final int n2 = mediaPlayer.getVideoHeight();
            HashMap<String, String> hashMap = new HashMap<String, String>(){
                {
                    this.put("duration", String.valueOf(f));
                    this.put("videoWidth", String.valueOf(n));
                    this.put("videoHeight", String.valueOf(n2));
                }
            };
            zzg.zza(this.zznp, "canplaythrough", (Map<String, String>)hashMap);
        } else {
            final int n = (int)this.zzwS;
            this.zzwM.post(new Runnable(){

                @Override
                public void run() {
                    if (zzg.this.zzwO != null) {
                        zzg.this.zzwO.seekTo(n);
                        zzg.this.zzwM.start();
                        zzg.this.zzwM.pause();
                    }
                }
            });
        }
        this.zzwO.setOnInfoListener(new MediaPlayer.OnInfoListener(){

            public boolean onInfo(MediaPlayer mp, int what, int extra) {
                if (what == 3) {
                    zzg.this.zzdL();
                }
                return false;
            }
        });
        this.zzdP();
    }

    public void onAudioFocusChange(int focusChange) {
        if (focusChange > 0) {
            this.zzdN();
        } else if (focusChange < 0) {
            this.zzdO();
        }
    }

    public void pause() {
        this.zzwM.pause();
    }

    public void play() {
        int n;
        AudioManager audioManager;
        if (!this.zzwQ && (audioManager = this.zzdQ()) != null && (n = audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 2)) == 1) {
            this.zzdN();
        }
        this.zzwM.start();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
    }

    public void seekTo(int timeInMilliseconds) {
        if (this.zzwO != null) {
            this.zzwM.seekTo(timeInMilliseconds);
        }
    }

    public void zzdG() {
        this.zzwP = true;
        this.zzdP();
    }

    public void zzdH() {
        this.zzwP = false;
        this.zzdP();
    }

    public void zza(float f) {
        this.zzwT = f;
        this.zzdP();
    }

    public void zzb(MotionEvent motionEvent) {
        this.zzwM.dispatchTouchEvent(motionEvent);
    }

    public void zzv(boolean bl) {
        if (bl) {
            this.zzwM.setMediaController(this.zzwJ);
        } else {
            this.zzwJ.hide();
            this.zzwM.setMediaController(null);
        }
    }

    public void zzT(String string2) {
        this.zztN = string2;
    }

    public void zzdI() {
        long l = this.zzwM.getCurrentPosition();
        if (this.zzwR != l && l > 0L) {
            this.zzdL();
            float f = (float)l / 1000.0f;
            zzg.zza(this.zznp, "timeupdate", "time", String.valueOf(f));
            this.zzwR = l;
        }
    }

    public void zzdJ() {
        Context context = this.zzwM.getContext();
        TextView textView = new TextView(context);
        textView.setText((CharSequence)"AdMob");
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzwL.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzwL.bringChildToFront((View)textView);
    }

    public void setBackgroundColor(int color) {
        super.setBackgroundColor(color);
    }

    private void zzb(float f) {
        if (this.zzwO != null) {
            try {
                this.zzwO.setVolume(f, f);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            zzb.zzan("AdVideoView setMediaPlayerVolume() called before onPrepared().");
        }
    }

    private void zzdK() {
        if (!this.zzdM()) {
            this.zzwL.addView((View)this.zzwN, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.zzwL.bringChildToFront((View)this.zzwN);
        }
    }

    private void zzdL() {
        if (this.zzdM()) {
            this.zzwL.removeView((View)this.zzwN);
        }
    }

    private boolean zzdM() {
        return this.zzwN.getParent() != null;
    }

    private void zzdN() {
        this.zzwQ = true;
        this.zzdP();
    }

    private void zzdO() {
        this.zzwQ = false;
        this.zzdP();
    }

    private void zzdP() {
        if (!this.zzwP && this.zzwQ) {
            this.zzb(this.zzwT);
        } else {
            this.zzb(0.0f);
        }
    }

    private AudioManager zzdQ() {
        Context context = this.zzwM.getContext();
        return (AudioManager)context.getSystemService("audio");
    }

    private static final class zza {
        private final Runnable zznB;
        private volatile boolean zzwZ = false;

        public zza(final zzg zzg2) {
            this.zznB = new Runnable(){
                private final WeakReference<zzg> zzxa;
                {
                    this.zzxa = new WeakReference<zzg>(zzg2);
                }

                @Override
                public void run() {
                    zzg zzg22 = (zzg)((Object)this.zzxa.get());
                    if (!zza.this.zzwZ && zzg22 != null) {
                        zzg22.zzdI();
                        zza.this.zzdR();
                    }
                }
            };
        }

        public void cancel() {
            this.zzwZ = true;
            zzfl.zzCr.removeCallbacks(this.zznB);
        }

        public void zzdR() {
            zzfl.zzCr.postDelayed(this.zznB, 250L);
        }
    }
}

