/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.internal.zzdj;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzfn;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzge;

@zzeo
public class zzc
extends zzdj.zza
implements zzj {
    static final int zzwe = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity zzpf;
    AdOverlayInfoParcel zzwf;
    zzg zzwg;
    zzgd zznp;
    zzc zzwh;
    com.google.android.gms.ads.internal.overlay.zzh zzwi;
    boolean zzwj = false;
    FrameLayout zzwk;
    WebChromeClient.CustomViewCallback zzwl;
    boolean zzwm = false;
    boolean zzwn = false;
    RelativeLayout zzvB;
    boolean zzwo = false;
    int zzwp = 0;
    private boolean zzwq;
    private boolean zzwr = false;
    private boolean zzws = true;

    public zzc(Activity activity) {
        this.zzpf = activity;
    }

    public void close() {
        this.zzwp = 2;
        this.zzpf.finish();
    }

    public zzg zzds() {
        return this.zzwg;
    }

    public void zzdt() {
        if (this.zzwf != null && this.zzwj) {
            this.setRequestedOrientation(this.zzwf.orientation);
        }
        if (this.zzwk != null) {
            this.zzpf.setContentView((View)this.zzvB);
            this.zzab();
            this.zzwk.removeAllViews();
            this.zzwk = null;
        }
        if (this.zzwl != null) {
            this.zzwl.onCustomViewHidden();
            this.zzwl = null;
        }
        this.zzwj = false;
    }

    public void zzd(int n, int n2, int n3, int n4) {
        if (this.zzwg != null) {
            this.zzwg.zzf(n, n2, n3, n4);
        }
    }

    public void zze(int n, int n2, int n3, int n4) {
        if (this.zzwg == null) {
            this.zzwg = new zzg((Context)this.zzpf, this.zznp);
            this.zzvB.addView((View)this.zzwg, 0, new ViewGroup.LayoutParams(-1, -1));
            this.zzwg.zzf(n, n2, n3, n4);
            this.zznp.zzft().zzD(false);
        }
    }

    @Override
    public void zzdu() {
        this.zzwp = 1;
        this.zzpf.finish();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.zzwm = savedInstanceState != null ? savedInstanceState.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzwf = AdOverlayInfoParcel.zzb(this.zzpf.getIntent());
            if (this.zzwf == null) {
                throw new zza("Could not get info for ad overlay.");
            }
            if (this.zzpf.getIntent() != null) {
                this.zzws = this.zzpf.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzwn = this.zzwf.zzwI != null ? this.zzwf.zzwI.zznf : false;
            if (savedInstanceState == null) {
                if (this.zzwf.zzwy != null && this.zzws) {
                    this.zzwf.zzwy.zzak();
                }
                if (this.zzwf.zzwF != 1 && this.zzwf.zzwx != null) {
                    this.zzwf.zzwx.onAdClicked();
                }
            }
            this.zzvB = new zzb((Context)this.zzpf, this.zzwf.zzwH);
            switch (this.zzwf.zzwF) {
                case 1: {
                    this.zzu(false);
                    break;
                }
                case 2: {
                    this.zzwh = new zzc(this.zzwf.zzwz);
                    this.zzu(false);
                    break;
                }
                case 3: {
                    this.zzu(true);
                    break;
                }
                case 4: {
                    if (this.zzwm) {
                        this.zzwp = 3;
                        this.zzpf.finish();
                        break;
                    }
                    if (!zzh.zzaN().zza((Context)this.zzpf, this.zzwf.zzww, this.zzwf.zzwE)) {
                        this.zzwp = 3;
                        this.zzpf.finish();
                    }
                    break;
                }
                default: {
                    throw new zza("Could not determine ad overlay type.");
                }
            }
        }
        catch (zza zza2) {
            com.google.android.gms.ads.internal.util.client.zzb.zzan(zza2.getMessage());
            this.zzwp = 3;
            this.zzpf.finish();
        }
    }

    @Override
    public void onRestart() {
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onResume() {
        if (this.zzwf != null && this.zzwf.zzwF == 4) {
            if (this.zzwm) {
                this.zzwp = 3;
                this.zzpf.finish();
            } else {
                this.zzwm = true;
            }
        }
        if (this.zznp != null && !this.zznp.isDestroyed()) {
            zzh.zzaS().zzb(this.zznp.getWebView());
        } else {
            com.google.android.gms.ads.internal.util.client.zzb.zzan("The webview does not exit. Ignoring action.");
        }
    }

    @Override
    public void onPause() {
        if (this.zzwg != null) {
            this.zzwg.pause();
        }
        this.zzdt();
        if (!(this.zznp == null || this.zzpf.isFinishing() && this.zzwh != null)) {
            zzh.zzaS().zza(this.zznp.getWebView());
        }
        this.zzdw();
    }

    @Override
    public void onSaveInstanceState(Bundle outBundle) {
        outBundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzwm);
    }

    @Override
    public void onStop() {
        this.zzdw();
    }

    @Override
    public void onDestroy() {
        if (this.zzwg != null) {
            this.zzwg.destroy();
        }
        if (this.zznp != null) {
            this.zzvB.removeView((View)this.zznp.getWebView());
        }
        this.zzdw();
    }

    public void zzt(boolean bl) {
        int n = bl ? 50 : 32;
        this.zzwi = new com.google.android.gms.ads.internal.overlay.zzh((Context)this.zzpf, n, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zzwi.zza(bl, this.zzwf.zzwC);
        this.zzvB.addView((View)this.zzwi, (ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public void zzab() {
        this.zzwq = true;
    }

    public void zza(boolean bl, boolean bl2) {
        if (this.zzwi != null) {
            this.zzwi.zza(bl, bl2);
        }
    }

    public void zzdv() {
        this.zzvB.removeView((View)this.zzwi);
        this.zzt(true);
    }

    public void setRequestedOrientation(int requestedOrientation) {
        this.zzpf.setRequestedOrientation(requestedOrientation);
    }

    public void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzwk = new FrameLayout((Context)this.zzpf);
        this.zzwk.setBackgroundColor(-16777216);
        this.zzwk.addView(view, -1, -1);
        this.zzpf.setContentView((View)this.zzwk);
        this.zzab();
        this.zzwl = customViewCallback;
        this.zzwj = true;
    }

    protected void zzu(boolean bl) throws zza {
        Window window;
        if (!this.zzwq) {
            this.zzpf.requestWindowFeature(1);
        }
        if ((window = this.zzpf.getWindow()) == null) {
            throw new zza("Invalid activity, no window available.");
        }
        if (!this.zzwn || this.zzwf.zzwI != null && this.zzwf.zzwI.zznt) {
            window.setFlags(1024, 1024);
        }
        boolean bl2 = this.zzwf.zzwz.zzft().zzbg();
        this.zzwo = false;
        if (bl2) {
            if (this.zzwf.orientation == zzh.zzaS().zzfe()) {
                this.zzwo = this.zzpf.getResources().getConfiguration().orientation == 1;
            } else if (this.zzwf.orientation == zzh.zzaS().zzff()) {
                this.zzwo = this.zzpf.getResources().getConfiguration().orientation == 2;
            }
        }
        com.google.android.gms.ads.internal.util.client.zzb.zzaj("Delay onShow to next orientation change: " + this.zzwo);
        this.setRequestedOrientation(this.zzwf.orientation);
        if (zzh.zzaS().zza(window)) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaj("Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzwn) {
            this.zzvB.setBackgroundColor(-16777216);
        } else {
            this.zzvB.setBackgroundColor(zzwe);
        }
        this.zzpf.setContentView((View)this.zzvB);
        this.zzab();
        if (bl) {
            this.zznp = zzh.zzaR().zza((Context)this.zzpf, this.zzwf.zzwz.zzah(), true, bl2, null, this.zzwf.zzmJ);
            this.zznp.zzft().zzb(null, null, this.zzwf.zzwA, this.zzwf.zzwE, true, this.zzwf.zzwG, null, this.zzwf.zzwz.zzft().zzfA(), null);
            this.zznp.zzft().zza(new zzge.zza(){

                @Override
                public void zza(zzgd zzgd2, boolean bl) {
                    zzgd2.zzft().zzfG();
                    zzgd2.zzdy();
                }
            });
            if (this.zzwf.zzwa != null) {
                this.zznp.loadUrl(this.zzwf.zzwa);
            } else if (this.zzwf.zzwD != null) {
                this.zznp.loadDataWithBaseURL(this.zzwf.zzwB, this.zzwf.zzwD, "text/html", "UTF-8", null);
            } else {
                throw new zza("No URL or HTML to display in ad overlay.");
            }
            if (this.zzwf.zzwz != null) {
                this.zzwf.zzwz.zzb(this);
            }
        } else {
            this.zznp = this.zzwf.zzwz;
            this.zznp.setContext((Context)this.zzpf);
        }
        this.zznp.zza(this);
        ViewParent viewParent = this.zznp.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView((View)this.zznp.getWebView());
        }
        if (this.zzwn) {
            this.zznp.setBackgroundColor(zzwe);
        }
        this.zzvB.addView((View)this.zznp.getWebView(), -1, -1);
        if (!bl && !this.zzwo) {
            this.zzdy();
        }
        this.zzt(bl2);
        if (this.zznp.zzfu()) {
            this.zza(bl2, true);
        }
    }

    protected void zzdw() {
        if (!this.zzpf.isFinishing() || this.zzwr) {
            return;
        }
        this.zzwr = true;
        if (this.zzpf.isFinishing()) {
            if (this.zznp != null) {
                this.zzp(this.zzwp);
                this.zzvB.removeView((View)this.zznp.getWebView());
                if (this.zzwh != null) {
                    this.zznp.setContext(this.zzwh.zzmH);
                    this.zznp.zzB(false);
                    this.zzwh.zzwv.addView((View)this.zznp.getWebView(), this.zzwh.index, this.zzwh.zzwu);
                    this.zzwh = null;
                }
            }
            if (this.zzwf != null && this.zzwf.zzwy != null) {
                this.zzwf.zzwy.zzaj();
            }
        }
    }

    public void zzdx() {
        if (this.zzwo) {
            this.zzwo = false;
            this.zzdy();
        }
    }

    protected void zzdy() {
        this.zznp.zzdy();
    }

    protected void zzp(int n) {
        this.zznp.zzp(n);
    }

    @zzeo
    static final class zzb
    extends RelativeLayout {
        zzfn zzmF;

        public zzb(Context context, String string2) {
            super(context);
            this.zzmF = new zzfn(context, string2);
        }

        public boolean onInterceptTouchEvent(MotionEvent event) {
            this.zzmF.zzc(event);
            return false;
        }
    }

    @zzeo
    public static class zzc {
        public final int index;
        public final ViewGroup.LayoutParams zzwu;
        public final ViewGroup zzwv;
        public final Context zzmH;

        public zzc(zzgd zzgd2) throws zza {
            this.zzwu = zzgd2.getLayoutParams();
            ViewParent viewParent = zzgd2.getParent();
            this.zzmH = zzgd2.zzfq();
            if (viewParent == null || !(viewParent instanceof ViewGroup)) {
                throw new zza("Could not get the parent of the WebView for an overlay.");
            }
            this.zzwv = (ViewGroup)viewParent;
            this.index = this.zzwv.indexOfChild((View)zzgd2.getWebView());
            this.zzwv.removeView((View)zzgd2.getWebView());
            zzgd2.zzB(true);
        }
    }

    @zzeo
    private static final class zza
    extends Exception {
        public zza(String string2) {
            super(string2);
        }
    }
}

