/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.AdLauncherIntentInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzeo;

@zzeo
public class zza {
    public boolean zza(Context context, AdLauncherIntentInfoParcel adLauncherIntentInfoParcel, zzi zzi2) {
        String[] stringArray;
        if (adLauncherIntentInfoParcel == null) {
            zzb.zzan("No intent data for launcher overlay.");
            return false;
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.zzwa)) {
            zzb.zzan("Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.mimeType)) {
            intent.setDataAndType(Uri.parse((String)adLauncherIntentInfoParcel.zzwa), adLauncherIntentInfoParcel.mimeType);
        } else {
            intent.setData(Uri.parse((String)adLauncherIntentInfoParcel.zzwa));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.packageName)) {
            intent.setPackage(adLauncherIntentInfoParcel.packageName);
        }
        if (!TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.zzwb)) {
            stringArray = adLauncherIntentInfoParcel.zzwb.split("/", 2);
            if (stringArray.length < 2) {
                zzb.zzan("Could not parse component name from open GMSG: " + adLauncherIntentInfoParcel.zzwb);
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        if (!TextUtils.isEmpty((CharSequence)(stringArray = adLauncherIntentInfoParcel.zzwc))) {
            int n = 0;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zzb.zzan("Could not parse intent flags.");
            }
            intent.addFlags(n);
        }
        try {
            zzb.zzam("Launching an intent: " + intent.toURI());
            context.startActivity(intent);
            if (zzi2 != null) {
                zzi2.zzai();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzb.zzan(activityNotFoundException.getMessage());
            return false;
        }
        return true;
    }
}

