/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzb;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzf;
import com.google.android.gms.ads.internal.client.zzh;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.client.zzn;
import com.google.android.gms.ads.internal.client.zzt;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.internal.zzbd;
import com.google.android.gms.internal.zzcq;
import com.google.android.gms.internal.zzdw;
import com.google.android.gms.internal.zzea;

public class zzv {
    private final zzcq zzqB = new zzcq();
    private final Context mContext;
    private final zzf zzqC;
    private AdListener zzpH;
    private zza zzpG;
    private zzn zzqE;
    private String zzqd;
    private String zzqF;
    private AppEventListener zzqb;
    private PlayStorePurchaseListener zzqI;
    private InAppPurchaseListener zzqH;
    private PublisherInterstitialAd zzqK;
    private OnCustomRenderedAdLoadedListener zzqJ;

    public zzv(Context context) {
        this(context, zzf.zzbG(), null);
    }

    public zzv(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zzf.zzbG(), publisherInterstitialAd);
    }

    public zzv(Context context, zzf zzf2, PublisherInterstitialAd publisherInterstitialAd) {
        this.mContext = context;
        this.zzqC = zzf2;
        this.zzqK = publisherInterstitialAd;
    }

    public AdListener getAdListener() {
        return this.zzpH;
    }

    public String getAdUnitId() {
        return this.zzqd;
    }

    public AppEventListener getAppEventListener() {
        return this.zzqb;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzqH;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzqJ;
    }

    public boolean isLoaded() {
        try {
            if (this.zzqE == null) {
                return false;
            }
            return this.zzqE.isReady();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to check if ad is ready.", remoteException);
            return false;
        }
    }

    public void zza(zzt zzt2) {
        try {
            if (this.zzqE == null) {
                this.zzA("loadAd");
            }
            if (this.zzqE.zza(this.zzqC.zza(this.mContext, zzt2))) {
                this.zzqB.zze(zzt2.zzbP());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to load ad.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.zzpH = adListener;
            if (this.zzqE != null) {
                this.zzqE.zza(adListener != null ? new zzc(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(zza zza2) {
        try {
            this.zzpG = zza2;
            if (this.zzqE != null) {
                this.zzqE.zza(zza2 != null ? new zzb(zza2) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdUnitId(String adUnitId) {
        if (this.zzqd != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zzqd = adUnitId;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzqb = appEventListener;
            if (this.zzqE != null) {
                this.zzqE.zza(appEventListener != null ? new zzh(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzqI != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzqH = inAppPurchaseListener;
            if (this.zzqE != null) {
                this.zzqE.zza(inAppPurchaseListener != null ? new zzdw(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzqJ = onCustomRenderedAdLoadedListener;
            if (this.zzqE != null) {
                this.zzqE.zza(onCustomRenderedAdLoadedListener != null ? new zzbd(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the OnCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        if (this.zzqH != null) {
            throw new IllegalStateException("In app purchase parameter has already been set.");
        }
        try {
            this.zzqI = playStorePurchaseListener;
            this.zzqF = publicKey;
            if (this.zzqE != null) {
                this.zzqE.zza(playStorePurchaseListener != null ? new zzea(playStorePurchaseListener) : null, publicKey);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzqE != null) {
                return this.zzqE.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public void show() {
        try {
            this.zzB("show");
            this.zzqE.showInterstitial();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to show interstitial.", remoteException);
        }
    }

    private void zzA(String string2) throws RemoteException {
        if (this.zzqd == null) {
            this.zzB(string2);
        }
        this.zzqE = zzj.zzbK().zza(this.mContext, new AdSizeParcel(), this.zzqd, this.zzqB);
        if (this.zzpH != null) {
            this.zzqE.zza(new zzc(this.zzpH));
        }
        if (this.zzpG != null) {
            this.zzqE.zza(new zzb(this.zzpG));
        }
        if (this.zzqb != null) {
            this.zzqE.zza(new zzh(this.zzqb));
        }
        if (this.zzqH != null) {
            this.zzqE.zza(new zzdw(this.zzqH));
        }
        if (this.zzqI != null) {
            this.zzqE.zza(new zzea(this.zzqI), this.zzqF);
        }
        if (this.zzqJ != null) {
            this.zzqE.zza(new zzbd(this.zzqJ));
        }
    }

    private void zzB(String string2) {
        if (this.zzqE == null) {
            throw new IllegalStateException("The ad unit ID must be set on InterstitialAd before " + string2 + " is called.");
        }
    }
}

