/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzb;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzf;
import com.google.android.gms.ads.internal.client.zzh;
import com.google.android.gms.ads.internal.client.zzi;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.client.zzn;
import com.google.android.gms.ads.internal.client.zzt;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzbd;
import com.google.android.gms.internal.zzcq;
import com.google.android.gms.internal.zzdw;
import com.google.android.gms.internal.zzea;
import java.util.concurrent.atomic.AtomicBoolean;

public class zzu {
    private final zzcq zzqB = new zzcq();
    private final zzf zzqC;
    private final AtomicBoolean zzqD;
    private AdListener zzpH;
    private zza zzpG;
    private zzn zzqE;
    private AdSize[] zzqc;
    private String zzqd;
    private String zzqF;
    private ViewGroup zzqG;
    private AppEventListener zzqb;
    private InAppPurchaseListener zzqH;
    private PlayStorePurchaseListener zzqI;
    private OnCustomRenderedAdLoadedListener zzqJ;

    public zzu(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzf.zzbG());
    }

    public zzu(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzf.zzbG());
    }

    zzu(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzf zzf2, zzn zzn2) {
        this.zzqG = viewGroup;
        this.zzqC = zzf2;
        this.zzqE = zzn2;
        this.zzqD = new AtomicBoolean(false);
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzi zzi2 = new zzi(context, attributeSet);
                this.zzqc = zzi2.zzj(bl);
                this.zzqd = zzi2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzj.zzbJ().zza(viewGroup, new AdSizeParcel(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                zzj.zzbJ().zza(viewGroup, new AdSizeParcel(context, this.zzqc[0]), "Ads by Google");
            }
        }
    }

    zzu(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzf zzf2) {
        this(viewGroup, attributeSet, bl, zzf2, null);
    }

    public void destroy() {
        try {
            if (this.zzqE != null) {
                this.zzqE.destroy();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to destroy AdView.", remoteException);
        }
    }

    public AdListener getAdListener() {
        return this.zzpH;
    }

    public AdSize getAdSize() {
        try {
            AdSizeParcel adSizeParcel;
            if (this.zzqE != null && (adSizeParcel = this.zzqE.zzah()) != null) {
                return adSizeParcel.zzbH();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the current AdSize.", remoteException);
        }
        return this.zzqc != null ? this.zzqc[0] : null;
    }

    public AdSize[] getAdSizes() {
        return this.zzqc;
    }

    public String getAdUnitId() {
        return this.zzqd;
    }

    public AppEventListener getAppEventListener() {
        return this.zzqb;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzqH;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzqJ;
    }

    public void zza(zzt zzt2) {
        try {
            if (this.zzqE == null) {
                this.zzbU();
            }
            if (this.zzqE.zza(this.zzqC.zza(this.zzqG.getContext(), zzt2))) {
                this.zzqB.zze(zzt2.zzbP());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to load ad.", remoteException);
        }
    }

    public void pause() {
        try {
            if (this.zzqE != null) {
                this.zzqE.pause();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call pause.", remoteException);
        }
    }

    public void recordManualImpression() {
        if (this.zzqD.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzqE != null) {
                this.zzqE.zzar();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to record impression.", remoteException);
        }
    }

    public void resume() {
        try {
            if (this.zzqE != null) {
                this.zzqE.resume();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call resume.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.zzpH = adListener;
            if (this.zzqE != null) {
                this.zzqE.zza(adListener != null ? new zzc(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(zza zza2) {
        try {
            this.zzpG = zza2;
            if (this.zzqE != null) {
                this.zzqE.zza(zza2 != null ? new zzb(zza2) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdSizes(AdSize ... adSizes) {
        if (this.zzqc != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizes);
    }

    public void zza(AdSize ... adSizeArray) {
        this.zzqc = adSizeArray;
        try {
            if (this.zzqE != null) {
                this.zzqE.zza(new AdSizeParcel(this.zzqG.getContext(), this.zzqc));
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the ad size.", remoteException);
        }
        this.zzqG.requestLayout();
    }

    public void setAdUnitId(String adUnitId) {
        if (this.zzqd != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzqd = adUnitId;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzqb = appEventListener;
            if (this.zzqE != null) {
                this.zzqE.zza(appEventListener != null ? new zzh(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzqI != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzqH = inAppPurchaseListener;
            if (this.zzqE != null) {
                this.zzqE.zza(inAppPurchaseListener != null ? new zzdw(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzqJ = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzqE != null) {
                this.zzqE.zza(onCustomRenderedAdLoadedListener != null ? new zzbd(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        if (this.zzqH != null) {
            throw new IllegalStateException("InAppPurchaseListener has already been set.");
        }
        try {
            this.zzqI = playStorePurchaseListener;
            this.zzqF = publicKey;
            if (this.zzqE != null) {
                this.zzqE.zza(playStorePurchaseListener != null ? new zzea(playStorePurchaseListener) : null, publicKey);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzqE != null) {
                return this.zzqE.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    private void zzbT() {
        try {
            zzd zzd2 = this.zzqE.zzag();
            if (zzd2 == null) {
                return;
            }
            this.zzqG.addView((View)zze.zzg((zzd)zzd2));
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get an ad frame.", remoteException);
        }
    }

    private void zzbU() throws RemoteException {
        if ((this.zzqc == null || this.zzqd == null) && this.zzqE == null) {
            throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
        }
        Context context = this.zzqG.getContext();
        this.zzqE = zzj.zzbK().zza(context, new AdSizeParcel(context, this.zzqc), this.zzqd, this.zzqB);
        if (this.zzpH != null) {
            this.zzqE.zza(new zzc(this.zzpH));
        }
        if (this.zzpG != null) {
            this.zzqE.zza(new zzb(this.zzpG));
        }
        if (this.zzqb != null) {
            this.zzqE.zza(new zzh(this.zzqb));
        }
        if (this.zzqH != null) {
            this.zzqE.zza(new zzdw(this.zzqH));
        }
        if (this.zzqI != null) {
            this.zzqE.zza(new zzea(this.zzqI), this.zzqF);
        }
        if (this.zzqJ != null) {
            this.zzqE.zza(new zzbd(this.zzqJ));
        }
        this.zzqE.zza(zzj.zzbL());
        this.zzbT();
    }
}

